/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.imgloaders;

import ij.IJ;
import ij.ImagePlus;
import ij.io.Opener;
import ij.process.ImageProcessor;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelSeparator;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import ome.units.quantity.Length;
import spim.fiji.datasetmanager.StackListLOCI;
import spim.fiji.spimdata.imgloaders.CalibratedImg;
import spim.fiji.spimdata.imgloaders.Calibration;
import spim.fiji.spimdata.imgloaders.LegacyStackImgLoader;

public class LegacyStackImgLoaderLOCI
extends LegacyStackImgLoader {
    public LegacyStackImgLoaderLOCI(File path, String fileNamePattern, ImgFactory<? extends NativeType<?>> imgFactory, int layoutTP, int layoutChannels, int layoutIllum, int layoutAngles, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        super(path, fileNamePattern, imgFactory, layoutTP, layoutChannels, layoutIllum, layoutAngles, sequenceDescription);
    }

    public RandomAccessibleInterval<FloatType> getFloatImage(ViewId view, boolean normalize) {
        File file = this.getFile(view);
        if (file == null) {
            throw new RuntimeException("Could not find file '" + file + "'.");
        }
        try {
            CalibratedImg<FloatType> img = this.openLOCI(file, new FloatType(), view);
            if (img == null) {
                throw new RuntimeException("Could not load '" + file + "'");
            }
            if (normalize) {
                float min = Float.MAX_VALUE;
                float max = -3.4028235E38f;
                for (FloatType t : img.getImg()) {
                    float v = t.get();
                    if (v < min) {
                        min = v;
                    }
                    if (!(v > max)) continue;
                    max = v;
                }
                for (FloatType t : img.getImg()) {
                    t.set((t.get() - min) / (max - min));
                }
            }
            this.updateMetaDataCache(view, (int)img.getImg().dimension(0), (int)img.getImg().dimension(1), (int)img.getImg().dimension(2), img.getCalX(), img.getCalY(), img.getCalZ());
            return img.getImg();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load '" + file + "':\n" + e);
        }
    }

    public RandomAccessibleInterval<UnsignedShortType> getImage(ViewId view) {
        File file = this.getFile(view);
        if (file == null) {
            throw new RuntimeException("Could not find file '" + file + "'.");
        }
        try {
            CalibratedImg<UnsignedShortType> img = this.openLOCI(file, new UnsignedShortType(), view);
            if (img == null) {
                throw new RuntimeException("Could not load '" + file + "'");
            }
            this.updateMetaDataCache(view, (int)img.getImg().dimension(0), (int)img.getImg().dimension(1), (int)img.getImg().dimension(2), img.getCalX(), img.getCalY(), img.getCalZ());
            return img.getImg();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not load '" + file + "': " + e);
        }
    }

    protected <T extends RealType<T> & NativeType<T>> CalibratedImg<T> openLOCI(File path, T type, ViewId view) throws Exception {
        double calZ;
        double calY;
        double calX;
        BasicViewDescription viewDescription = (BasicViewDescription)this.sequenceDescription.getViewDescriptions().get(view);
        if (path.isDirectory()) {
            Object[] files = path.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    File newFile = new File(dir, name);
                    return !newFile.isHidden() && !newFile.isDirectory();
                }
            });
            Arrays.sort(files);
            int depth = files.length;
            Opener io = new Opener();
            ImagePlus imp2d = io.openImage(path.getAbsolutePath() + File.separator + (String)files[0]);
            if (imp2d.getStack().getSize() > 1) {
                IOFunctions.printlnSafe("This is not a two-dimensional file: '" + path + "'");
                imp2d.close();
                return null;
            }
            Img<NativeType<T>> output = this.instantiateImg(new long[]{imp2d.getWidth(), imp2d.getHeight(), depth}, type);
            if (output == null) {
                throw new RuntimeException("Could not instantiate " + this.getImgFactory().getClass().getSimpleName() + " for '" + path + "', most likely out of memory.");
            }
            IOFunctions.printlnSafe(new Date(System.currentTimeMillis()) + ": Opening '" + path + "' [" + imp2d.getWidth() + "x" + imp2d.getHeight() + "x" + depth + " type=" + imp2d.getProcessor().getClass().getSimpleName() + " image=" + output.getClass().getSimpleName() + "<" + type.getClass().getSimpleName() + ">]");
            for (int z = 0; z < depth; ++z) {
                imp2d = io.openImage(path.getAbsolutePath() + File.separator + (String)files[z]);
                ImageProcessor ip = imp2d.getProcessor();
                Cursor cursor = Views.iterable((RandomAccessibleInterval)Views.hyperSlice(output, (int)2, (long)z)).localizingCursor();
                while (cursor.hasNext()) {
                    cursor.fwd();
                    ((RealType)cursor.get()).setReal(ip.getPixelValue(cursor.getIntPosition(0), cursor.getIntPosition(1)));
                }
            }
            return new CalibratedImg<NativeType<T>>(output);
        }
        ChannelSeparator r = new ChannelSeparator();
        if (!LegacyStackImgLoaderLOCI.createOMEXMLMetadata((IFormatReader)r)) {
            try {
                r.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
        String id = path.getAbsolutePath();
        r.setId(id);
        boolean isLittleEndian = r.isLittleEndian();
        int width = r.getSizeX();
        int height = r.getSizeY();
        int depth = r.getSizeZ();
        int timepoints = r.getSizeT();
        int channels = r.getSizeC();
        int pixelType = r.getPixelType();
        int bytesPerPixel = FormatTools.getBytesPerPixel((int)pixelType);
        String pixelTypeString = FormatTools.getPixelTypeString((int)pixelType);
        MetadataRetrieve retrieve = (MetadataRetrieve)r.getMetadataStore();
        try {
            float cal = retrieve.getPixelsPhysicalSizeX(0).value().floatValue();
            if (cal == 0.0f) {
                cal = 1.0f;
                IOFunctions.printlnSafe("StackListLOCI: Warning, calibration for dimension X seems corrupted, setting to 1.");
            }
            calX = cal;
            cal = retrieve.getPixelsPhysicalSizeY(0).value().floatValue();
            if (cal == 0.0f) {
                cal = 1.0f;
                IOFunctions.printlnSafe("StackListLOCI: Warning, calibration for dimension Y seems corrupted, setting to 1.");
            }
            calY = cal;
            cal = retrieve.getPixelsPhysicalSizeZ(0).value().floatValue();
            if (cal == 0.0f) {
                cal = 1.0f;
                IOFunctions.printlnSafe("StackListLOCI: Warning, calibration for dimension Z seems corrupted, setting to 1.");
            }
            calZ = cal;
        }
        catch (Exception e) {
            IOFunctions.printlnSafe("Failed to read calibration, setting to 1x1x1um.");
            calZ = 1.0;
            calY = 1.0;
            calX = 1.0;
        }
        int t = 0;
        int c = 0;
        if (this.layoutTP == 2 && (t = Integer.parseInt(viewDescription.getTimePoint().getName())) >= timepoints) {
            r.close();
            throw new RuntimeException("File '" + path + "' has only timepoints [0 ... " + (timepoints - 1) + "], but you want to open timepoint " + t + ". Stopping.");
        }
        if (this.layoutChannels == 2 && (c = Integer.parseInt(((Channel)viewDescription.getViewSetup().getAttribute(Channel.class)).getName())) >= channels) {
            r.close();
            throw new RuntimeException("File '" + path + "' has only channels [0 ... " + (channels - 1) + "], but you want to open channel " + c + ". Stopping.");
        }
        if (pixelType != 1 && pixelType != 3 && pixelType != 5 && pixelType != 6) {
            IOFunctions.printlnSafe("StackImgLoaderLOCI.openLOCI(): PixelType " + pixelTypeString + " not supported by " + type.getClass().getSimpleName() + ", returning. ");
            r.close();
            return null;
        }
        Img<NativeType<T>> img = this.instantiateImg(new long[]{width, height, depth}, type);
        if (img == null) {
            r.close();
            throw new RuntimeException("Could not instantiate " + this.getImgFactory().getClass().getSimpleName() + " for '" + path + "', most likely out of memory.");
        }
        IOFunctions.printlnSafe(new Date(System.currentTimeMillis()) + ": Opening '" + path + "' [" + width + "x" + height + "x" + depth + " ch=" + c + " tp=" + t + " type=" + pixelTypeString + " image=" + img.getClass().getSimpleName() + "<" + type.getClass().getSimpleName() + ">]");
        byte[] b = new byte[width * height * bytesPerPixel];
        boolean planeX = false;
        boolean planeY = true;
        for (int z = 0; z < depth; ++z) {
            IJ.showProgress((double)((double)z / (double)depth));
            Cursor cursor = Views.iterable((RandomAccessibleInterval)Views.hyperSlice(img, (int)2, (long)z)).localizingCursor();
            r.openBytes(r.getIndex(z, c, t), b);
            if (pixelType == 1) {
                while (cursor.hasNext()) {
                    cursor.fwd();
                    ((RealType)cursor.get()).setReal((float)(b[cursor.getIntPosition(0) + cursor.getIntPosition(1) * width] & 0xFF));
                }
                continue;
            }
            if (pixelType == 3) {
                while (cursor.hasNext()) {
                    cursor.fwd();
                    ((RealType)cursor.get()).setReal((float)LegacyStackImgLoaderLOCI.getShortValueInt(b, (cursor.getIntPosition(0) + cursor.getIntPosition(1) * width) * 2, isLittleEndian));
                }
                continue;
            }
            if (pixelType == 2) {
                while (cursor.hasNext()) {
                    cursor.fwd();
                    ((RealType)cursor.get()).setReal((float)LegacyStackImgLoaderLOCI.getShortValue(b, (cursor.getIntPosition(0) + cursor.getIntPosition(1) * width) * 2, isLittleEndian));
                }
                continue;
            }
            if (pixelType == 5) {
                while (cursor.hasNext()) {
                    cursor.fwd();
                    ((RealType)cursor.get()).setReal((float)LegacyStackImgLoaderLOCI.getIntValue(b, (cursor.getIntPosition(0) + cursor.getIntPosition(1) * width) * 4, isLittleEndian));
                }
                continue;
            }
            if (pixelType != 6) continue;
            while (cursor.hasNext()) {
                cursor.fwd();
                ((RealType)cursor.get()).setReal(LegacyStackImgLoaderLOCI.getFloatValue(b, (cursor.getIntPosition(0) + cursor.getIntPosition(1) * width) * 4, isLittleEndian));
            }
        }
        r.close();
        IJ.showProgress((double)1.0);
        return new CalibratedImg<NativeType<T>>(img, calX, calY, calZ);
    }

    protected static final float getFloatValue(byte[] b, int i, boolean isLittleEndian) {
        if (isLittleEndian) {
            return Float.intBitsToFloat(((b[i + 3] & 0xFF) << 24) + ((b[i + 2] & 0xFF) << 16) + ((b[i + 1] & 0xFF) << 8) + (b[i] & 0xFF));
        }
        return Float.intBitsToFloat(((b[i] & 0xFF) << 24) + ((b[i + 1] & 0xFF) << 16) + ((b[i + 2] & 0xFF) << 8) + (b[i + 3] & 0xFF));
    }

    protected static final int getIntValue(byte[] b, int i, boolean isLittleEndian) {
        if (isLittleEndian) {
            return ((b[i + 3] & 0xFF) << 24) + ((b[i + 2] & 0xFF) << 16) + ((b[i + 1] & 0xFF) << 8) + (b[i] & 0xFF);
        }
        return ((b[i] & 0xFF) << 24) + ((b[i + 1] & 0xFF) << 16) + ((b[i + 2] & 0xFF) << 8) + (b[i + 3] & 0xFF);
    }

    protected static final short getShortValue(byte[] b, int i, boolean isLittleEndian) {
        return (short)LegacyStackImgLoaderLOCI.getShortValueInt(b, i, isLittleEndian);
    }

    protected static final int getShortValueInt(byte[] b, int i, boolean isLittleEndian) {
        if (isLittleEndian) {
            return ((b[i + 1] & 0xFF) << 8) + (b[i] & 0xFF);
        }
        return ((b[i] & 0xFF) << 8) + (b[i + 1] & 0xFF);
    }

    protected static String checkPath(String path) {
        if (path.length() > 1 && !(path = path.replace('\\', '/')).endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public static boolean createOMEXMLMetadata(IFormatReader r) {
        try {
            ServiceFactory serviceFactory = new ServiceFactory();
            OMEXMLService service = (OMEXMLService)serviceFactory.getInstance(OMEXMLService.class);
            OMEXMLMetadata omexmlMeta = service.createOMEXMLMetadata();
            r.setMetadataStore((MetadataStore)omexmlMeta);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return false;
        }
        catch (DependencyException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    protected void loadMetaData(ViewId view) {
        File file = this.getFile(view);
        Calibration cal = LegacyStackImgLoaderLOCI.loadMetaData(file);
        if (cal != null) {
            this.updateMetaDataCache(view, cal.getWidth(), cal.getHeight(), cal.getDepth(), cal.getCalX(), cal.getCalY(), cal.getCalZ());
        }
    }

    public static Calibration loadMetaData(File file) {
        ChannelSeparator r = new ChannelSeparator();
        if (!LegacyStackImgLoaderLOCI.createOMEXMLMetadata((IFormatReader)r)) {
            try {
                r.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
        try {
            r.setId(file.getAbsolutePath());
            MetadataRetrieve retrieve = (MetadataRetrieve)r.getMetadataStore();
            float cal = 0.0f;
            Length f = retrieve.getPixelsPhysicalSizeX(0);
            if (f != null) {
                cal = f.value().floatValue();
            }
            if (cal == 0.0f) {
                cal = 1.0f;
                IOFunctions.printlnSafe("StackListLOCI: Warning, calibration for dimension X seems corrupted, setting to 1.");
            }
            double calX = cal;
            f = retrieve.getPixelsPhysicalSizeY(0);
            if (f != null) {
                cal = f.value().floatValue();
            }
            if (cal == 0.0f) {
                cal = 1.0f;
                IOFunctions.printlnSafe("StackListLOCI: Warning, calibration for dimension Y seems corrupted, setting to 1.");
            }
            double calY = cal;
            f = retrieve.getPixelsPhysicalSizeZ(0);
            if (f != null) {
                cal = f.value().floatValue();
            }
            if (cal == 0.0f) {
                cal = 1.0f;
                IOFunctions.printlnSafe("StackListLOCI: Warning, calibration for dimension Z seems corrupted, setting to 1.");
            }
            double calZ = cal;
            IOFunctions.printlnSafe("Image stack size of first stack: " + r.getSizeX() + "x" + r.getSizeY() + "x" + r.getSizeZ());
            Calibration calibration = new Calibration(r.getSizeX(), r.getSizeY(), r.getSizeZ(), calX, calY, calZ);
            r.close();
            return calibration;
        }
        catch (Exception e) {
            IOFunctions.printlnSafe("Could not open file: '" + file.getAbsolutePath() + "'");
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return new StackListLOCI().getTitle() + ", ImgFactory=" + this.imgFactory.getClass().getSimpleName();
    }
}

