/*
 * Decompiled with CFR 0.152.
 */
package spimopener;

import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import spimopener.SPIMExperiment;
import spimopener.SPIMStack;

public class SPIMRegularStack
extends SPIMStack {
    private int x0 = 0;
    private int x1;
    private int y0;
    private int y1;
    private int orgW;
    private int orgH;

    public SPIMRegularStack(int w, int h) {
        super(w, h);
        this.x1 = w - 1;
        this.y0 = 0;
        this.y1 = h - 1;
        this.orgW = w;
        this.orgH = h;
    }

    @Override
    public void setRange(int orgW, int orgH, int xOffs, int yOffs) {
        this.orgW = orgW;
        this.orgH = orgH;
        this.x0 = xOffs;
        this.x1 = xOffs + this.getWidth() - 1;
        this.y0 = yOffs;
        this.y1 = yOffs + this.getHeight() - 1;
    }

    @Override
    public void addSlice(String path) {
        ImageProcessor ip = null;
        try {
            ip = SPIMExperiment.openRaw(path, this.orgW, this.orgH, this.x0, this.x1, this.y0, this.y1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.addSlice(ip);
    }

    @Override
    public void addSlice(ImageProcessor ip) {
        if (!(ip instanceof ShortProcessor)) {
            ip = ip.convertToShort(true);
        }
        super.addSlice("", ip);
    }
}

