/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Sampling;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SamplingTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(SamplingTest.class);
        TestRunner.run((Test)suite);
    }

    public void testUniform() {
        int n = 1000;
        double d = 0.3333333333333333;
        double f = 0.16666666666666666;
        double tiny = d * 1.0E-6;
        double[] v = new double[n];
        double vi = f;
        int i = 0;
        while (i < n) {
            v[i] = vi;
            ++i;
            vi += d;
        }
        Sampling us = new Sampling(n, d, f);
        Sampling vs = new Sampling(v);
        SamplingTest.assertTrue((boolean)us.isUniform());
        SamplingTest.assertTrue((boolean)vs.isUniform());
        SamplingTest.assertTrue((boolean)us.isEquivalentTo(vs));
        int i2 = 0;
        while (i2 < n) {
            int j = us.indexOf(v[i2]);
            SamplingTest.assertEquals((int)i2, (int)j);
            j = vs.indexOf(v[i2]);
            SamplingTest.assertEquals((int)i2, (int)j);
            ++i2;
            vi += d;
        }
        int[] overlap = us.overlapWith(vs);
        SamplingTest.assertEquals((int)n, (int)overlap[0]);
        SamplingTest.assertEquals((int)0, (int)overlap[1]);
        SamplingTest.assertEquals((int)0, (int)overlap[2]);
        Sampling sm = us.mergeWith(vs);
        SamplingTest.assertTrue((boolean)sm.isEquivalentTo(us));
        SamplingTest.assertTrue((boolean)sm.isEquivalentTo(vs));
        Sampling sr = us.shift(10.0 * d);
        overlap = us.overlapWith(sr);
        SamplingTest.assertEquals((int)(n - 10), (int)overlap[0]);
        SamplingTest.assertEquals((int)10, (int)overlap[1]);
        SamplingTest.assertEquals((int)0, (int)overlap[2]);
        Sampling sl = us.shift(-10.0 * d);
        overlap = us.overlapWith(sl);
        SamplingTest.assertEquals((int)(n - 10), (int)overlap[0]);
        SamplingTest.assertEquals((int)0, (int)overlap[1]);
        SamplingTest.assertEquals((int)10, (int)overlap[2]);
        sr = us.shift((double)n * d);
        overlap = us.overlapWith(sr);
        SamplingTest.assertEquals((int)0, (int)overlap[0]);
        SamplingTest.assertEquals((int)n, (int)overlap[1]);
        SamplingTest.assertEquals((int)0, (int)overlap[2]);
        sl = us.shift((double)(-n) * d);
        overlap = us.overlapWith(sl);
        SamplingTest.assertEquals((int)0, (int)overlap[0]);
        SamplingTest.assertEquals((int)0, (int)overlap[1]);
        SamplingTest.assertEquals((int)n, (int)overlap[2]);
        sm = us.mergeWith(sr);
        sm = sm.mergeWith(sl);
        SamplingTest.assertEquals((int)(n * 3), (int)sm.getCount());
        SamplingTest.assertTrue((boolean)sm.isUniform());
        sr = us.shift((double)(2 * n) * d);
        sm = us.mergeWith(sr);
        SamplingTest.assertEquals((int)(n * 2), (int)sm.getCount());
        SamplingTest.assertTrue((!sm.isUniform() ? 1 : 0) != 0);
        Sampling sp = us.prepend(100);
        SamplingTest.assertEquals((int)(n + 100), (int)sp.getCount());
        SamplingTest.assertEquals((double)(f - 100.0 * d), (double)sp.getFirst(), (double)tiny);
        Sampling sa = us.append(100);
        SamplingTest.assertEquals((int)(n + 100), (int)sa.getCount());
        SamplingTest.assertEquals((double)f, (double)sa.getFirst(), (double)tiny);
        Sampling sd = us.decimate(3);
        SamplingTest.assertEquals((int)(1 + (n - 1) / 3), (int)sd.getCount());
        SamplingTest.assertEquals((double)(d * 3.0), (double)sd.getDelta(), (double)tiny);
        SamplingTest.assertEquals((double)f, (double)sd.getFirst(), (double)tiny);
        Sampling si = us.interpolate(3);
        SamplingTest.assertEquals((int)(1 + (n - 1) * 3), (int)si.getCount());
        SamplingTest.assertEquals((double)(d / 3.0), (double)si.getDelta(), (double)tiny);
        SamplingTest.assertEquals((double)f, (double)si.getFirst(), (double)tiny);
    }

    public void testBoundsAndForUniform() {
        Sampling s = new Sampling(11, 1.0, 0.0);
        SamplingTest.assertEquals((boolean)s.isInBoundsExtended(-0.5001), (boolean)false);
        SamplingTest.assertEquals((boolean)s.isInBoundsExtended(-0.4999), (boolean)true);
        SamplingTest.assertEquals((boolean)s.isInBoundsExtended(10.4999), (boolean)true);
        SamplingTest.assertEquals((boolean)s.isInBoundsExtended(10.5001), (boolean)false);
        SamplingTest.assertEquals((Object)s.getValueExtended(-1), (Object)-1.0);
        SamplingTest.assertEquals((Object)s.getValueExtended(0), (Object)0.0);
        SamplingTest.assertEquals((Object)s.getValueExtended(10), (Object)10.0);
        SamplingTest.assertEquals((Object)s.getValueExtended(11), (Object)11.0);
        SamplingTest.assertEquals((int)s.indexOfNearestExtended(-0.5001), (int)-1);
        SamplingTest.assertEquals((int)s.indexOfNearestExtended(-0.4999), (int)0);
        SamplingTest.assertEquals((int)s.indexOfNearestExtended(0.0), (int)0);
        SamplingTest.assertEquals((int)s.indexOfNearestExtended(0.4999), (int)0);
        SamplingTest.assertEquals((int)s.indexOfNearestExtended(0.5001), (int)1);
        SamplingTest.assertEquals((int)s.indexOfNearestExtended(1.0), (int)1);
        SamplingTest.assertEquals((int)s.indexOfNearestExtended(1.4999), (int)1);
        SamplingTest.assertEquals((int)s.indexOfNearestExtended(1.5001), (int)2);
        SamplingTest.assertEquals((Object)s.normalizedDifferenceExtended(1.5, s.indexOfFloorExtended(1.5)), (Object)0.5);
        s = new Sampling(10, 1.0, -5.0);
        SamplingTest.assertEquals((int)s.indexOfFloorExtended(-6.0), (int)-1);
        SamplingTest.assertEquals((int)s.indexOfFloorExtended(-5.9999), (int)-1);
        SamplingTest.assertEquals((int)s.indexOfFloorExtended(-5.5), (int)-1);
        SamplingTest.assertEquals((int)s.indexOfFloorExtended(-5.0001), (int)-1);
        SamplingTest.assertEquals((int)s.indexOfFloorExtended(-5.0), (int)0);
        SamplingTest.assertEquals((int)s.indexOfFloorExtended(-4.9999), (int)0);
        SamplingTest.assertEquals((int)s.indexOfFloorExtended(-4.5), (int)0);
        SamplingTest.assertEquals((int)s.indexOfFloorExtended(-4.0001), (int)0);
        SamplingTest.assertEquals((int)s.indexOfFloorExtended(-4.0), (int)1);
        SamplingTest.assertEquals((int)s.indexOfFloorExtended(0.0), (int)5);
        s = new Sampling(10, 2.0, 10.0);
        SamplingTest.assertEquals((Object)s.normalizedDifferenceExtended(10.0, s.indexOfFloorExtended(10.0)), (Object)0.0);
        SamplingTest.assertEquals((Object)s.normalizedDifferenceExtended(10.5, s.indexOfFloorExtended(10.5)), (Object)0.25);
        SamplingTest.assertEquals((Object)s.normalizedDifferenceExtended(11.0, s.indexOfFloorExtended(11.0)), (Object)0.5);
        SamplingTest.assertEquals((Object)s.normalizedDifferenceExtended(11.5, s.indexOfFloorExtended(11.5)), (Object)0.75);
        SamplingTest.assertEquals((Object)s.normalizedDifferenceExtended(12.0, s.indexOfFloorExtended(12.0)), (Object)0.0);
    }
}

