/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.SincInterpolator;
import edu.mines.jtk.util.ArrayMath;

public abstract class WarpFunction3 {
    private int _n1;
    private int _n2;
    private int _n3;

    public static WarpFunction3 constant(double u1, double u2, double u3, int n1, int n2, int n3) {
        return new ConstantWarp3(u1, u2, u3, n1, n2, n3);
    }

    public static WarpFunction3 gaussian(double u1, double u2, double u3, int n1, int n2, int n3) {
        return new GaussianWarp3(u1, u2, u3, n1, n2, n3);
    }

    public static WarpFunction3 sinusoid(double u1, double u2, double u3, int n1, int n2, int n3) {
        return new SinusoidWarp3(u1, u2, u3, n1, n2, n3);
    }

    public static WarpFunction3 constantPlusSinusoid(double c1, double c2, double c3, double u1, double u2, double u3, int n1, int n2, int n3) {
        return new SinusoidWarp3(c1, c2, c3, u1, u2, u3, n1, n2, n3);
    }

    public abstract double u1(double var1, double var3, double var5);

    public abstract double u2(double var1, double var3, double var5);

    public abstract double u3(double var1, double var3, double var5);

    public double u1x(double x1, double x2, double x3) {
        return this.u1(x1, x2, x3);
    }

    public double u2x(double x1, double x2, double x3) {
        return this.u2(x1, x2, x3);
    }

    public double u3x(double x1, double x2, double x3) {
        return this.u3(x1, x2, x3);
    }

    public double u1m(double m1, double m2, double m3) {
        double u1p;
        double u1m = 0.0;
        double u2m = 0.0;
        double u3m = 0.0;
        do {
            u1p = u1m;
            u1m = this.u1(m1 - 0.5 * u1m, m2 - 0.5 * u2m, m3 - 0.5 * u3m);
            u2m = this.u2(m1 - 0.5 * u1m, m2 - 0.5 * u2m, m3 - 0.5 * u3m);
            u3m = this.u3(m1 - 0.5 * u1m, m2 - 0.5 * u2m, m3 - 0.5 * u3m);
        } while (ArrayMath.abs(u1m - u1p) > 1.0E-4);
        return u1m;
    }

    public double u2m(double m1, double m2, double m3) {
        double u2p;
        double u1m = 0.0;
        double u2m = 0.0;
        double u3m = 0.0;
        do {
            u2p = u2m;
            u1m = this.u1(m1 - 0.5 * u1m, m2 - 0.5 * u2m, m3 - 0.5 * u3m);
            u2m = this.u2(m1 - 0.5 * u1m, m2 - 0.5 * u2m, m3 - 0.5 * u3m);
            u3m = this.u3(m1 - 0.5 * u1m, m2 - 0.5 * u2m, m3 - 0.5 * u3m);
        } while (ArrayMath.abs(u2m - u2p) > 1.0E-4);
        return u2m;
    }

    public double u3m(double m1, double m2, double m3) {
        double u3p;
        double u1m = 0.0;
        double u2m = 0.0;
        double u3m = 0.0;
        do {
            u3p = u3m;
        } while (ArrayMath.abs((u3m = this.u3(m1 - 0.5 * (u1m = this.u1(m1 - 0.5 * u1m, m2 - 0.5 * u2m, m3 - 0.5 * u3m)), m2 - 0.5 * (u2m = this.u2(m1 - 0.5 * u1m, m2 - 0.5 * u2m, m3 - 0.5 * u3m)), m3 - 0.5 * u3m)) - u3p) > 1.0E-4);
        return u3m;
    }

    public double u1y(double y1, double y2, double y3) {
        double u1p;
        double u1y = 0.0;
        double u2y = 0.0;
        double u3y = 0.0;
        do {
            u1p = u1y;
            u1y = this.u1(y1 - u1y, y2 - u2y, y3 - u3y);
            u2y = this.u2(y1 - u1y, y2 - u2y, y3 - u3y);
            u3y = this.u3(y1 - u1y, y2 - u2y, y3 - u3y);
        } while (ArrayMath.abs(u1y - u1p) > 1.0E-4);
        return u1y;
    }

    public double u2y(double y1, double y2, double y3) {
        double u2p;
        double u1y = 0.0;
        double u2y = 0.0;
        double u3y = 0.0;
        do {
            u2p = u2y;
            u1y = this.u1(y1 - u1y, y2 - u2y, y3 - u3y);
            u2y = this.u2(y1 - u1y, y2 - u2y, y3 - u3y);
            u3y = this.u3(y1 - u1y, y2 - u2y, y3 - u3y);
        } while (ArrayMath.abs(u2y - u2p) > 1.0E-4);
        return u2y;
    }

    public double u3y(double y1, double y2, double y3) {
        double u3p;
        double u1y = 0.0;
        double u2y = 0.0;
        double u3y = 0.0;
        do {
            u3p = u3y;
        } while (ArrayMath.abs((u3y = this.u3(y1 - (u1y = this.u1(y1 - u1y, y2 - u2y, y3 - u3y)), y2 - (u2y = this.u2(y1 - u1y, y2 - u2y, y3 - u3y)), y3 - u3y)) - u3p) > 1.0E-4);
        return u3y;
    }

    public float[][][] u1x() {
        float[][][] u = new float[this._n3][this._n2][this._n1];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            double x3 = i3;
            for (int i2 = 0; i2 < this._n2; ++i2) {
                double x2 = i2;
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    double x1 = i1;
                    u[i3][i2][i1] = (float)this.u1x(x1, x2, x3);
                }
            }
        }
        return u;
    }

    public float[][][] u2x() {
        float[][][] u = new float[this._n3][this._n2][this._n1];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            double x3 = i3;
            for (int i2 = 0; i2 < this._n2; ++i2) {
                double x2 = i2;
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    double x1 = i1;
                    u[i3][i2][i1] = (float)this.u2x(x1, x2, x3);
                }
            }
        }
        return u;
    }

    public float[][][] u3x() {
        float[][][] u = new float[this._n3][this._n2][this._n1];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            double x3 = i3;
            for (int i2 = 0; i2 < this._n2; ++i2) {
                double x2 = i2;
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    double x1 = i1;
                    u[i3][i2][i1] = (float)this.u3x(x1, x2, x3);
                }
            }
        }
        return u;
    }

    public float[][][] u1m() {
        float[][][] u = new float[this._n3][this._n2][this._n1];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            double x3 = i3;
            for (int i2 = 0; i2 < this._n2; ++i2) {
                double x2 = i2;
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    double x1 = i1;
                    u[i3][i2][i1] = (float)this.u1m(x1, x2, x3);
                }
            }
        }
        return u;
    }

    public float[][][] u2m() {
        float[][][] u = new float[this._n3][this._n2][this._n1];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            double x3 = i3;
            for (int i2 = 0; i2 < this._n2; ++i2) {
                double x2 = i2;
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    double x1 = i1;
                    u[i3][i2][i1] = (float)this.u2m(x1, x2, x3);
                }
            }
        }
        return u;
    }

    public float[][][] u3m() {
        float[][][] u = new float[this._n3][this._n2][this._n1];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            double x3 = i3;
            for (int i2 = 0; i2 < this._n2; ++i2) {
                double x2 = i2;
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    double x1 = i1;
                    u[i3][i2][i1] = (float)this.u3m(x1, x2, x3);
                }
            }
        }
        return u;
    }

    public float[][][] u1y() {
        float[][][] u = new float[this._n3][this._n2][this._n1];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            double x3 = i3;
            for (int i2 = 0; i2 < this._n2; ++i2) {
                double x2 = i2;
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    double x1 = i1;
                    u[i3][i2][i1] = (float)this.u1y(x1, x2, x3);
                }
            }
        }
        return u;
    }

    public float[][][] u2y() {
        float[][][] u = new float[this._n3][this._n2][this._n1];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            double x3 = i3;
            for (int i2 = 0; i2 < this._n2; ++i2) {
                double x2 = i2;
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    double x1 = i1;
                    u[i3][i2][i1] = (float)this.u2y(x1, x2, x3);
                }
            }
        }
        return u;
    }

    public float[][][] u3y() {
        float[][][] u = new float[this._n3][this._n2][this._n1];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            double x3 = i3;
            for (int i2 = 0; i2 < this._n2; ++i2) {
                double x2 = i2;
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    double x1 = i1;
                    u[i3][i2][i1] = (float)this.u3y(x1, x2, x3);
                }
            }
        }
        return u;
    }

    public float[][][] warp1(float[][][] f) {
        SincInterpolator si = new SincInterpolator();
        float[][][] g = new float[this._n3][this._n2][this._n1];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    g[i3][i2][i1] = si.interpolate(this._n1, 1.0, 0.0, f[i3][i2], (double)i1 - this.u1y(i1, i2, i3));
                }
            }
        }
        return g;
    }

    public float[][][] warp(float[][][] f) {
        SincInterpolator si = new SincInterpolator();
        float[][][] g = new float[this._n3][this._n2][this._n1];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            double y3 = i3;
            for (int i2 = 0; i2 < this._n2; ++i2) {
                double y2 = i2;
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    double y1 = i1;
                    double x1 = y1 - this.u1y(y1, y2, y3);
                    double x2 = y2 - this.u2y(y1, y2, y3);
                    double x3 = y3 - this.u3y(y1, y2, y3);
                    g[i3][i2][i1] = si.interpolate(this._n1, 1.0, 0.0, this._n2, 1.0, 0.0, this._n3, 1.0, 0.0, f, x1, x2, x3);
                }
            }
        }
        return g;
    }

    public float[][][] unwarp1(float[][][] g) {
        SincInterpolator si = new SincInterpolator();
        float[][][] f = new float[this._n3][this._n2][this._n1];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    f[i3][i2][i1] = si.interpolate(this._n1, 1.0, 0.0, g[i3][i2], (double)i1 + this.u1x(i1, i2, i3));
                }
            }
        }
        return f;
    }

    public float[][][] unwarp(float[][][] g) {
        SincInterpolator si = new SincInterpolator();
        float[][][] f = new float[this._n3][this._n2][this._n1];
        for (int i3 = 0; i3 < this._n3; ++i3) {
            double x3 = i3;
            for (int i2 = 0; i2 < this._n2; ++i2) {
                double x2 = i2;
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    double x1 = i1;
                    double y1 = x1 + this.u1x(x1, x2, x3);
                    double y2 = x2 + this.u2x(x1, x2, x3);
                    double y3 = x3 + this.u3x(x1, x2, x3);
                    f[i3][i2][i1] = si.interpolate(this._n1, 1.0, 0.0, this._n2, 1.0, 0.0, this._n3, 1.0, 0.0, g, y1, y2, y3);
                }
            }
        }
        return f;
    }

    protected WarpFunction3(int n1, int n2, int n3) {
        this._n1 = n1;
        this._n2 = n2;
        this._n3 = n3;
    }

    private static class SinusoidWarp3
    extends WarpFunction3 {
        private double _a1;
        private double _a2;
        private double _a3;
        private double _b1;
        private double _b2;
        private double _b3;
        private double _c1;
        private double _c2;
        private double _c3;

        public SinusoidWarp3(double u1max, double u2max, double u3max, int n1, int n2, int n3) {
            this(0.0, 0.0, 0.0, u1max, u2max, u3max, n1, n2, n3);
        }

        public SinusoidWarp3(double u1add, double u2add, double u3add, double u1sin, double u2sin, double u3sin, int n1, int n2, int n3) {
            super(n1, n2, n3);
            double l1 = n1 - 1;
            double l2 = n2 - 1;
            double l3 = n3 - 1;
            this._c1 = u1add;
            this._c2 = u2add;
            this._c3 = u3add;
            this._a1 = u1sin;
            this._a2 = u2sin;
            this._a3 = u3sin;
            this._b1 = Math.PI * 2 / l1;
            this._b2 = Math.PI * 2 / l2;
            this._b3 = Math.PI * 2 / l3;
        }

        @Override
        public double u1(double x1, double x2, double x3) {
            return this._c1 + this._a1 * ArrayMath.sin(this._b1 * x1) * ArrayMath.sin(0.5 * this._b2 * x2) * ArrayMath.sin(0.5 * this._b3 * x3);
        }

        @Override
        public double u2(double x1, double x2, double x3) {
            return this._c2 + this._a2 * ArrayMath.sin(this._b2 * x2) * ArrayMath.sin(0.5 * this._b1 * x1) * ArrayMath.sin(0.5 * this._b3 * x3);
        }

        @Override
        public double u3(double x1, double x2, double x3) {
            return this._c3 + this._a3 * ArrayMath.sin(this._b3 * x3) * ArrayMath.sin(0.5 * this._b1 * x1) * ArrayMath.sin(0.5 * this._b2 * x2);
        }
    }

    private static class GaussianWarp3
    extends WarpFunction3 {
        private double _a1;
        private double _a2;
        private double _a3;
        private double _b1;
        private double _b2;
        private double _b3;
        private double _c1;
        private double _c2;
        private double _c3;

        public GaussianWarp3(double u1max, double u2max, double u3max, int n1, int n2, int n3) {
            super(n1, n2, n3);
            this._a1 = (double)(n1 - 1) / 2.0;
            this._a2 = (double)(n2 - 1) / 2.0;
            this._a3 = (double)(n3 - 1) / 2.0;
            this._b1 = this._a1 / 3.0;
            this._b2 = this._a2 / 3.0;
            this._b3 = this._a3 / 3.0;
            this._c1 = u1max * ArrayMath.exp(0.5) / this._b1;
            this._c2 = u2max * ArrayMath.exp(0.5) / this._b2;
            this._c3 = u3max * ArrayMath.exp(0.5) / this._b3;
        }

        @Override
        public double u1(double x1, double x2, double x3) {
            double xa1 = x1 - this._a1;
            double xa2 = x2 - this._a2;
            double xa3 = x3 - this._a3;
            return -this._c1 * xa1 * ArrayMath.exp(-0.5 * (xa1 * xa1 / (this._b1 * this._b1) + xa2 * xa2 / (this._b2 * this._b2) + xa3 * xa3 / (this._b3 * this._b3)));
        }

        @Override
        public double u2(double x1, double x2, double x3) {
            double xa1 = x1 - this._a1;
            double xa2 = x2 - this._a2;
            double xa3 = x3 - this._a3;
            return -this._c2 * xa2 * ArrayMath.exp(-0.5 * (xa1 * xa1 / (this._b1 * this._b1) + xa2 * xa2 / (this._b2 * this._b2) + xa3 * xa3 / (this._b3 * this._b3)));
        }

        @Override
        public double u3(double x1, double x2, double x3) {
            double xa1 = x1 - this._a1;
            double xa2 = x2 - this._a2;
            double xa3 = x3 - this._a3;
            return -this._c3 * xa3 * ArrayMath.exp(-0.5 * (xa1 * xa1 / (this._b1 * this._b1) + xa2 * xa2 / (this._b2 * this._b2) + xa3 * xa3 / (this._b3 * this._b3)));
        }
    }

    private static class ConstantWarp3
    extends WarpFunction3 {
        private double _u1;
        private double _u2;
        private double _u3;

        public ConstantWarp3(double u1, double u2, double u3, int n1, int n2, int n3) {
            super(n1, n2, n3);
            this._u1 = u1;
            this._u2 = u2;
            this._u3 = u3;
        }

        @Override
        public double u1(double x1, double x2, double x3) {
            return this._u1;
        }

        @Override
        public double u2(double x1, double x2, double x3) {
            return this._u2;
        }

        @Override
        public double u3(double x1, double x2, double x3) {
            return this._u3;
        }
    }
}

