/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.sgl.BoundingBox;
import edu.mines.jtk.sgl.BoundingSphere;
import edu.mines.jtk.sgl.Point3;

public class BoxConstraint {
    private double _xmin;
    private double _ymin;
    private double _zmin;
    private double _xmax;
    private double _ymax;
    private double _zmax;
    private double _dxmin;
    private double _dymin;
    private double _dzmin;
    private Sampling _sx;
    private Sampling _sy;
    private Sampling _sz;
    private boolean _sampled;

    public BoxConstraint(BoundingBox box) {
        this(box.getMin(), box.getMax(), 0.0, 0.0, 0.0);
    }

    public BoxConstraint(BoundingBox box, double dxmin, double dymin, double dzmin) {
        this(box.getMin(), box.getMax(), dxmin, dymin, dzmin);
    }

    public BoxConstraint(Point3 p, Point3 q) {
        this(p, q, 0.0, 0.0, 0.0);
    }

    public BoxConstraint(Point3 p, Point3 q, double dxmin, double dymin, double dzmin) {
        this._xmin = Math.min(p.x, q.x);
        this._ymin = Math.min(p.y, q.y);
        this._zmin = Math.min(p.z, q.z);
        this._xmax = Math.max(p.x, q.x);
        this._ymax = Math.max(p.y, q.y);
        this._zmax = Math.max(p.z, q.z);
        this._dxmin = dxmin;
        this._dymin = dymin;
        this._dzmin = dzmin;
        this._sampled = false;
    }

    public BoxConstraint(Sampling sx, Sampling sy, Sampling sz) {
        this(sx, sy, sz, 0.0, 0.0, 0.0);
    }

    public BoxConstraint(Sampling sx, Sampling sy, Sampling sz, double dxmin, double dymin, double dzmin) {
        this._xmin = sx.getFirst();
        this._ymin = sy.getFirst();
        this._zmin = sz.getFirst();
        this._xmax = sx.getLast();
        this._ymax = sy.getLast();
        this._zmax = sz.getLast();
        this._dxmin = dxmin;
        this._dymin = dymin;
        this._dzmin = dzmin;
        this._sx = sx;
        this._sy = sy;
        this._sz = sz;
        this._sampled = true;
    }

    public BoundingBox getBoundingBox() {
        return new BoundingBox(this._xmin, this._ymin, this._zmin, this._xmax, this._ymax, this._zmax);
    }

    public BoundingSphere getBoundingSphere() {
        BoundingSphere bs = new BoundingSphere();
        bs.expandBy(this.getBoundingBox());
        return bs;
    }

    public boolean containsPoint(Point3 p) {
        return this._xmin <= p.x && p.x <= this._xmax && this._ymin <= p.y && p.y <= this._ymax && this._zmin <= p.z && p.z <= this._zmax;
    }

    public void constrainPoint(Point3 p) {
        p.x = Math.max(this._xmin, Math.min(this._xmax, p.x));
        p.y = Math.max(this._ymin, Math.min(this._ymax, p.y));
        p.z = Math.max(this._zmin, Math.min(this._zmax, p.z));
        if (this._sampled) {
            p.x = this._sx.valueOfNearest(p.x);
            p.y = this._sy.valueOfNearest(p.y);
            p.z = this._sz.valueOfNearest(p.z);
        }
    }

    public void constrainBox(Point3 p, Point3 q) {
        double ax = Math.min(p.x, q.x);
        double bx = Math.max(p.x, q.x);
        double dx = Math.max(bx - ax, this._dxmin);
        if (p.x <= q.x) {
            ax = Math.max(this._xmin, Math.min(this._xmax, ax));
            bx = Math.min(this._xmax, ax + dx);
            ax = Math.max(this._xmin, bx - dx);
        } else {
            bx = Math.min(this._xmax, Math.max(this._xmin, bx));
            ax = Math.max(this._xmin, bx - dx);
            bx = Math.min(this._xmax, ax + dx);
        }
        if (this._sampled) {
            ax = this._sx.valueOfNearest(ax);
            bx = this._sx.valueOfNearest(bx);
        }
        if (p.x <= q.x) {
            p.x = ax;
            q.x = bx;
        } else {
            p.x = bx;
            q.x = ax;
        }
        double ay = Math.min(p.y, q.y);
        double by = Math.max(p.y, q.y);
        double dy = Math.max(by - ay, this._dymin);
        if (p.y <= q.y) {
            ay = Math.max(this._ymin, Math.min(this._ymax, ay));
            by = Math.min(this._ymax, ay + dy);
            ay = Math.max(this._ymin, by - dy);
        } else {
            by = Math.min(this._ymax, Math.max(this._ymin, by));
            ay = Math.max(this._ymin, by - dy);
            by = Math.min(this._ymax, ay + dy);
        }
        if (this._sampled) {
            ay = this._sy.valueOfNearest(ay);
            by = this._sy.valueOfNearest(by);
        }
        if (p.y <= q.y) {
            p.y = ay;
            q.y = by;
        } else {
            p.y = by;
            q.y = ay;
        }
        double az = Math.min(p.z, q.z);
        double bz = Math.max(p.z, q.z);
        double dz = Math.max(bz - az, this._dzmin);
        if (p.z <= q.z) {
            az = Math.max(this._zmin, Math.min(this._zmax, az));
            bz = Math.min(this._zmax, az + dz);
            az = Math.max(this._zmin, bz - dz);
        } else {
            bz = Math.min(this._zmax, Math.max(this._zmin, bz));
            az = Math.max(this._zmin, bz - dz);
            bz = Math.min(this._zmax, az + dz);
        }
        if (this._sampled) {
            az = this._sz.valueOfNearest(az);
            bz = this._sz.valueOfNearest(bz);
        }
        if (p.z <= q.z) {
            p.z = az;
            q.z = bz;
        } else {
            p.z = bz;
            q.z = az;
        }
    }
}

