/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import java.util.NoSuchElementException;

public class ArrayQueue<E> {
    private static final int MIN_LENGTH = 32;
    private int _length = 0;
    private Object[] _array;
    private int _first = 0;
    private int _size = 0;

    public ArrayQueue() {
        this._length = 32;
        this._array = new Object[this._length];
    }

    public ArrayQueue(int capacity) {
        if (capacity < 32) {
            capacity = 32;
        }
        this._length = capacity;
        this._array = new Object[this._length];
    }

    public void add(E e) {
        int index;
        if (this._size == this._length) {
            this.resize(this._size * 2);
        }
        if ((index = this._first + this._size) >= this._length) {
            index -= this._length;
        }
        this._array[index] = e;
        ++this._size;
    }

    public E first() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        Object e = this._array[this._first];
        return (E)e;
    }

    public E remove() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        Object e = this._array[this._first];
        ++this._first;
        if (this._first == this._length) {
            this._first = 0;
        }
        --this._size;
        if (this._size * 3 < this._length) {
            this.resize(this._size * 2);
        }
        return (E)e;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public void ensureCapacity(int capacity) {
        if (capacity < this._length) {
            capacity = this._length;
        }
        this.resize(capacity);
    }

    public int size() {
        return this._size;
    }

    public void trimToSize() {
        this.resize(this._size);
    }

    private void resize(int length) {
        if (length < 32) {
            length = 32;
        }
        if (length != this._length) {
            int n2;
            Object[] array = new Object[length];
            int n1 = this._length - this._first;
            if (n1 > this._size) {
                n1 = this._size;
            }
            if (n1 > 0) {
                System.arraycopy(this._array, this._first, array, 0, n1);
            }
            if ((n2 = this._first + this._size - this._length) > 0) {
                System.arraycopy(this._array, 0, array, n1, n2);
            }
            this._length = length;
            this._array = array;
            this._first = 0;
        }
    }
}

