/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.googlecloud;

import com.google.common.base.Splitter;
import java.net.URI;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.janelia.saalfeldlab.n5.N5URI;

public class GoogleCloudStorageURI {
    private static final String storageHost = "storage.googleapis.com";
    private static final String googleCloudHost = "googleapis.com";
    private static final String googleCloudHost2 = "storage.cloud.google.com";
    private static final String storagePathPrefix = "/storage/v1/b/";
    private static final String projectKey = "project";
    private final URI uri;
    private final String bucketName;
    private final String objectKey;
    private final String query;
    private Map<String, String> queryMap;

    public GoogleCloudStorageURI(String str) {
        this(N5URI.getAsUri(str));
    }

    public GoogleCloudStorageURI(URI uri) {
        this.uri = uri;
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("Invalid scheme");
        }
        if (uri.getScheme().equalsIgnoreCase("gs")) {
            this.bucketName = uri.getAuthority();
            this.objectKey = uri.getPath();
            this.query = uri.getQuery();
        } else if (uri.getScheme().matches("(?i)http(s)?")) {
            String host = uri.getHost();
            String path = uri.getPath();
            Matcher match = host.matches("(?i)(www.)?googleapis.com") ? Pattern.compile("^/storage/v1/b/(?<bucket>[^/]*)(?<key>/?.*)", 2).matcher(path) : (host.matches("(?i)storage.googleapis.com|storage.cloud.google.com") ? Pattern.compile("/?(?<bucket>[^/]*)(?<key>.*)", 2).matcher(path) : null);
            if (match == null || !match.matches()) {
                throw new IllegalArgumentException("Not a google cloud storage link");
            }
            this.bucketName = match.group("bucket");
            this.objectKey = match.group("key");
            this.query = uri.getQuery();
        } else {
            throw new IllegalArgumentException("Invalid scheme");
        }
        this.queryMap = this.parseQuery();
    }

    public String getBucket() {
        return this.bucketName;
    }

    public URI asURI() {
        return this.uri;
    }

    public String getKey() {
        return this.objectKey;
    }

    public String getQuery() {
        return this.query;
    }

    public String getProject() {
        if (this.queryMap != null && this.queryMap.containsKey(projectKey)) {
            return this.queryMap.get(projectKey);
        }
        return null;
    }

    private Map<String, String> parseQuery() {
        if (this.query != null) {
            return Splitter.on((char)'&').trimResults().withKeyValueSeparator('=').split((CharSequence)this.query);
        }
        return null;
    }
}

