/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.googlecloud;

import com.google.api.gax.paging.Page;
import com.google.cloud.ReadChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.common.base.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.janelia.saalfeldlab.googlecloud.GoogleCloudStorageURI;
import org.janelia.saalfeldlab.googlecloud.GoogleCloudUtils;
import org.janelia.saalfeldlab.n5.KeyValueAccess;
import org.janelia.saalfeldlab.n5.LockedChannel;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5URI;

public class GoogleCloudStorageKeyValueAccess
implements KeyValueAccess {
    private static final String NORMAL_ROOT = N5URI.normalizeGroupPath("/");
    static final int FAILED_PRECONDITION = 400;
    static final int INVALID_ARGUMENT = 401;
    static final int UNAUTHENTICATED = 402;
    static final int PERMISSION_DENIED = 403;
    static final int NOT_FOUND = 404;
    static final int ALREADY_EXISTS = 409;
    private final Storage storage;
    private final GoogleCloudStorageURI containerURI;
    public final String bucketName;
    private final boolean createBucket;
    private Boolean bucketCheckedAndExists = null;

    protected static GoogleCloudStorageURI uncheckedContainerLocationStringToGoogleURI(String uri) {
        try {
            return new GoogleCloudStorageURI(uri);
        }
        catch (Exception e) {
            throw new N5Exception("Container location " + uri + " is an invalid URI", e);
        }
    }

    public GoogleCloudStorageKeyValueAccess(Storage storage, String containerURI, boolean createBucket) throws N5Exception.N5IOException {
        this(storage, GoogleCloudStorageKeyValueAccess.uncheckedContainerLocationStringToGoogleURI(containerURI), createBucket);
    }

    public GoogleCloudStorageKeyValueAccess(Storage storage, URI containerURI, boolean createBucket) throws N5Exception.N5IOException {
        this(storage, new GoogleCloudStorageURI(containerURI), createBucket);
    }

    public GoogleCloudStorageKeyValueAccess(Storage storage, GoogleCloudStorageURI containerURI, boolean createBucket) throws N5Exception.N5IOException {
        this.storage = storage;
        this.containerURI = containerURI;
        this.bucketName = containerURI.getBucket();
        this.createBucket = createBucket;
    }

    public boolean bucketExists() {
        if (Objects.equal((Object)this.bucketCheckedAndExists, (Object)true)) {
            return this.bucketCheckedAndExists;
        }
        try {
            this.bucketCheckedAndExists = this.bucketExistsFromClient();
            return this.bucketCheckedAndExists;
        }
        catch (Exception exception) {
            this.bucketCheckedAndExists = this.prefixExists("");
            return this.bucketCheckedAndExists;
        }
    }

    private boolean bucketExistsFromClient() {
        Bucket bucket = this.storage.get(this.bucketName, new Storage.BucketGetOption[0]);
        if (bucket == null) {
            return false;
        }
        return bucket.exists(new Bucket.BucketSourceOption[0]);
    }

    private boolean prefixExists(String key) {
        try {
            return this.storage.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)key), Storage.BlobListOption.pageSize((long)1L), Storage.BlobListOption.currentDirectory()}).iterateAll().iterator().hasNext();
        }
        catch (StorageException e) {
            if (e.getCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    private void createBucket() {
        if (!this.createBucket) {
            throw new N5Exception("Create Bucket Not Allowed");
        }
        if (!this.bucketExists()) {
            try {
                this.storage.create(BucketInfo.of((String)this.bucketName), new Storage.BucketTargetOption[0]);
                this.bucketCheckedAndExists = true;
            }
            catch (Exception e) {
                throw new N5Exception.N5IOException("Could not create bucket " + this.bucketName, e);
            }
        }
    }

    private void deleteBucket() {
        if (!this.createBucket) {
            throw new N5Exception("Delete Bucket Not Allowed");
        }
        if (Objects.equal((Object)this.bucketCheckedAndExists, (Object)false)) {
            return;
        }
        this.storage.delete(this.bucketName, new Storage.BucketSourceOption[0]);
        this.bucketCheckedAndExists = false;
    }

    @Override
    public String[] components(String path) {
        String key = path;
        try {
            URI uri = N5URI.getAsUri(path);
            String scheme = uri.getScheme();
            if (scheme != null && !scheme.isEmpty()) {
                key = GoogleCloudUtils.getGoogleCloudStorageKey(uri);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return KeyValueAccess.super.components(key);
    }

    @Override
    public String relativize(String path, String base) {
        try {
            URI baseAsUri = this.uri("/" + base);
            URI pathAsUri = this.uri("/" + path);
            URI relativeUri = baseAsUri.relativize(pathAsUri);
            return relativeUri.getPath();
        }
        catch (URISyntaxException e) {
            throw new N5Exception("Cannot relativize path (" + path + ") with base (" + base + ")", e);
        }
    }

    @Override
    public String normalize(String path) {
        return N5URI.normalizeGroupPath(path);
    }

    @Override
    public URI uri(String normalPath) throws URISyntaxException {
        return KeyValueAccess.super.uri(this.compose(this.containerURI.asURI(), normalPath));
    }

    @Override
    public boolean exists(String normalPath) {
        return this.isFile(normalPath) || this.isDirectory(normalPath);
    }

    private boolean keyExists(String key) {
        Blob blob = this.storage.get(BlobId.of((String)this.bucketName, (String)key), new Storage.BlobGetOption[]{Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[0])});
        return GoogleCloudStorageKeyValueAccess.blobExists(blob);
    }

    private static boolean blobExists(Blob blob) {
        return blob != null && blob.exists(new Blob.BlobSourceOption[0]);
    }

    private static String addTrailingSlash(String path) {
        return path.endsWith("/") ? path : path + "/";
    }

    private static String removeLeadingSlash(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    private static boolean isRoot(String path) {
        return N5URI.normalizeGroupPath(path).equals(NORMAL_ROOT);
    }

    @Override
    public boolean isDirectory(String normalPath) {
        String pathKey = GoogleCloudStorageKeyValueAccess.removeLeadingSlash(GoogleCloudStorageKeyValueAccess.addTrailingSlash(GoogleCloudUtils.getGoogleCloudStorageKey(normalPath)));
        if (GoogleCloudStorageKeyValueAccess.isRoot(pathKey)) {
            return this.bucketExists();
        }
        if (this.prefixExists(pathKey)) {
            return true;
        }
        try {
            Blob blob = this.storage.get(this.bucketName, pathKey, new Storage.BlobGetOption[0]);
            if (blob != null) {
                return blob.getSize() == 0L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isFile(String normalPath) {
        String key = GoogleCloudUtils.getGoogleCloudStorageKey(normalPath);
        return !key.endsWith("/") && this.keyExists(GoogleCloudStorageKeyValueAccess.removeLeadingSlash(key));
    }

    @Override
    public LockedChannel lockForReading(String normalPath) {
        String key = GoogleCloudUtils.getGoogleCloudStorageKey(normalPath);
        return new GoogleCloudObjectChannel(GoogleCloudStorageKeyValueAccess.removeLeadingSlash(key), true);
    }

    @Override
    public LockedChannel lockForWriting(String normalPath) {
        String key = GoogleCloudUtils.getGoogleCloudStorageKey(normalPath);
        return new GoogleCloudObjectChannel(GoogleCloudStorageKeyValueAccess.removeLeadingSlash(key), false);
    }

    @Override
    public String[] listDirectories(String normalPath) {
        return this.list(normalPath, true);
    }

    private String[] list(String normalPath, boolean onlyDirectories) {
        String pathKey = GoogleCloudUtils.getGoogleCloudStorageKey(normalPath);
        ArrayList<String> subGroups = new ArrayList<String>();
        String prefix = GoogleCloudStorageKeyValueAccess.removeLeadingSlash(GoogleCloudStorageKeyValueAccess.addTrailingSlash(pathKey));
        Page blobListing = this.storage.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)prefix), Storage.BlobListOption.currentDirectory(), Storage.BlobListOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.ID})});
        int numBlobs = 0;
        for (Blob nextBlob : blobListing.iterateAll()) {
            String relativePath;
            String blobName = nextBlob.getBlobId().getName();
            if (!(prefix.equals(blobName) || onlyDirectories && !blobName.endsWith("/") || (relativePath = this.normalize(this.relativize(blobName, prefix))).isEmpty())) {
                subGroups.add(relativePath);
            }
            ++numBlobs;
        }
        if (numBlobs > 0) {
            return subGroups.toArray(new String[0]);
        }
        try {
            Blob blob = this.storage.get(this.bucketName, prefix, new Storage.BlobGetOption[0]);
            if (blob != null && blob.getSize() == 0L) {
                return new String[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new N5Exception.N5IOException(normalPath + " is not a valid group");
    }

    @Override
    public String[] list(String normalPath) {
        return this.list(normalPath, false);
    }

    @Override
    public void createDirectories(String normalPath) {
        if (this.createBucket) {
            this.createBucket();
        }
        String path = "";
        for (String component : this.components(GoogleCloudStorageKeyValueAccess.removeLeadingSlash(normalPath))) {
            String composed = GoogleCloudStorageKeyValueAccess.addTrailingSlash(this.compose(path, component));
            if (composed.equals("/")) continue;
            path = composed;
            BlobInfo blobInfo = BlobInfo.newBuilder((String)this.bucketName, (String)path).build();
            this.storage.create(blobInfo, new Storage.BlobTargetOption[0]);
        }
    }

    @Override
    public void delete(String normalPath) {
        if (!this.bucketExists()) {
            return;
        }
        String key = GoogleCloudStorageKeyValueAccess.removeLeadingSlash(GoogleCloudUtils.getGoogleCloudStorageKey(normalPath));
        if (!key.endsWith("/")) {
            this.storage.delete(BlobId.of((String)this.bucketName, (String)key));
        }
        for (Page page = this.storage.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)key), Storage.BlobListOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.ID})}); page != null; page = page.getNextPage()) {
            BlobId[] ids = (BlobId[])page.streamValues().map(BlobInfo::getBlobId).toArray(BlobId[]::new);
            if (ids.length <= 0) continue;
            this.storage.delete(ids);
        }
        if (GoogleCloudStorageKeyValueAccess.isRoot(key)) {
            this.deleteBucket();
        }
    }

    private class GoogleCloudObjectChannel
    implements LockedChannel {
        final String path;
        final boolean readOnly;
        final ArrayList<Closeable> resources = new ArrayList();

        GoogleCloudObjectChannel(String path, boolean readOnly) {
            this.path = path;
            this.readOnly = readOnly;
        }

        private void checkWritable() {
            if (this.readOnly) {
                throw new NonReadableChannelException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream newInputStream() {
            ReadChannel channel = GoogleCloudStorageKeyValueAccess.this.storage.reader(GoogleCloudStorageKeyValueAccess.this.bucketName, this.path, new Storage.BlobSourceOption[0]);
            NoSuchKeyWrappedInputStream in = new NoSuchKeyWrappedInputStream(Channels.newInputStream((ReadableByteChannel)channel));
            ArrayList<Closeable> arrayList = this.resources;
            synchronized (arrayList) {
                this.resources.add(in);
            }
            return in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Reader newReader() {
            InputStreamReader in = new InputStreamReader(this.newInputStream(), StandardCharsets.UTF_8);
            ArrayList<Closeable> arrayList = this.resources;
            synchronized (arrayList) {
                this.resources.add(in);
            }
            return in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OutputStream newOutputStream() {
            this.checkWritable();
            BlobInfo blobInfo = BlobInfo.newBuilder((String)GoogleCloudStorageKeyValueAccess.this.bucketName, (String)this.path).build();
            OutputStream out = Channels.newOutputStream((WritableByteChannel)GoogleCloudStorageKeyValueAccess.this.storage.writer(blobInfo, new Storage.BlobWriteOption[0]));
            ArrayList<Closeable> arrayList = this.resources;
            synchronized (arrayList) {
                this.resources.add(out);
            }
            return out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Writer newWriter() {
            this.checkWritable();
            BlobInfo blobInfo = BlobInfo.newBuilder((String)GoogleCloudStorageKeyValueAccess.this.bucketName, (String)this.path).build();
            Writer out = Channels.newWriter((WritableByteChannel)GoogleCloudStorageKeyValueAccess.this.storage.writer(blobInfo, new Storage.BlobWriteOption[0]), StandardCharsets.UTF_8.name());
            ArrayList<Closeable> arrayList = this.resources;
            synchronized (arrayList) {
                this.resources.add(out);
            }
            return out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            ArrayList<Closeable> arrayList = this.resources;
            synchronized (arrayList) {
                for (Closeable resource : this.resources) {
                    resource.close();
                }
                this.resources.clear();
            }
        }

        private class NoSuchKeyWrappedInputStream
        extends InputStream {
            private final InputStream in;

            public NoSuchKeyWrappedInputStream(InputStream in) {
                this.in = in;
            }

            private IOException rethrowOrNoSuchKeyException(IOException e) {
                if (e.getCause() instanceof StorageException && ((StorageException)e.getCause()).getCode() == 404) {
                    throw new N5Exception.N5NoSuchKeyException(e);
                }
                return e;
            }

            @Override
            public int read() throws IOException {
                try {
                    return this.in.read();
                }
                catch (IOException e) {
                    throw this.rethrowOrNoSuchKeyException(e);
                }
            }

            @Override
            public int read(byte[] b) throws IOException {
                try {
                    return this.in.read(b);
                }
                catch (IOException e) {
                    throw this.rethrowOrNoSuchKeyException(e);
                }
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                try {
                    return this.in.read(b, off, len);
                }
                catch (IOException e) {
                    throw this.rethrowOrNoSuchKeyException(e);
                }
            }

            @Override
            public long skip(long n) throws IOException {
                try {
                    return this.in.skip(n);
                }
                catch (IOException e) {
                    throw this.rethrowOrNoSuchKeyException(e);
                }
            }

            @Override
            public int available() throws IOException {
                try {
                    return this.in.available();
                }
                catch (IOException e) {
                    throw this.rethrowOrNoSuchKeyException(e);
                }
            }

            @Override
            public void close() throws IOException {
                this.in.close();
            }

            @Override
            public void mark(int readlimit) {
                this.in.mark(readlimit);
            }

            @Override
            public void reset() throws IOException {
                try {
                    this.in.reset();
                }
                catch (IOException e) {
                    throw this.rethrowOrNoSuchKeyException(e);
                }
            }

            @Override
            public boolean markSupported() {
                return this.in.markSupported();
            }
        }
    }
}

