/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.pivanalyser;

public final class Stopwatch {
    private long fStart;
    private long fStop;
    private boolean fIsRunning;
    private boolean fHasBeenUsedOnce;

    public static void main(String ... arguments) {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        StringBuilder messageOne = new StringBuilder();
        int numIterations = 5000;
        for (int idx = 0; idx < 5000; ++idx) {
            messageOne.append("blah");
        }
        stopwatch.stop();
        System.out.println("The reading for StringBuilder is: " + stopwatch);
        stopwatch.start();
        String messageTwo = null;
        for (int idx = 0; idx < 5000; ++idx) {
            messageTwo = messageTwo + "blah";
        }
        stopwatch.stop();
        if (stopwatch.toValue() > 5L) {
            System.out.println("The reading is high: " + stopwatch);
        } else {
            System.out.println("The reading is low: " + stopwatch);
        }
    }

    public void start() {
        if (this.fIsRunning) {
            throw new IllegalStateException("Must stop before calling start again.");
        }
        this.fStart = System.currentTimeMillis();
        this.fStop = 0L;
        this.fIsRunning = true;
        this.fHasBeenUsedOnce = true;
    }

    public void stop() {
        if (!this.fIsRunning) {
            throw new IllegalStateException("Cannot stop if not currently running.");
        }
        this.fStop = System.currentTimeMillis();
        this.fIsRunning = false;
    }

    public String toString() {
        this.validateIsReadable();
        StringBuilder result = new StringBuilder();
        result.append(this.fStop - this.fStart);
        result.append(" ms");
        return result.toString();
    }

    public long toValue() {
        this.validateIsReadable();
        return this.fStop - this.fStart;
    }

    private void validateIsReadable() {
        if (this.fIsRunning) {
            String message = "Cannot read a stopwatch which is still running.";
            throw new IllegalStateException("Cannot read a stopwatch which is still running.");
        }
        if (!this.fHasBeenUsedOnce) {
            String message = "Cannot read a stopwatch which has never been started.";
            throw new IllegalStateException("Cannot read a stopwatch which has never been started.");
        }
    }
}

