/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.List;
import org.renjin.eval.EvalException;
import org.renjin.primitives.Indexes;
import org.renjin.primitives.subset.Selection;
import org.renjin.primitives.subset.Subscript;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class DimensionSelection
extends Selection {
    private final SEXP source;
    private final int[] sourceDim;
    private Subscript[] subscripts;
    private int[] dim;
    private int elementCount;

    public DimensionSelection(SEXP source, List<SEXP> subscriptArguments) {
        super(source);
        Preconditions.checkArgument((subscriptArguments.size() > 1 ? 1 : 0) != 0, (Object)"ArrayElementSet at least 2 subscripts");
        this.source = source;
        this.sourceDim = DimensionSelection.dimAsIntArray(source);
        if (subscriptArguments.size() != this.sourceDim.length) {
            throw new EvalException("Incorrect number of dimensions. Subscripts: " + subscriptArguments.size() + ", source dimension: " + this.sourceDim.length, new Object[0]);
        }
        this.subscripts = new Subscript[subscriptArguments.size()];
        for (int i = 0; i != this.subscripts.length; ++i) {
            this.subscripts[i] = this.parseSubscript(subscriptArguments.get(i), i, this.sourceDim[i]);
        }
        this.dim = new int[this.sourceDim.length];
        this.elementCount = 1;
        for (int d = 0; d != this.sourceDim.length; ++d) {
            int count;
            this.dim[d] = count = this.subscripts[d].getCount();
            this.elementCount *= count;
        }
    }

    @Override
    public int getSourceDimensions() {
        return this.sourceDim.length;
    }

    @Override
    public int getElementCount() {
        return this.elementCount;
    }

    @Override
    public int[] getSubscriptDimensions() {
        return this.dim;
    }

    @Override
    public Iterator<Integer> iterator() {
        if (this.isEmpty()) {
            return Iterators.emptyIterator();
        }
        return new IndexIterator();
    }

    @Override
    protected AtomicVector getNames(int dimensionIndex) {
        Vector dimNames = (Vector)this.source.getAttribute(Symbols.DIMNAMES);
        if (dimNames == Null.INSTANCE) {
            throw new EvalException("no 'dimnames' attribute for array", new Object[0]);
        }
        return (AtomicVector)dimNames.getElementAsSEXP(dimensionIndex);
    }

    @Override
    public Iterable<Integer> getSelectionAlongDimension(int dimensionIndex) {
        final Subscript subscript = this.subscripts[dimensionIndex];
        final int length2 = subscript.getCount();
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new UnmodifiableIterator<Integer>(){
                    int i = 0;

                    public boolean hasNext() {
                        return this.i < length2;
                    }

                    public Integer next() {
                        return subscript.getAt(this.i++);
                    }
                };
            }
        };
    }

    @Override
    protected Vector selectDimensionNames(int dimIndex, Vector sourceNames) {
        Subscript subscript = this.subscripts[dimIndex];
        if (subscript.definitelySelectsAllElements()) {
            return sourceNames;
        }
        return super.selectDimensionNames(dimIndex, sourceNames);
    }

    private class IndexIterator
    extends UnmodifiableIterator<Integer> {
        private int[] subscriptIndex;
        private boolean hasNext = true;

        private IndexIterator() {
            this.subscriptIndex = new int[DimensionSelection.this.dim.length];
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public Integer next() {
            int[] sourceIndices = new int[DimensionSelection.this.sourceDim.length];
            for (int i = 0; i != DimensionSelection.this.sourceDim.length; ++i) {
                sourceIndices[i] = DimensionSelection.this.subscripts[i].getAt(this.subscriptIndex[i]);
            }
            int index = Indexes.arrayIndexToVectorIndex(sourceIndices, DimensionSelection.this.sourceDim);
            this.hasNext = Indexes.incrementArrayIndex(this.subscriptIndex, DimensionSelection.this.dim);
            return index;
        }
    }
}

