/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.apache.commons.math.special.Gamma;
import org.renjin.eval.Session;
import org.renjin.sexp.DoubleVector;
import org.renjin.stats.internals.distributions.Binom;
import org.renjin.stats.internals.distributions.Exponantial;
import org.renjin.stats.internals.distributions.Normal;
import org.renjin.stats.internals.distributions.SignRank;

public class Poisson {
    static double a0 = -0.5;
    static double a1 = 0.3333333;
    static double a2 = -0.2500068;
    static double a3 = 0.2000118;
    static double a4 = -0.1661269;
    static double a5 = 0.1421878;
    static double a6 = -0.1384794;
    static double a7 = 0.125006;
    static double one_7 = 0.14285714285714285;
    static double one_12 = 0.08333333333333333;
    static double one_24 = 0.041666666666666664;
    static final double[] fact = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0};
    static int l;
    static int m;
    static double b1;
    static double b2;
    static double c;
    static double c0;
    static double c1;
    static double c2;
    static double c3;
    static double[] pp;
    static double p0;
    static double p;
    static double q;
    static double s;
    static double d;
    static double omega;
    static double big_l;
    static double muprev;
    static double muprev2;
    static double M_1_SQRT_2PI;

    public static double fsign(double x, double y) {
        return y >= 0.0 ? Math.abs(x) : Math.abs(x);
    }

    public static double rpois(Session context, double mu) {
        double g;
        boolean big_mu;
        double difmuk = 0.0;
        double E = 0.0;
        double fk = 0.0;
        double u = 0.0;
        double pois = -1.0;
        int kflag = 0;
        boolean new_big_mu = false;
        boolean gotoStepF = false;
        if (mu < 0.0) {
            return Double.NaN;
        }
        if (mu <= 0.0) {
            return 0.0;
        }
        boolean bl = big_mu = mu >= 10.0;
        if (big_mu) {
            new_big_mu = false;
        }
        if (!big_mu || mu != muprev) {
            if (big_mu) {
                new_big_mu = true;
                muprev = mu;
                s = Math.sqrt(mu);
                d = 6.0 * mu * mu;
                big_l = Math.floor(mu - 1.1484);
            } else {
                if (mu != muprev) {
                    muprev = mu;
                    m = Math.max(1, (int)mu);
                    l = 0;
                    p0 = p = Math.exp(-mu);
                    q = p;
                }
                while (true) {
                    int k;
                    if ((u = context.rng.unif_rand()) <= p0) {
                        return 0.0;
                    }
                    if (l != 0) {
                        int n = k = u <= 0.458 ? 1 : Math.min(l, m);
                        while (k <= l) {
                            if (u <= pp[k]) {
                                return k;
                            }
                            ++k;
                        }
                        if (l == 35) continue;
                    }
                    for (k = ++l; k <= 35; ++k) {
                        Poisson.pp[k] = q += (p *= mu / (double)k);
                        if (!(u <= q)) continue;
                        l = k;
                        return k;
                    }
                    l = 35;
                }
            }
        }
        if ((g = mu + s * Normal.norm_rand(context)) >= 0.0) {
            pois = Math.floor(g);
            if (pois >= big_l) {
                return pois;
            }
            fk = pois;
            difmuk = mu - fk;
            u = context.rng.unif_rand();
            if (d * u >= difmuk * difmuk * difmuk) {
                return pois;
            }
        }
        if (new_big_mu || mu != muprev2) {
            muprev2 = mu;
            omega = M_1_SQRT_2PI / s;
            b1 = one_24 / mu;
            b2 = 0.3 * b1 * b1;
            c3 = one_7 * b1 * b2;
            c2 = b2 - 15.0 * c3;
            c1 = b1 - 6.0 * b2 + 45.0 * c3;
            c0 = 1.0 - b1 + 3.0 * b2 - 15.0 * c3;
            c = 0.1069 / mu;
        }
        if (g >= 0.0) {
            kflag = 0;
            gotoStepF = true;
        }
        while (true) {
            double py;
            double px;
            if (gotoStepF) {
                continue;
            }
            E = Exponantial.exp_rand(context);
            double t2 = 1.8 + Poisson.fsign(E, u = 2.0 * context.rng.unif_rand() - 1.0);
            if (t2 > -0.6744) {
                fk = pois = Math.floor(mu + s * t2);
                difmuk = mu - fk;
                kflag = 1;
            }
            if (pois < 10.0) {
                px = -mu;
                py = Math.pow(mu, pois) / fact[(int)pois];
            } else {
                double del = one_12 / fk;
                del *= 1.0 - 4.8 * del * del;
                double v = difmuk / fk;
                px = Math.abs(v) <= 0.25 ? fk * v * v * (((((((a7 * v + a6) * v + a5) * v + a4) * v + a3) * v + a2) * v + a1) * v + a0) - del : fk * Math.log(1.0 + v) - difmuk - del;
                py = M_1_SQRT_2PI / Math.sqrt(fk);
            }
            double x = (0.5 - difmuk) / s;
            x *= x;
            double fx = -0.5 * x;
            double fy = omega * (((c3 * x + c2) * x + c1) * x + c0);
            if (kflag > 0 ? c * Math.abs(u) <= py * Math.exp(px + E) - fy * Math.exp(fx + E) : fy - u * fy <= py * Math.exp(px - fx)) break;
        }
        return pois;
    }

    public static double dpois_raw(double x, double lambda, boolean give_log) {
        if (lambda == 0.0) {
            return x == 0.0 ? SignRank.R_D__1(true, give_log) : SignRank.R_D__0(true, give_log);
        }
        if (!DoubleVector.isFinite(lambda)) {
            return SignRank.R_D__0(true, give_log);
        }
        if (x < 0.0) {
            return SignRank.R_D__0(true, give_log);
        }
        if (x <= lambda * Double.MIN_VALUE) {
            return SignRank.R_D_exp(-lambda, true, give_log);
        }
        if (lambda < x * Double.MIN_VALUE) {
            return SignRank.R_D_exp(-lambda + x * Math.log(lambda) - Gamma.logGamma((double)(x + 1.0)), true, give_log);
        }
        return SignRank.R_D_fexp(Math.PI * 2 * x, -Binom.stirlerr(x) - Binom.bd0(x, lambda), true, give_log);
    }

    static {
        pp = new double[36];
        muprev = 0.0;
        muprev2 = 0.0;
        M_1_SQRT_2PI = 0.3989422804014327;
    }
}

