/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.transform;

import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import jitk.spline.ThinPlateR2LogRSplineKernelTransform;
import mpicbg.trakem2.transform.CoordinateTransform;
import org.apache.commons.codec.binary.Base64;

public class ThinPlateSplineTransform
implements CoordinateTransform {
    private static final long serialVersionUID = 2214564089916179653L;
    private ThinPlateR2LogRSplineKernelTransform tps;

    public ThinPlateSplineTransform() {
    }

    public ThinPlateSplineTransform(ThinPlateR2LogRSplineKernelTransform tps) {
        this.tps = tps;
    }

    private static String encodeBase64(double[] src) {
        byte[] bytes = new byte[src.length * 8];
        int j = -1;
        for (int i = 0; i < src.length; ++i) {
            long bits = Double.doubleToLongBits(src[i]);
            bytes[++j] = (byte)(bits >> 56);
            bytes[++j] = (byte)(bits >> 48 & 0xFFL);
            bytes[++j] = (byte)(bits >> 40 & 0xFFL);
            bytes[++j] = (byte)(bits >> 32 & 0xFFL);
            bytes[++j] = (byte)(bits >> 24 & 0xFFL);
            bytes[++j] = (byte)(bits >> 16 & 0xFFL);
            bytes[++j] = (byte)(bits >> 8 & 0xFFL);
            bytes[++j] = (byte)(bits & 0xFFL);
        }
        Deflater deflater = new Deflater();
        deflater.setInput(bytes);
        deflater.finish();
        byte[] zipped = new byte[bytes.length];
        int n = deflater.deflate(zipped);
        if (n == bytes.length) {
            return '@' + Base64.encodeBase64String((byte[])bytes);
        }
        return Base64.encodeBase64String((byte[])Arrays.copyOf(zipped, n));
    }

    private static double[] decodeBase64(String src, int n) throws DataFormatException {
        byte[] bytes;
        if (src.charAt(0) == '@') {
            bytes = Base64.decodeBase64((String)src.substring(1));
        } else {
            bytes = new byte[n * 8];
            byte[] zipped = Base64.decodeBase64((String)src);
            Inflater inflater = new Inflater();
            inflater.setInput(zipped, 0, zipped.length);
            inflater.inflate(bytes);
            inflater.end();
        }
        double[] doubles = new double[n];
        int j = -1;
        for (int i = 0; i < n; ++i) {
            long bits = 0L;
            bits |= ((long)bytes[++j] & 0xFFL) << 56;
            bits |= ((long)bytes[++j] & 0xFFL) << 48;
            bits |= ((long)bytes[++j] & 0xFFL) << 40;
            bits |= ((long)bytes[++j] & 0xFFL) << 32;
            bits |= ((long)bytes[++j] & 0xFFL) << 24;
            bits |= ((long)bytes[++j] & 0xFFL) << 16;
            bits |= ((long)bytes[++j] & 0xFFL) << 8;
            doubles[i] = Double.longBitsToDouble(bits |= (long)bytes[++j] & 0xFFL);
        }
        return doubles;
    }

    public double[] apply(double[] location) {
        double[] out = (double[])location.clone();
        this.applyInPlace(out);
        return out;
    }

    public void applyInPlace(double[] location) {
        this.tps.applyInPlace(location);
    }

    @Override
    public void init(String data) throws NumberFormatException {
        double[] values;
        String[] fields = data.split("\\s+");
        int i = 0;
        int ndims = Integer.parseInt(fields[++i]);
        int nLm = Integer.parseInt(fields[++i]);
        double[][] aMtx = null;
        double[] bVec = null;
        if (fields[i + 1].equals("null")) {
            ++i;
        } else {
            aMtx = new double[ndims][ndims];
            bVec = new double[ndims];
            try {
                values = ThinPlateSplineTransform.decodeBase64(fields[++i], ndims * ndims + ndims);
            }
            catch (DataFormatException e) {
                throw new NumberFormatException("Failed decoding affine matrix.");
            }
            int l = -1;
            for (int k = 0; k < ndims; ++k) {
                for (int j = 0; j < ndims; ++j) {
                    aMtx[k][j] = values[++l];
                }
            }
            for (int j = 0; j < ndims; ++j) {
                bVec[j] = values[++l];
            }
        }
        try {
            values = ThinPlateSplineTransform.decodeBase64(fields[++i], 2 * nLm * ndims);
        }
        catch (DataFormatException e) {
            throw new NumberFormatException("Failed decoding landmarks and weights.");
        }
        int k = -1;
        double[][] srcPts = new double[ndims][nLm];
        for (int l = 0; l < nLm; ++l) {
            for (int d = 0; d < ndims; ++d) {
                srcPts[d][l] = values[++k];
            }
        }
        int m = -1;
        double[] dMtxDat = new double[nLm * ndims];
        for (int l = 0; l < nLm; ++l) {
            for (int d = 0; d < ndims; ++d) {
                dMtxDat[++m] = values[++k];
            }
        }
        this.tps = new ThinPlateR2LogRSplineKernelTransform(srcPts, aMtx, bVec, dMtxDat);
    }

    @Override
    public String toXML(String indent) {
        StringBuilder xml = new StringBuilder();
        xml.append(indent).append("<ict_transform class=\"").append(this.getClass().getCanonicalName()).append("\" data=\"");
        this.toDataString(xml);
        return xml.append("\"/>").toString();
    }

    @Override
    public String toDataString() {
        StringBuilder data = new StringBuilder();
        this.toDataString(data);
        return data.toString();
    }

    @Override
    public CoordinateTransform copy() {
        return new ThinPlateSplineTransform(this.tps);
    }

    private final void toDataString(StringBuilder data) {
        int i;
        int k;
        double[] buffer;
        data.append("ThinPlateSplineR2LogR");
        int ndims = this.tps.getNumDims();
        int nLm = this.tps.getNumLandmarks();
        data.append(' ').append(ndims);
        data.append(' ').append(nLm);
        if (this.tps.getAffine() == null) {
            data.append(' ').append("null");
        } else {
            double[][] aMtx = this.tps.getAffine();
            double[] bVec = this.tps.getTranslation();
            buffer = new double[ndims * ndims + ndims];
            k = -1;
            for (i = 0; i < ndims; ++i) {
                for (int j = 0; j < ndims; ++j) {
                    buffer[++k] = aMtx[i][j];
                }
            }
            for (i = 0; i < ndims; ++i) {
                buffer[++k] = bVec[i];
            }
            data.append(' ').append(ThinPlateSplineTransform.encodeBase64(buffer));
        }
        double[][] srcPts = this.tps.getSourceLandmarks();
        double[] dMtxDat = this.tps.getKnotWeights();
        buffer = new double[2 * nLm * ndims];
        k = -1;
        for (int l = 0; l < nLm; ++l) {
            for (int d = 0; d < ndims; ++d) {
                buffer[++k] = srcPts[d][l];
            }
        }
        for (i = 0; i < ndims * nLm; ++i) {
            buffer[++k] = dMtxDat[i];
        }
        data.append(' ').append(ThinPlateSplineTransform.encodeBase64(buffer));
    }
}

