/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.filter;

import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.filter.Enhancement;
import ucar.nc2.filter.FilterHelpers;
import ucar.nc2.iosp.netcdf3.N3iosp;

public class ConvertMissing
implements Enhancement {
    private boolean hasValidMin;
    private boolean hasValidMax;
    private double validMin;
    private double validMax;
    private boolean hasFillValue;
    private double fillValue;
    private boolean hasMissingValue;
    private double[] missingValue;
    private boolean invalidDataIsMissing;
    private boolean fillValueIsMissing;
    private boolean missingDataIsMissing;

    public static ConvertMissing createFromVariable(VariableDS var) {
        double fillValue;
        DataType.Signedness signedness = var.getSignedness();
        double validMin = -1.7976931348623157E308;
        double validMax = Double.MAX_VALUE;
        boolean hasValidMin = false;
        boolean hasValidMax = false;
        Attribute validRangeAtt = var.findAttribute("valid_range");
        DataType validType = null;
        if (validRangeAtt != null && !validRangeAtt.isString() && validRangeAtt.getLength() > 1) {
            validType = FilterHelpers.getAttributeDataType(validRangeAtt, signedness);
            validMin = var.convertUnsigned(validRangeAtt.getNumericValue(0), validType).doubleValue();
            validMax = var.convertUnsigned(validRangeAtt.getNumericValue(1), validType).doubleValue();
            hasValidMin = true;
            hasValidMax = true;
        }
        Attribute validMinAtt = var.findAttribute("valid_min");
        Attribute validMaxAtt = var.findAttribute("valid_max");
        if (!hasValidMin) {
            if (validMinAtt != null && !validMinAtt.isString()) {
                validType = FilterHelpers.getAttributeDataType(validMinAtt, signedness);
                validMin = var.convertUnsigned(validMinAtt.getNumericValue(), validType).doubleValue();
                hasValidMin = true;
            }
            if (validMaxAtt != null && !validMaxAtt.isString()) {
                validType = FilterHelpers.largestOf(validType, FilterHelpers.getAttributeDataType(validMaxAtt, signedness));
                validMax = var.convertUnsigned(validMaxAtt.getNumericValue(), validType).doubleValue();
                hasValidMax = true;
            }
        }
        if (validMin > validMax) {
            double temp = validMin;
            validMin = validMax;
            validMax = temp;
        }
        boolean hasFillValue = !Double.isNaN(fillValue = ConvertMissing.getFillValueOrDefault(var));
        double[] missingValue = null;
        Attribute missingValueAtt = var.findAttribute("missing_value");
        if (missingValueAtt != null) {
            if (missingValueAtt.isString()) {
                String svalue = missingValueAtt.getStringValue();
                if (var.getOriginalDataType() == DataType.CHAR) {
                    missingValue = new double[1];
                    missingValue[0] = svalue.isEmpty() ? 0.0 : (double)svalue.charAt(0);
                } else {
                    try {
                        missingValue = new double[]{Double.parseDouble(svalue)};
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                missingValue = new double[missingValueAtt.getLength()];
                DataType missingType = FilterHelpers.getAttributeDataType(missingValueAtt, signedness);
                for (int i = 0; i < missingValue.length; ++i) {
                    missingValue[i] = var.convertUnsigned(missingValueAtt.getNumericValue(i), missingType).doubleValue();
                }
            }
        }
        return new ConvertMissing(var.fillValueIsMissing(), var.invalidDataIsMissing(), var.missingDataIsMissing(), hasValidMin, hasValidMax, validMin, validMax, hasFillValue, fillValue, missingValue);
    }

    public ConvertMissing(boolean fillValueIsMissing, boolean invalidDataIsMissing, boolean missingDataIsMissing, boolean hasValidMin, boolean hasValidMax, double validMin, double validMax, boolean hasFillValue, double fillValue, double[] missingValue) {
        this.fillValueIsMissing = fillValueIsMissing;
        this.invalidDataIsMissing = invalidDataIsMissing;
        this.missingDataIsMissing = missingDataIsMissing;
        this.hasValidMin = hasValidMin;
        this.hasValidMax = hasValidMax;
        this.validMin = validMin;
        this.validMax = validMax;
        this.hasFillValue = hasFillValue;
        this.fillValue = fillValue;
        this.missingValue = missingValue;
        this.hasMissingValue = false;
        if (this.missingDataIsMissing && this.missingValue != null) {
            ArrayList<Double> missing = new ArrayList<Double>();
            for (double mv : this.missingValue) {
                if (Double.isNaN(mv) || fillValueIsMissing && hasFillValue && mv == fillValue || invalidDataIsMissing && hasValidMin && mv < validMin || invalidDataIsMissing && hasValidMax && mv > validMax) continue;
                missing.add(mv);
            }
            int nMissing = missing.size();
            this.missingValue = new double[nMissing];
            for (int i = 0; i < nMissing; ++i) {
                this.missingValue[i] = (Double)missing.get(i);
            }
            this.hasMissingValue = this.missingValue.length > 0;
        }
    }

    public boolean hasValidData() {
        return this.hasValidMin || this.hasValidMax;
    }

    public double getValidMin() {
        return this.validMin;
    }

    public double getValidMax() {
        return this.validMax;
    }

    public boolean isInvalidData(double val) {
        if (Double.isNaN(val)) {
            return true;
        }
        if (val > this.validMax) {
            return true;
        }
        return val < this.validMin;
    }

    public boolean hasFillValue() {
        return this.hasFillValue;
    }

    public boolean isFillValue(double val) {
        return this.hasFillValue && val == this.fillValue;
    }

    public double getFillValue() {
        return this.fillValue;
    }

    public boolean isMissingValue(double val) {
        for (double aMissingValue : this.missingValue) {
            if (val != aMissingValue) continue;
            return true;
        }
        return false;
    }

    public double[] getMissingValues() {
        return this.missingValue;
    }

    public boolean hasMissingValue() {
        return this.hasMissingValue;
    }

    public boolean hasMissing() {
        return this.invalidDataIsMissing && this.hasValidData() || this.fillValueIsMissing && this.hasFillValue() || this.missingDataIsMissing && this.hasMissingValue();
    }

    public boolean isMissing(double val) {
        if (Double.isNaN(val)) {
            return true;
        }
        return this.missingDataIsMissing && this.hasMissingValue && this.isMissingValue(val) || this.fillValueIsMissing && this.hasFillValue && this.isFillValue(val) || this.invalidDataIsMissing && this.hasValidData() && this.isInvalidData(val);
    }

    @Deprecated
    public void setFillValueIsMissing(boolean b) {
        this.fillValueIsMissing = b;
    }

    @Deprecated
    public void setInvalidDataIsMissing(boolean b) {
        this.invalidDataIsMissing = b;
    }

    @Deprecated
    public void setMissingDataIsMissing(boolean b) {
        this.missingDataIsMissing = b;
    }

    @Override
    public double convert(double value) {
        return this.isMissing(value) ? Double.NaN : value;
    }

    public Array convertMissing(Array in) {
        DataType type = in.getDataType();
        if (!type.isNumeric()) {
            return in;
        }
        if (!this.hasMissing()) {
            return in;
        }
        Array out = Array.factory(type, in.getShape());
        IndexIterator iterIn = in.getIndexIterator();
        IndexIterator iterOut = out.getIndexIterator();
        while (iterIn.hasNext()) {
            Number value = (Number)iterIn.getObjectNext();
            value = this.convert(value.doubleValue());
            iterOut.setObjectNext(value);
        }
        return out;
    }

    public static double getFillValueOrDefault(VariableDS var) {
        DataType fillType;
        String ncfileId;
        Attribute fillValueAtt = var.findAttribute("_FillValue");
        if (fillValueAtt != null && !fillValueAtt.isString()) {
            DataType fillType2 = FilterHelpers.getAttributeDataType(fillValueAtt, var.getSignedness());
            return var.convertUnsigned(fillValueAtt.getNumericValue(), fillType2).doubleValue();
        }
        String string = ncfileId = var.getOriginalVariable() == null ? null : var.getOriginalVariable().getFileTypeId();
        if ((DataFormatType.NETCDF.getDescription().equals(ncfileId) || DataFormatType.NETCDF4.getDescription().equals(ncfileId)) && (fillType = var.getDataType()).isNumeric()) {
            return var.convertUnsigned(N3iosp.getFillValueDefault(fillType), fillType).doubleValue();
        }
        return Double.NaN;
    }
}

