/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.imagej.ops.Namespace;
import net.imagej.ops.Op;
import net.imagej.ops.OpCandidate;
import net.imagej.ops.OpInfo;
import net.imagej.ops.OpMatchingService;
import net.imagej.ops.OpMethod;
import net.imagej.ops.OpRef;
import net.imagej.ops.OpUtils;
import net.imagej.ops.Ops;
import net.imagej.ops.coloc.ColocNamespace;
import net.imagej.ops.convert.ConvertNamespace;
import net.imagej.ops.copy.CopyNamespace;
import net.imagej.ops.create.CreateNamespace;
import net.imagej.ops.deconvolve.DeconvolveNamespace;
import net.imagej.ops.eval.DefaultEval;
import net.imagej.ops.features.haralick.HaralickNamespace;
import net.imagej.ops.features.lbp2d.LBPNamespace;
import net.imagej.ops.features.tamura2d.TamuraNamespace;
import net.imagej.ops.features.zernike.ZernikeNamespace;
import net.imagej.ops.filter.FilterNamespace;
import net.imagej.ops.geom.GeomNamespace;
import net.imagej.ops.help.HelpCandidates;
import net.imagej.ops.help.HelpForNamespace;
import net.imagej.ops.help.HelpForOp;
import net.imagej.ops.identity.DefaultIdentity;
import net.imagej.ops.image.ImageNamespace;
import net.imagej.ops.imagemoments.ImageMomentsNamespace;
import net.imagej.ops.join.DefaultJoin2Computers;
import net.imagej.ops.join.DefaultJoin2Inplaces;
import net.imagej.ops.join.DefaultJoinComputerAndInplace;
import net.imagej.ops.join.DefaultJoinInplaceAndComputer;
import net.imagej.ops.join.DefaultJoinNComputers;
import net.imagej.ops.join.DefaultJoinNInplaces;
import net.imagej.ops.labeling.LabelingNamespace;
import net.imagej.ops.linalg.LinAlgNamespace;
import net.imagej.ops.logic.LogicNamespace;
import net.imagej.ops.lookup.LookupByName;
import net.imagej.ops.lookup.LookupByType;
import net.imagej.ops.loop.DefaultLoopComputer;
import net.imagej.ops.loop.DefaultLoopInplace;
import net.imagej.ops.map.MapBinaryComputers;
import net.imagej.ops.map.MapBinaryInplace1s;
import net.imagej.ops.map.MapIIAndIIInplace;
import net.imagej.ops.map.MapIIAndIIInplaceParallel;
import net.imagej.ops.map.MapIIInplaceParallel;
import net.imagej.ops.map.MapIterableInplace;
import net.imagej.ops.map.MapIterableToIterable;
import net.imagej.ops.map.MapNullaryII;
import net.imagej.ops.map.MapNullaryIterable;
import net.imagej.ops.map.MapUnaryComputers;
import net.imagej.ops.map.MapViewIIToII;
import net.imagej.ops.map.MapViewRAIToRAI;
import net.imagej.ops.map.MapViewRandomAccessToRandomAccess;
import net.imagej.ops.map.neighborhood.CenterAwareComputerOp;
import net.imagej.ops.map.neighborhood.DefaultMapNeighborhood;
import net.imagej.ops.map.neighborhood.MapNeighborhoodWithCenter;
import net.imagej.ops.math.MathNamespace;
import net.imagej.ops.morphology.MorphologyNamespace;
import net.imagej.ops.run.RunByName;
import net.imagej.ops.run.RunByOp;
import net.imagej.ops.run.RunByType;
import net.imagej.ops.slice.SliceRAI2RAI;
import net.imagej.ops.special.SpecialOp;
import net.imagej.ops.special.UnaryOutputFactory;
import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.computer.NullaryComputerOp;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imagej.ops.special.inplace.BinaryInplace1Op;
import net.imagej.ops.special.inplace.BinaryInplaceOp;
import net.imagej.ops.special.inplace.UnaryInplaceOp;
import net.imagej.ops.stats.StatsNamespace;
import net.imagej.ops.thread.ThreadNamespace;
import net.imagej.ops.threshold.ThresholdNamespace;
import net.imagej.ops.topology.TopologyNamespace;
import net.imagej.ops.transform.TransformNamespace;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.Shape;
import org.scijava.Contextual;
import org.scijava.command.Command;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;

public interface OpEnvironment
extends Contextual {
    public OpMatchingService matcher();

    @OpMethod(op=RunByName.class)
    default public Object run(String name, Object ... args) {
        return OpEnvironment.run(this.module(name, args));
    }

    @OpMethod(op=RunByType.class)
    default public Object run(Class<? extends Op> type, Object ... args) {
        return OpEnvironment.run(this.module(type, args));
    }

    @OpMethod(op=RunByOp.class)
    default public Object run(Op op, Object ... args) {
        return OpEnvironment.run(this.module(op, args));
    }

    @OpMethod(op=LookupByName.class)
    default public Op op(String name, Object ... args) {
        return OpUtils.unwrap(this.module(name, args), OpRef.types(new Type[]{Op.class}));
    }

    @OpMethod(op=LookupByType.class)
    default public <OP extends Op> OP op(Class<OP> type, Object ... args) {
        return (OP)OpUtils.unwrap(this.module(type, args), OpRef.types(type));
    }

    default public Op op(OpRef ref) {
        return this.op(Collections.singletonList(ref));
    }

    default public Op op(List<OpRef> refs) {
        OpCandidate match = this.matcher().findMatch(this, refs);
        return OpUtils.unwrap(match.getModule(), match.getRef());
    }

    default public Module module(String name, Object ... args) {
        return this.matcher().findMatch(this, OpRef.create(name, args)).getModule();
    }

    default public Module module(Class<? extends Op> type, Object ... args) {
        return this.matcher().findMatch(this, OpRef.create(type, args)).getModule();
    }

    default public Module module(Op op, Object ... args) {
        Module module = this.info(op).cInfo().createModule((Command)op);
        return this.matcher().assignInputs(module, args);
    }

    public OpInfo info(Class<? extends Op> var1);

    default public OpInfo info(Op op) {
        return this.info(op.getClass());
    }

    public Collection<OpInfo> infos();

    default public Collection<String> ops() {
        HashSet<String> operations = new HashSet<String>();
        for (OpInfo info : this.infos()) {
            if (!info.isNamed()) continue;
            operations.add(info.getName());
        }
        ArrayList<String> sorted = new ArrayList<String>(operations);
        Collections.sort(sorted);
        return sorted;
    }

    default public OpEnvironment parent() {
        return null;
    }

    public <NS extends Namespace> NS namespace(Class<NS> var1);

    default public int getMaxThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    default public void setMaxThreads(int maxThreads) {
        throw new UnsupportedOperationException();
    }

    @OpMethod(op=DefaultEval.class)
    default public Object eval(String expression) {
        Object result = this.run(Ops.Eval.class, expression);
        return result;
    }

    @OpMethod(op=DefaultEval.class)
    default public Object eval(String expression, Map<String, Object> vars) {
        Object result = this.run(Ops.Eval.class, expression, vars);
        return result;
    }

    @OpMethod(op=HelpForOp.class)
    default public String help(Op op) {
        String result = (String)this.run(Ops.Help.class, op);
        return result;
    }

    @OpMethod(op=HelpForNamespace.class)
    default public String help(Namespace namespace) {
        String result = (String)this.run(Ops.Help.class, namespace);
        return result;
    }

    @OpMethod(op=HelpCandidates.class)
    default public String help() {
        String result = (String)this.run(Ops.Help.class, new Object[0]);
        return result;
    }

    @OpMethod(op=HelpCandidates.class)
    default public String help(String name) {
        String result = (String)this.run(Ops.Help.class, name);
        return result;
    }

    @OpMethod(op=HelpCandidates.class)
    default public String help(String name, Class<? extends Op> opType) {
        String result = (String)this.run(Ops.Help.class, name, opType);
        return result;
    }

    @OpMethod(op=HelpCandidates.class)
    default public String help(String name, Class<? extends Op> opType, Integer arity) {
        String result = (String)this.run(Ops.Help.class, name, opType, arity);
        return result;
    }

    @OpMethod(op=HelpCandidates.class)
    default public String help(String name, Class<? extends Op> opType, Integer arity, SpecialOp.Flavor flavor) {
        String result = (String)this.run(Ops.Help.class, new Object[]{name, opType, arity, flavor});
        return result;
    }

    @OpMethod(op=DefaultIdentity.class)
    default public <A> A identity(A arg) {
        Object result = this.run(Ops.Identity.class, arg);
        return (A)result;
    }

    @OpMethod(op=DefaultJoin2Computers.class)
    default public <A, B, C> C join(C out, A in, UnaryComputerOp<A, B> first, UnaryComputerOp<B, C> second, UnaryOutputFactory<A, B> outputFactory) {
        Object result = this.run(Ops.Join.class, out, in, first, second, outputFactory);
        return (C)result;
    }

    @OpMethod(op=DefaultJoin2Inplaces.class)
    default public <A, B extends A, C extends B> C join(C arg, UnaryInplaceOp<A, B> first, UnaryInplaceOp<B, C> second) {
        Object result = this.run(Ops.Join.class, arg, first, second);
        return (C)result;
    }

    @OpMethod(op=DefaultJoinNComputers.class)
    default public <A> A join(A out, A in, List<? extends UnaryComputerOp<A, A>> ops, UnaryOutputFactory<A, A> outputFactory) {
        Object result = this.run(Ops.Join.class, out, in, ops, outputFactory);
        return (A)result;
    }

    @OpMethod(op=DefaultJoinNInplaces.class)
    default public <I, O extends I> O join(O arg, List<? extends UnaryInplaceOp<I, O>> ops) {
        Object result = this.run(Ops.Join.class, arg, ops);
        return (O)result;
    }

    @OpMethod(op=DefaultJoinInplaceAndComputer.class)
    default public <AI, AO extends AI, B> B join(B out, AO in, UnaryInplaceOp<AI, AO> first, UnaryComputerOp<AO, B> second) {
        Object result = this.run(Ops.Join.class, out, in, first, second);
        return (B)result;
    }

    @OpMethod(op=DefaultJoinComputerAndInplace.class)
    default public <A, BI, BO extends BI> BO join(BO out, A in, UnaryComputerOp<A, BO> first, UnaryInplaceOp<BI, BO> second) {
        Object result = this.run(Ops.Join.class, out, in, first, second);
        return (BO)result;
    }

    @OpMethod(op=DefaultLoopInplace.class)
    default public <I, O extends I> O loop(O arg, UnaryInplaceOp<I, O> op, int n) {
        Object result = this.run(Ops.Loop.class, arg, op, n);
        return (O)result;
    }

    @OpMethod(op=DefaultLoopComputer.class)
    default public <A> A loop(A out, A in, UnaryComputerOp<A, A> op, UnaryOutputFactory<A, A> outputFactory, int n) {
        Object result = this.run(Ops.Loop.class, out, in, op, outputFactory, n);
        return (A)result;
    }

    @OpMethod(op=MapNullaryIterable.class)
    default public <EO> Iterable<EO> map(Iterable<EO> out, NullaryComputerOp<EO> op) {
        Iterable result = (Iterable)this.run(Ops.Map.class, out, op);
        return result;
    }

    @OpMethod(op=MapNullaryII.class)
    default public <EO> Iterable<EO> map(IterableInterval<EO> out, NullaryComputerOp<EO> op) {
        IterableInterval result = (IterableInterval)this.run(Ops.Map.class, out, op);
        return result;
    }

    @OpMethod(ops={MapUnaryComputers.IIToIIParallel.class, MapUnaryComputers.IIToII.class})
    default public <EI, EO> IterableInterval<EO> map(IterableInterval<EO> out, IterableInterval<EI> in, UnaryComputerOp<EI, EO> op) {
        IterableInterval result = (IterableInterval)this.run(Ops.Map.class, out, in, op);
        return result;
    }

    @OpMethod(ops={MapUnaryComputers.IIToRAIParallel.class, MapUnaryComputers.IIToRAI.class})
    default public <EI, EO> RandomAccessibleInterval<EO> map(RandomAccessibleInterval<EO> out, IterableInterval<EI> in, UnaryComputerOp<EI, EO> op) {
        RandomAccessibleInterval result = (RandomAccessibleInterval)this.run(Ops.Map.class, out, in, op);
        return result;
    }

    @OpMethod(ops={MapUnaryComputers.RAIToIIParallel.class, MapUnaryComputers.RAIToII.class})
    default public <EI, EO> IterableInterval<EO> map(IterableInterval<EO> out, RandomAccessibleInterval<EI> in, UnaryComputerOp<EI, EO> op) {
        IterableInterval result = (IterableInterval)this.run(Ops.Map.class, out, in, op);
        return result;
    }

    @OpMethod(ops={MapBinaryComputers.IIAndIIToIIParallel.class, MapBinaryComputers.IIAndIIToII.class})
    default public <EI1, EI2, EO> IterableInterval<EO> map(IterableInterval<EO> out, IterableInterval<EI1> in1, IterableInterval<EI2> in2, BinaryComputerOp<EI1, EI2, EO> op) {
        IterableInterval result = (IterableInterval)this.run(Ops.Map.class, out, in1, in2, op);
        return result;
    }

    @OpMethod(ops={MapBinaryComputers.IIAndIIToRAIParallel.class, MapBinaryComputers.IIAndIIToRAI.class})
    default public <EI1, EI2, EO> RandomAccessibleInterval<EO> map(RandomAccessibleInterval<EO> out, IterableInterval<EI1> in1, IterableInterval<EI2> in2, BinaryComputerOp<EI1, EI2, EO> op) {
        RandomAccessibleInterval result = (RandomAccessibleInterval)this.run(Ops.Map.class, out, in1, in2, op);
        return result;
    }

    @OpMethod(ops={MapBinaryComputers.IIAndRAIToIIParallel.class, MapBinaryComputers.IIAndRAIToII.class})
    default public <EI1, EI2, EO> IterableInterval<EO> map(IterableInterval<EO> out, IterableInterval<EI1> in1, RandomAccessibleInterval<EI2> in2, BinaryComputerOp<EI1, EI2, EO> op) {
        IterableInterval result = (IterableInterval)this.run(Ops.Map.class, out, in1, in2, op);
        return result;
    }

    @OpMethod(ops={MapBinaryComputers.IIAndRAIToRAIParallel.class, MapBinaryComputers.IIAndRAIToRAI.class})
    default public <EI1, EI2, EO> RandomAccessibleInterval<EO> map(RandomAccessibleInterval<EO> out, IterableInterval<EI1> in1, RandomAccessibleInterval<EI2> in2, BinaryComputerOp<EI1, EI2, EO> op) {
        RandomAccessibleInterval result = (RandomAccessibleInterval)this.run(Ops.Map.class, out, in1, in2, op);
        return result;
    }

    @OpMethod(ops={MapBinaryComputers.RAIAndIIToIIParallel.class, MapBinaryComputers.RAIAndIIToII.class})
    default public <EI1, EI2, EO> IterableInterval<EO> map(IterableInterval<EO> out, RandomAccessibleInterval<EI1> in1, IterableInterval<EI2> in2, BinaryComputerOp<EI1, EI2, EO> op) {
        IterableInterval result = (IterableInterval)this.run(Ops.Map.class, out, in1, in2, op);
        return result;
    }

    @OpMethod(ops={MapBinaryComputers.RAIAndIIToRAIParallel.class, MapBinaryComputers.RAIAndIIToRAI.class})
    default public <EI1, EI2, EO> RandomAccessibleInterval<EO> map(RandomAccessibleInterval<EO> out, RandomAccessibleInterval<EI1> in1, IterableInterval<EI2> in2, BinaryComputerOp<EI1, EI2, EO> op) {
        RandomAccessibleInterval result = (RandomAccessibleInterval)this.run(Ops.Map.class, out, in1, in2, op);
        return result;
    }

    @OpMethod(ops={MapBinaryComputers.RAIAndRAIToIIParallel.class, MapBinaryComputers.RAIAndRAIToII.class})
    default public <EI1, EI2, EO> IterableInterval<EO> map(IterableInterval<EO> out, RandomAccessibleInterval<EI1> in1, RandomAccessibleInterval<EI2> in2, BinaryComputerOp<EI1, EI2, EO> op) {
        IterableInterval result = (IterableInterval)this.run(Ops.Map.class, out, in1, in2, op);
        return result;
    }

    @OpMethod(op=MapViewRAIToRAI.class)
    default public <EI, EO extends net.imglib2.type.Type<EO>> RandomAccessibleInterval<EO> map(RandomAccessibleInterval<EI> input, UnaryComputerOp<EI, EO> op, EO type) {
        RandomAccessibleInterval result = (RandomAccessibleInterval)this.run(Ops.Map.class, input, op, type);
        return result;
    }

    @OpMethod(op=MapViewRandomAccessToRandomAccess.class)
    default public <EI, EO extends net.imglib2.type.Type<EO>> RandomAccessible<EO> map(RandomAccessible<EI> input, UnaryComputerOp<EI, EO> op, EO type) {
        RandomAccessible result = (RandomAccessible)this.run(Ops.Map.class, input, op, type);
        return result;
    }

    @OpMethod(op=MapViewIIToII.class)
    default public <EI, EO extends net.imglib2.type.Type<EO>> IterableInterval<EO> map(IterableInterval<EI> input, UnaryComputerOp<EI, EO> op, EO type) {
        IterableInterval result = (IterableInterval)this.run(Ops.Map.class, input, op, type);
        return result;
    }

    @OpMethod(op=MapIIInplaceParallel.class)
    default public <EI, EO extends EI> IterableInterval<EO> map(IterableInterval<EO> arg, UnaryInplaceOp<EI, EO> op) {
        IterableInterval result = (IterableInterval)this.run(Ops.Map.class, arg, op);
        return result;
    }

    @OpMethod(op=MapIterableInplace.class)
    default public <EI, EO extends EI> Iterable<EO> map(Iterable<EO> arg, UnaryInplaceOp<EI, EO> op) {
        Iterable result = (Iterable)this.run(Ops.Map.class, arg, op);
        return result;
    }

    @OpMethod(op=DefaultMapNeighborhood.class)
    default public <EI, EO> IterableInterval<EO> map(IterableInterval<EO> out, RandomAccessibleInterval<EI> in, Shape shape, UnaryComputerOp<Iterable<EI>, EO> op) {
        IterableInterval result = (IterableInterval)this.run(Ops.Map.class, out, in, op, shape);
        return result;
    }

    @OpMethod(op=MapNeighborhoodWithCenter.class)
    default public <EI, EO> IterableInterval<EO> map(IterableInterval<EO> out, RandomAccessibleInterval<EI> in, Shape shape, CenterAwareComputerOp<EI, EO> func) {
        IterableInterval result = (IterableInterval)this.run(Ops.Map.class, out, in, func, shape);
        return result;
    }

    @OpMethod(op=MapIterableToIterable.class)
    default public <EI, EO> Iterable<EO> map(Iterable<EO> out, Iterable<EI> in, UnaryComputerOp<EI, EO> op) {
        Iterable result = (Iterable)this.run(Ops.Map.class, out, in, op);
        return result;
    }

    @OpMethod(ops={MapIIAndIIInplaceParallel.class, MapIIAndIIInplace.class})
    default public <EI, EO extends EI> IterableInterval<EO> map(IterableInterval<EO> arg, IterableInterval<EO> in, BinaryInplaceOp<EI, EO> op) {
        IterableInterval result = (IterableInterval)this.run(Ops.Map.class, arg, in, op);
        return result;
    }

    @OpMethod(ops={MapBinaryInplace1s.IIAndIIParallel.class, MapBinaryInplace1s.IIAndII.class})
    default public <EI1, EI2, EO extends EI1> IterableInterval<EO> map(IterableInterval<EO> arg, IterableInterval<EI2> in, BinaryInplace1Op<EI1, EI2, EO> op) {
        IterableInterval result = (IterableInterval)this.run(Ops.Map.class, arg, in, op);
        return result;
    }

    @OpMethod(ops={MapBinaryInplace1s.IIAndRAIParallel.class, MapBinaryInplace1s.IIAndRAI.class})
    default public <EI1, EI2, EO extends EI1> IterableInterval<EO> map(IterableInterval<EO> arg, RandomAccessibleInterval<EI2> in, BinaryInplace1Op<EI1, EI2, EO> op) {
        IterableInterval result = (IterableInterval)this.run(Ops.Map.class, arg, in, op);
        return result;
    }

    @OpMethod(ops={MapBinaryInplace1s.RAIAndIIParallel.class, MapBinaryInplace1s.RAIAndII.class})
    default public <EI1, EI2, EO extends EI1> RandomAccessibleInterval<EO> map(RandomAccessibleInterval<EO> arg, IterableInterval<EI2> in, BinaryInplace1Op<EI1, EI2, EO> op) {
        RandomAccessibleInterval result = (RandomAccessibleInterval)this.run(Ops.Map.class, arg, in, op);
        return result;
    }

    @OpMethod(op=SliceRAI2RAI.class)
    default public <I, O> RandomAccessibleInterval<O> slice(RandomAccessibleInterval<O> out, RandomAccessibleInterval<I> in, UnaryComputerOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<O>> op, int ... axisIndices) {
        RandomAccessibleInterval result = (RandomAccessibleInterval)this.run(Ops.Slice.class, out, in, op, axisIndices);
        return result;
    }

    @OpMethod(op=SliceRAI2RAI.class)
    default public <I, O> RandomAccessibleInterval<O> slice(RandomAccessibleInterval<O> out, RandomAccessibleInterval<I> in, UnaryComputerOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<O>> op, int[] axisIndices, boolean dropSingleDimensions) {
        RandomAccessibleInterval result = (RandomAccessibleInterval)this.run(Ops.Slice.class, out, in, op, axisIndices, dropSingleDimensions);
        return result;
    }

    default public ColocNamespace coloc() {
        return this.namespace(ColocNamespace.class);
    }

    default public CopyNamespace copy() {
        return this.namespace(CopyNamespace.class);
    }

    default public ConvertNamespace convert() {
        return this.namespace(ConvertNamespace.class);
    }

    default public CreateNamespace create() {
        return this.namespace(CreateNamespace.class);
    }

    default public DeconvolveNamespace deconvolve() {
        return this.namespace(DeconvolveNamespace.class);
    }

    default public FilterNamespace filter() {
        return this.namespace(FilterNamespace.class);
    }

    default public GeomNamespace geom() {
        return this.namespace(GeomNamespace.class);
    }

    default public HaralickNamespace haralick() {
        return this.namespace(HaralickNamespace.class);
    }

    default public ImageNamespace image() {
        return this.namespace(ImageNamespace.class);
    }

    default public ImageMomentsNamespace imagemoments() {
        return this.namespace(ImageMomentsNamespace.class);
    }

    default public LabelingNamespace labeling() {
        return this.namespace(LabelingNamespace.class);
    }

    default public LBPNamespace lbp() {
        return this.namespace(LBPNamespace.class);
    }

    default public LinAlgNamespace linalg() {
        return this.namespace(LinAlgNamespace.class);
    }

    default public LogicNamespace logic() {
        return this.namespace(LogicNamespace.class);
    }

    default public MathNamespace math() {
        return this.namespace(MathNamespace.class);
    }

    default public MorphologyNamespace morphology() {
        return this.namespace(MorphologyNamespace.class);
    }

    default public StatsNamespace stats() {
        return this.namespace(StatsNamespace.class);
    }

    default public TamuraNamespace tamura() {
        return this.namespace(TamuraNamespace.class);
    }

    default public ThreadNamespace thread() {
        return this.namespace(ThreadNamespace.class);
    }

    default public ThresholdNamespace threshold() {
        return this.namespace(ThresholdNamespace.class);
    }

    default public TopologyNamespace topology() {
        return this.namespace(TopologyNamespace.class);
    }

    default public TransformNamespace transform() {
        return this.namespace(TransformNamespace.class);
    }

    default public ZernikeNamespace zernike() {
        return this.namespace(ZernikeNamespace.class);
    }

    public static Object run(Module module) {
        module.run();
        ArrayList<Object> outputs = new ArrayList<Object>();
        for (ModuleItem output : module.getInfo().outputs()) {
            Object value = output.getValue(module);
            outputs.add(value);
        }
        return outputs.size() == 1 ? outputs.get(0) : outputs;
    }
}

