/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.lut;

import ij.ImageJ;
import ij.ImagePlus;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.realtransform.InverseRealTransform;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformRandomAccessible;
import net.imglib2.realtransform.RealViews;
import net.imglib2.view.Views;
import org.janelia.thickness.lut.AbstractLUTRealTransform;

public class SingleDimensionLUTRealTransform
extends AbstractLUTRealTransform {
    protected final int d;

    public SingleDimensionLUTRealTransform(double[] lut, int numSourceDimensions, int numTargetDimensions, int d) {
        super(lut, numSourceDimensions, numTargetDimensions);
        this.d = d;
    }

    public void apply(double[] source, double[] target) {
        assert (source.length == target.length) : "Dimensions do not match.";
        for (int d = 0; d < target.length; ++d) {
            target[d] = source[d];
        }
        target[this.d] = this.applyChecked(source[this.d]);
    }

    public void apply(float[] source, float[] target) {
        assert (source.length == target.length) : "Dimensions do not match.";
        for (int d = 0; d < target.length; ++d) {
            target[d] = source[d];
        }
        target[this.d] = (float)this.applyChecked(source[this.d]);
    }

    public void apply(RealLocalizable source, RealPositionable target) {
        assert (source.numDimensions() == target.numDimensions()) : "Dimensions do not match.";
        target.setPosition(source);
        target.setPosition(this.applyChecked(source.getDoublePosition(this.d)), this.d);
    }

    public SingleDimensionLUTRealTransform copy() {
        return new SingleDimensionLUTRealTransform(this.lut, this.numSourceDimensions, this.numTargetDimensions, this.d);
    }

    public void applyInverse(double[] source, double[] target) {
        assert (source.length == target.length) : "Dimensions do not match.";
        for (int d = 0; d < target.length; ++d) {
            source[d] = target[d];
        }
        source[this.d] = this.applyInverseChecked(target[this.d]);
    }

    public void applyInverse(float[] source, float[] target) {
        assert (source.length == target.length) : "Dimensions do not match.";
        for (int d = 0; d < target.length; ++d) {
            source[d] = target[d];
        }
        source[this.d] = (float)this.applyInverseChecked(target[this.d]);
    }

    public void applyInverse(RealPositionable source, RealLocalizable target) {
        assert (source.numDimensions() == target.numDimensions()) : "Dimensions do not match.";
        source.setPosition(target);
        source.setPosition(this.applyInverseChecked(target.getDoublePosition(this.d)), this.d);
    }

    public InvertibleRealTransform inverse() {
        return new InverseRealTransform((InvertibleRealTransform)this);
    }

    public static final void main(String[] args) {
        new ImageJ();
        ImagePlus imp = new ImagePlus("http://media.npr.org/images/picture-show-flickr-promo.jpg");
        imp.show();
        float[] pixels = (float[])imp.getProcessor().convertToFloat().getPixels();
        ArrayImg img = ArrayImgs.floats((float[])pixels, (long[])new long[]{imp.getWidth(), imp.getHeight()});
        double[] lut = new double[Math.max(imp.getWidth(), imp.getHeight())];
        for (int i = 0; i < lut.length; ++i) {
            lut[i] = (double)i + Math.pow(i, 1.5);
        }
        SingleDimensionLUTRealTransform transform = new SingleDimensionLUTRealTransform(lut, 2, 2, 1);
        RealRandomAccessible source = Views.interpolate((EuclideanSpace)Views.extendBorder((RandomAccessibleInterval)img), (InterpolatorFactory)new NLinearInterpolatorFactory());
        RealTransformRandomAccessible target = new RealTransformRandomAccessible(source, (RealTransform)transform);
        RealTransformRandomAccessible target2 = RealViews.transform((RealRandomAccessible)source, (InvertibleRealTransform)transform);
        ImageJFunctions.show((RandomAccessibleInterval)Views.interval((RandomAccessible)target, (Interval)new FinalInterval(new long[]{imp.getWidth(), imp.getHeight()})));
        ImageJFunctions.show((RandomAccessibleInterval)Views.interval((RandomAccessible)target2, (Interval)new FinalInterval(new long[]{imp.getWidth(), imp.getHeight()})));
    }
}

