/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi;

import java.util.Arrays;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.imglib2.EuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.roi.BoundaryType;
import net.imglib2.roi.Bounds;
import net.imglib2.roi.KnownConstant;
import net.imglib2.roi.Mask;
import net.imglib2.roi.MaskInterval;
import net.imglib2.roi.RealMask;
import net.imglib2.roi.RealMaskRealInterval;
import net.imglib2.roi.composite.DefaultBinaryCompositeMask;
import net.imglib2.roi.composite.DefaultBinaryCompositeMaskInterval;
import net.imglib2.roi.composite.DefaultBinaryCompositeRealMask;
import net.imglib2.roi.composite.DefaultBinaryCompositeRealMaskRealInterval;
import net.imglib2.roi.composite.DefaultUnaryCompositeMask;
import net.imglib2.roi.composite.DefaultUnaryCompositeMaskInterval;
import net.imglib2.roi.composite.DefaultUnaryCompositeRealMask;
import net.imglib2.roi.composite.DefaultUnaryCompositeRealMaskRealInterval;
import net.imglib2.roi.composite.RealTransformUnaryCompositeRealMask;
import net.imglib2.roi.composite.RealTransformUnaryCompositeRealMaskRealInterval;

public class Operators {
    public static final BinaryMaskOperator AND = new BinaryMaskOperator(BoundaryType::and, Bounds.AND, KnownConstant::and){

        @Override
        public <T> Predicate<T> predicate(Predicate<? super T> left, Predicate<? super T> right) {
            return t -> left.test(t) && right.test(t);
        }
    };
    public static final BinaryMaskOperator OR = new BinaryMaskOperator(BoundaryType::or, Bounds.OR, KnownConstant::or){

        @Override
        public <T> Predicate<T> predicate(Predicate<? super T> left, Predicate<? super T> right) {
            return t -> left.test(t) || right.test(t);
        }
    };
    public static final BinaryMaskOperator XOR = new BinaryMaskOperator(BoundaryType::xor, Bounds.XOR, KnownConstant::xor){

        @Override
        public <T> Predicate<T> predicate(Predicate<? super T> left, Predicate<? super T> right) {
            if (left.equals(right)) {
                return t -> false;
            }
            return t -> left.test(t) ^ right.test(t);
        }
    };
    public static final BinaryMaskOperator MINUS = new BinaryMaskOperator(BoundaryType::minus, Bounds.MINUS, KnownConstant::minus){

        @Override
        public <T> Predicate<T> predicate(Predicate<? super T> left, Predicate<? super T> right) {
            if (left.equals(right)) {
                return t -> false;
            }
            return t -> left.test(t) && !right.test(t);
        }
    };
    public static final UnaryMaskOperator NEGATE = new UnaryMaskOperator(BoundaryType::negate, Bounds.NEGATE, KnownConstant::negate){

        @Override
        public <T> Predicate<T> predicate(Predicate<? super T> arg) {
            return t -> !arg.test(t);
        }
    };

    public static int checkDimensions(Object ... args) {
        int[] dimensionalities = Arrays.stream(args).filter(EuclideanSpace.class::isInstance).mapToInt(arg -> ((EuclideanSpace)arg).numDimensions()).distinct().toArray();
        switch (dimensionalities.length) {
            case 0: {
                throw new IllegalArgumentException("couldn't find dimensionality");
            }
            case 1: {
                return dimensionalities[0];
            }
        }
        throw new IllegalArgumentException("incompatible dimensionalities");
    }

    public static class RealTransformMaskOperator
    implements MaskOperator {
        private final RealTransform transformToSource;
        private final int n;
        private final int m;
        private final ThreadLocal<RealPoint> pt;
        private final UnaryOperator<BoundaryType> boundaryTypeOp;
        private final UnaryOperator<KnownConstant> knownConstantOp;

        public RealTransformMaskOperator(RealTransform transformToSource) {
            this.transformToSource = transformToSource;
            this.n = transformToSource.numSourceDimensions();
            this.m = transformToSource.numTargetDimensions();
            this.pt = ThreadLocal.withInitial(() -> new RealPoint(this.m));
            this.boundaryTypeOp = RealTransformMaskOperator.willPreserveBounds(transformToSource) && RealTransformMaskOperator.isContinuous(transformToSource) ? UnaryOperator.identity() : t -> BoundaryType.UNSPECIFIED;
            this.knownConstantOp = UnaryOperator.identity();
        }

        public static final boolean isContinuous(RealTransform transform) {
            return transform instanceof AffineGet;
        }

        public static final boolean willPreserveBounds(RealTransform transform) {
            return transform instanceof AffineGet;
        }

        public RealTransform getTransformToSource() {
            return this.transformToSource;
        }

        public Predicate<RealLocalizable> predicate(Predicate<? super RealLocalizable> arg) {
            return pos -> {
                RealPoint sourcePos = this.pt.get();
                this.transformToSource.apply((RealLocalizable)pos, (RealPositionable)sourcePos);
                return arg.test((RealLocalizable)sourcePos);
            };
        }

        public RealMask applyReal(Predicate<? super RealLocalizable> arg) {
            this.checkDimensions(arg);
            BoundaryType boundaryType = (BoundaryType)((Object)this.boundaryTypeOp.apply(BoundaryType.of(arg)));
            if (arg instanceof RealInterval && RealTransformMaskOperator.willPreserveBounds(this.transformToSource)) {
                return new RealTransformUnaryCompositeRealMaskRealInterval(this, arg, new Bounds.RealTransformRealInterval((RealInterval)arg, (InvertibleRealTransform)this.transformToSource), boundaryType, this.knownConstantOp);
            }
            return new RealTransformUnaryCompositeRealMask(this, arg, this.n, boundaryType, this.knownConstantOp);
        }

        public RealMaskRealInterval applyRealInterval(Predicate<? super RealLocalizable> arg) {
            RealMask mask = this.applyReal(arg);
            if (mask instanceof RealMaskRealInterval) {
                return (RealMaskRealInterval)mask;
            }
            throw new IllegalArgumentException("result is not an interval");
        }

        public boolean equals(Object obj) {
            if (obj instanceof RealTransformMaskOperator) {
                return this.transformToSource.equals(((RealTransformMaskOperator)obj).getTransformToSource());
            }
            return false;
        }

        public int hashCode() {
            return this.transformToSource.hashCode() * 23;
        }

        private void checkDimensions(Object source) {
            if (source instanceof EuclideanSpace) {
                if (((EuclideanSpace)source).numDimensions() != this.m) {
                    throw new IllegalArgumentException("incompatible dimensionalities");
                }
            } else {
                throw new IllegalArgumentException("couldn't find dimensionality");
            }
        }
    }

    public static abstract class UnaryMaskOperator
    implements MaskOperator {
        UnaryOperator<BoundaryType> boundaryTypeOp;
        Bounds.UnaryBoundsOperator boundsOp;
        UnaryOperator<KnownConstant> knownConstantOp;

        public UnaryMaskOperator(UnaryOperator<BoundaryType> boundaryTypeOp, Bounds.UnaryBoundsOperator boundsOp, UnaryOperator<KnownConstant> knownConstantOp) {
            this.boundaryTypeOp = boundaryTypeOp;
            this.boundsOp = boundsOp;
            this.knownConstantOp = knownConstantOp;
        }

        public Mask apply(Predicate<? super Localizable> arg) {
            int n = Operators.checkDimensions(arg);
            BoundaryType boundaryType = (BoundaryType)((Object)this.boundaryTypeOp.apply(BoundaryType.of(arg)));
            Bounds.IntBounds bounds = this.boundsOp.apply(Bounds.IntBounds.of(arg));
            if (bounds.isUnbounded()) {
                return new DefaultUnaryCompositeMask(this, arg, n, boundaryType, this.knownConstantOp);
            }
            return new DefaultUnaryCompositeMaskInterval(this, arg, (Interval)bounds.interval(), boundaryType, this.knownConstantOp);
        }

        public RealMask applyReal(Predicate<? super RealLocalizable> arg) {
            int n = Operators.checkDimensions(arg);
            BoundaryType boundaryType = (BoundaryType)((Object)this.boundaryTypeOp.apply(BoundaryType.of(arg)));
            Bounds.RealBounds bounds = this.boundsOp.apply(Bounds.RealBounds.of(arg));
            if (bounds.isUnbounded()) {
                return new DefaultUnaryCompositeRealMask(this, arg, n, boundaryType, this.knownConstantOp);
            }
            return new DefaultUnaryCompositeRealMaskRealInterval(this, arg, (RealInterval)bounds.interval(), boundaryType, this.knownConstantOp);
        }

        public MaskInterval applyInterval(Predicate<? super Localizable> arg) {
            Mask mask = this.apply(arg);
            if (mask instanceof MaskInterval) {
                return (MaskInterval)mask;
            }
            throw new IllegalArgumentException("result is not an interval");
        }

        public RealMaskRealInterval applyRealInterval(Predicate<? super RealLocalizable> arg) {
            RealMask mask = this.applyReal(arg);
            if (mask instanceof RealMaskRealInterval) {
                return (RealMaskRealInterval)mask;
            }
            throw new IllegalArgumentException("result is not an interval");
        }

        public abstract <T> Predicate<T> predicate(Predicate<? super T> var1);
    }

    public static abstract class BinaryMaskOperator
    implements MaskOperator {
        BinaryOperator<BoundaryType> boundaryTypeOp;
        Bounds.BinaryBoundsOperator boundsOp;
        BinaryOperator<KnownConstant> knownConstantOp;

        public BinaryMaskOperator(BinaryOperator<BoundaryType> boundaryTypeOp, Bounds.BinaryBoundsOperator boundsOp, BinaryOperator<KnownConstant> knownConstantOp) {
            this.boundaryTypeOp = boundaryTypeOp;
            this.boundsOp = boundsOp;
            this.knownConstantOp = knownConstantOp;
        }

        public Mask apply(Predicate<? super Localizable> left, Predicate<? super Localizable> right) {
            int n = Operators.checkDimensions(left, right);
            BoundaryType boundaryType = (BoundaryType)((Object)this.boundaryTypeOp.apply(BoundaryType.of(left), BoundaryType.of(right)));
            Bounds.IntBounds bounds = this.boundsOp.apply(Bounds.IntBounds.of(left), Bounds.IntBounds.of(right));
            if (bounds.isUnbounded()) {
                return new DefaultBinaryCompositeMask(this, left, right, n, boundaryType, this.knownConstantOp);
            }
            return new DefaultBinaryCompositeMaskInterval(this, left, right, (Interval)bounds.interval(), boundaryType, this.knownConstantOp);
        }

        public RealMask applyReal(Predicate<? super RealLocalizable> left, Predicate<? super RealLocalizable> right) {
            int n = Operators.checkDimensions(left, right);
            BoundaryType boundaryType = (BoundaryType)((Object)this.boundaryTypeOp.apply(BoundaryType.of(left), BoundaryType.of(right)));
            Bounds.RealBounds bounds = this.boundsOp.apply(Bounds.RealBounds.of(left), Bounds.RealBounds.of(right));
            if (bounds.isUnbounded()) {
                return new DefaultBinaryCompositeRealMask(this, left, right, n, boundaryType, this.knownConstantOp);
            }
            return new DefaultBinaryCompositeRealMaskRealInterval(this, left, right, (RealInterval)bounds.interval(), boundaryType, this.knownConstantOp);
        }

        public MaskInterval applyInterval(Predicate<? super Localizable> left, Predicate<? super Localizable> right) {
            Mask mask = this.apply(left, right);
            if (mask instanceof MaskInterval) {
                return (MaskInterval)mask;
            }
            throw new IllegalArgumentException("result is not an interval");
        }

        public RealMaskRealInterval applyRealInterval(Predicate<? super RealLocalizable> left, Predicate<? super RealLocalizable> right) {
            RealMask mask = this.applyReal(left, right);
            if (mask instanceof RealMaskRealInterval) {
                return (RealMaskRealInterval)mask;
            }
            throw new IllegalArgumentException("result is not an interval");
        }

        public abstract <T> Predicate<T> predicate(Predicate<? super T> var1, Predicate<? super T> var2);
    }

    public static interface MaskOperator {
    }
}

