/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.NonReadableChannelException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import org.janelia.saalfeldlab.n5.KeyValueAccess;
import org.janelia.saalfeldlab.n5.LockedChannel;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.s3.AmazonS3Utils;

public class AmazonS3KeyValueAccess
implements KeyValueAccess {
    private final AmazonS3 s3;
    private final URI containerURI;
    private final String bucketName;
    private final boolean createBucket;
    private Boolean bucketCheckedAndExists = null;

    @Deprecated
    public AmazonS3KeyValueAccess(AmazonS3 s3, String containerURI, boolean createBucket) throws N5Exception.N5IOException {
        this(s3, N5URI.getAsUri(containerURI), createBucket);
    }

    public AmazonS3KeyValueAccess(AmazonS3 s3, URI containerURI, boolean createBucket) throws N5Exception.N5IOException {
        this(s3, containerURI, createBucket, true);
    }

    protected AmazonS3KeyValueAccess(AmazonS3 s3, URI containerURI, boolean createBucket, boolean requireValidResponse) throws N5Exception.N5IOException {
        if (requireValidResponse) {
            try {
                AmazonS3Utils.requireValidS3ServerResponse(s3);
            }
            catch (Exception e) {
                throw new N5Exception.N5IOException(e);
            }
        }
        this.s3 = s3;
        this.containerURI = containerURI;
        this.bucketName = AmazonS3Utils.getS3Bucket(containerURI);
        this.createBucket = createBucket;
        if (!s3.doesBucketExistV2(this.bucketName)) {
            if (createBucket) {
                Region region;
                try {
                    region = s3.getRegion();
                }
                catch (IllegalStateException e) {
                    region = Region.US_Standard;
                }
                s3.createBucket(new CreateBucketRequest(this.bucketName, region));
            } else {
                throw new N5Exception.N5IOException("Bucket " + this.bucketName + " does not exist, and you told me not to create one.");
            }
        }
    }

    private boolean bucketExists() {
        this.bucketCheckedAndExists = this.bucketCheckedAndExists != null ? this.bucketCheckedAndExists.booleanValue() : this.s3.doesBucketExistV2(this.bucketName);
        return this.bucketCheckedAndExists;
    }

    private void createBucket() {
        Region region;
        if (!this.createBucket) {
            throw new N5Exception("Create Bucket Not Allowed");
        }
        if (this.bucketExists()) {
            return;
        }
        try {
            region = this.s3.getRegion();
        }
        catch (IllegalStateException e) {
            region = Region.US_Standard;
        }
        try {
            this.s3.createBucket(new CreateBucketRequest(this.bucketName, region));
            this.bucketCheckedAndExists = true;
        }
        catch (Exception e) {
            throw new N5Exception("Could not create bucket " + this.bucketName, e);
        }
    }

    private void deleteBucket() {
        if (!this.createBucket) {
            throw new N5Exception("Delete Bucket Not Allowed");
        }
        if (!this.bucketExists()) {
            return;
        }
        try {
            this.s3.deleteBucket(this.bucketName);
            this.bucketCheckedAndExists = false;
        }
        catch (Exception e) {
            throw new N5Exception("Could not delete bucket " + this.bucketName, e);
        }
    }

    @Override
    public String[] components(String path) {
        String key = path;
        try {
            URI uri = N5URI.getAsUri(path);
            String scheme = uri.getScheme();
            if (scheme != null && !scheme.isEmpty()) {
                key = AmazonS3Utils.getS3Key(uri);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return KeyValueAccess.super.components(key);
    }

    @Override
    public String relativize(String path, String base) {
        try {
            URI baseAsUri = this.uri("/" + base);
            URI pathAsUri = this.uri("/" + path);
            URI relativeUri = baseAsUri.relativize(pathAsUri);
            return relativeUri.getPath();
        }
        catch (URISyntaxException e) {
            throw new N5Exception("Cannot relativize path (" + path + ") with base (" + base + ")", e);
        }
    }

    @Override
    public String normalize(String path) {
        return N5URI.normalizeGroupPath(path);
    }

    @Override
    public URI uri(String normalPath) throws URISyntaxException {
        return KeyValueAccess.super.uri(this.compose(this.containerURI, normalPath));
    }

    @Override
    public boolean exists(String normalPath) {
        return this.isFile(normalPath) || this.isDirectory(normalPath);
    }

    private ListObjectsV2Result queryPrefix(String prefix) {
        ListObjectsV2Request listObjectsRequest = new ListObjectsV2Request().withBucketName(this.bucketName).withPrefix(prefix).withMaxKeys(Integer.valueOf(1));
        return this.s3.listObjectsV2(listObjectsRequest);
    }

    private boolean keyExists(String key) {
        try {
            return this.s3.doesObjectExist(this.bucketName, key);
        }
        catch (Throwable e) {
            return false;
        }
    }

    private boolean prefixExists(String prefix) {
        ListObjectsV2Result objectsListing = this.queryPrefix(prefix);
        return objectsListing.getKeyCount() > 0;
    }

    private static String addTrailingSlash(String path) {
        return path.endsWith("/") ? path : path + "/";
    }

    private static String removeLeadingSlash(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    @Override
    public boolean isDirectory(String normalPath) {
        String s3Key = AmazonS3Utils.getS3Key(N5URI.getAsUri(normalPath));
        String key = AmazonS3KeyValueAccess.removeLeadingSlash(AmazonS3KeyValueAccess.addTrailingSlash(s3Key));
        if (this.isRoot(key)) {
            return this.s3.doesBucketExistV2(this.bucketName);
        }
        if (this.prefixExists(key)) {
            return true;
        }
        try {
            return this.s3.getObjectMetadata(this.bucketName, key).getContentLength() == 0L;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isRoot(String key) {
        return this.normalize(key).equals(this.normalize("/"));
    }

    @Override
    public boolean isFile(String normalPath) {
        String key = AmazonS3Utils.getS3Key(normalPath);
        return !key.endsWith("/") && this.keyExists(AmazonS3KeyValueAccess.removeLeadingSlash(key));
    }

    @Override
    public LockedChannel lockForReading(String normalPath) {
        String key = AmazonS3Utils.getS3Key(normalPath);
        return new S3ObjectChannel(AmazonS3KeyValueAccess.removeLeadingSlash(key), true);
    }

    @Override
    public LockedChannel lockForWriting(String normalPath) {
        String key = AmazonS3Utils.getS3Key(normalPath);
        return new S3ObjectChannel(AmazonS3KeyValueAccess.removeLeadingSlash(key), false);
    }

    @Override
    public String[] listDirectories(String normalPath) {
        return this.list(normalPath, true);
    }

    private String[] list(String normalPath, boolean onlyDirectories) {
        String pathKey = AmazonS3Utils.getS3Key(normalPath);
        ArrayList<String> subGroups = new ArrayList<String>();
        String prefix = AmazonS3KeyValueAccess.removeLeadingSlash(AmazonS3KeyValueAccess.addTrailingSlash(pathKey));
        ListObjectsV2Request listObjectsRequest = new ListObjectsV2Request().withBucketName(this.bucketName).withPrefix(prefix).withDelimiter("/");
        ListObjectsV2Result objectsListing = this.s3.listObjectsV2(listObjectsRequest);
        do {
            for (String commonPrefix : objectsListing.getCommonPrefixes()) {
                String relativePath;
                String commonPrefixDecoded = N5URI.getAsUri(commonPrefix).getPath();
                if (onlyDirectories && !commonPrefixDecoded.endsWith("/") || (relativePath = this.normalize(this.relativize(commonPrefixDecoded, prefix))).isEmpty()) continue;
                subGroups.add(relativePath);
            }
            listObjectsRequest.setContinuationToken(objectsListing.getNextContinuationToken());
            if (!objectsListing.isTruncated()) continue;
            objectsListing = this.s3.listObjectsV2(listObjectsRequest);
        } while (objectsListing.isTruncated());
        if (objectsListing.getKeyCount() > 0) {
            return subGroups.toArray(new String[0]);
        }
        try {
            if (this.s3.getObjectMetadata(this.bucketName, prefix).getContentLength() == 0L) {
                return new String[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new N5Exception.N5IOException(normalPath + " is not a valid group");
    }

    @Override
    public String[] list(String normalPath) throws IOException {
        return this.list(normalPath, false);
    }

    @Override
    public void createDirectories(String normalPath) {
        if (!this.bucketExists() && this.createBucket) {
            this.createBucket();
        }
        String path = "";
        for (String component : this.components(AmazonS3KeyValueAccess.removeLeadingSlash(normalPath))) {
            String composed = AmazonS3KeyValueAccess.addTrailingSlash(this.compose(path, component));
            if (composed.equals("/")) continue;
            path = composed;
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(0L);
            this.s3.putObject(this.bucketName, path, (InputStream)new ByteArrayInputStream(new byte[0]), metadata);
        }
    }

    @Override
    public void delete(String normalPath) {
        ListObjectsV2Result objectsListing;
        if (!this.s3.doesBucketExistV2(this.bucketName)) {
            return;
        }
        if (this.isRoot(AmazonS3Utils.getS3Key(normalPath))) {
            ObjectListing objectListing = this.s3.listObjects(this.bucketName);
            while (true) {
                Iterator objIter = objectListing.getObjectSummaries().iterator();
                while (objIter.hasNext()) {
                    this.s3.deleteObject(this.bucketName, ((S3ObjectSummary)objIter.next()).getKey());
                }
                if (!objectListing.isTruncated()) break;
                objectListing = this.s3.listNextBatchOfObjects(objectListing);
            }
            this.deleteBucket();
            return;
        }
        String key = AmazonS3KeyValueAccess.removeLeadingSlash(AmazonS3Utils.getS3Key(normalPath));
        if (!key.endsWith("/")) {
            this.s3.deleteObjects(new DeleteObjectsRequest(this.bucketName).withKeys(new String[]{key}));
        }
        String prefix = AmazonS3KeyValueAccess.addTrailingSlash(key);
        ListObjectsV2Request listObjectsRequest = new ListObjectsV2Request().withBucketName(this.bucketName).withPrefix(prefix);
        do {
            objectsListing = this.s3.listObjectsV2(listObjectsRequest);
            ArrayList<String> objectsToDelete = new ArrayList<String>();
            for (S3ObjectSummary object : objectsListing.getObjectSummaries()) {
                objectsToDelete.add(object.getKey());
            }
            if (!objectsToDelete.isEmpty()) {
                this.s3.deleteObjects(new DeleteObjectsRequest(this.bucketName).withKeys(objectsToDelete.toArray(new String[objectsToDelete.size()])));
            }
            listObjectsRequest.setContinuationToken(objectsListing.getNextContinuationToken());
        } while (objectsListing.isTruncated());
    }

    private class S3ObjectChannel
    implements LockedChannel {
        protected final String path;
        final boolean readOnly;
        private final ArrayList<Closeable> resources = new ArrayList();

        protected S3ObjectChannel(String path, boolean readOnly) {
            this.path = path;
            this.readOnly = readOnly;
        }

        private void checkWritable() {
            if (this.readOnly) {
                throw new NonReadableChannelException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream newInputStream() {
            S3Object object;
            try {
                object = AmazonS3KeyValueAccess.this.s3.getObject(AmazonS3KeyValueAccess.this.bucketName, this.path);
            }
            catch (AmazonServiceException e) {
                if (e.getStatusCode() == 404 || e.getStatusCode() == 403) {
                    throw new N5Exception.N5NoSuchKeyException("No such key", e);
                }
                throw e;
            }
            S3ObjectInputStream in = object.getObjectContent();
            S3ObjectInputStreamDrain s3in = new S3ObjectInputStreamDrain(in);
            ArrayList<Closeable> arrayList = this.resources;
            synchronized (arrayList) {
                this.resources.add(s3in);
            }
            return s3in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Reader newReader() {
            InputStreamReader reader = new InputStreamReader(this.newInputStream(), StandardCharsets.UTF_8);
            ArrayList<Closeable> arrayList = this.resources;
            synchronized (arrayList) {
                this.resources.add(reader);
            }
            return reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OutputStream newOutputStream() {
            this.checkWritable();
            S3OutputStream s3Out = new S3OutputStream();
            ArrayList<Closeable> arrayList = this.resources;
            synchronized (arrayList) {
                this.resources.add(s3Out);
            }
            return s3Out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Writer newWriter() throws IOException {
            this.checkWritable();
            OutputStreamWriter writer = new OutputStreamWriter(this.newOutputStream(), StandardCharsets.UTF_8);
            ArrayList<Closeable> arrayList = this.resources;
            synchronized (arrayList) {
                this.resources.add(writer);
            }
            return writer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            ArrayList<Closeable> arrayList = this.resources;
            synchronized (arrayList) {
                for (Closeable resource : this.resources) {
                    resource.close();
                }
                this.resources.clear();
            }
        }

        final class S3OutputStream
        extends OutputStream {
            private final ByteArrayOutputStream buf = new ByteArrayOutputStream();
            private boolean closed = false;

            S3OutputStream() {
            }

            @Override
            public void write(byte[] b, int off, int len) {
                this.buf.write(b, off, len);
            }

            @Override
            public void write(int b) {
                this.buf.write(b);
            }

            @Override
            public synchronized void close() throws IOException {
                if (!this.closed) {
                    this.closed = true;
                    byte[] bytes = this.buf.toByteArray();
                    ObjectMetadata objectMetadata = new ObjectMetadata();
                    objectMetadata.setContentLength((long)bytes.length);
                    try (ByteArrayInputStream data = new ByteArrayInputStream(bytes);){
                        AmazonS3KeyValueAccess.this.s3.putObject(AmazonS3KeyValueAccess.this.bucketName, S3ObjectChannel.this.path, (InputStream)data, objectMetadata);
                    }
                    this.buf.close();
                }
            }
        }
    }

    private static class S3ObjectInputStreamDrain
    extends InputStream {
        private final S3ObjectInputStream in;
        private boolean closed;

        public S3ObjectInputStreamDrain(S3ObjectInputStream in) {
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        @Override
        public boolean markSupported() {
            return this.in.markSupported();
        }

        @Override
        public void mark(int readlimit) {
            this.in.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.in.reset();
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                do {
                    this.in.skip((long)this.in.available());
                } while (this.read() != -1);
                this.in.close();
                this.closed = true;
            }
        }
    }
}

