/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import net.imglib2.type.label.LongMappedAccess;
import net.imglib2.type.label.MappedAccessData;

public class LongMappedAccessData
implements MappedAccessData<LongMappedAccess> {
    protected long[] data;
    private long size;
    public static final MappedAccessData.Factory<LongMappedAccessData, LongMappedAccess> factory = new MappedAccessData.Factory<LongMappedAccessData, LongMappedAccess>(){

        @Override
        public LongMappedAccessData createStorage(long size) {
            return new LongMappedAccessData(size);
        }

        @Override
        public LongMappedAccess createAccess() {
            return new LongMappedAccess(null, 0L);
        }
    };

    public long[] getData() {
        return this.data;
    }

    @Override
    public LongMappedAccess createAccess() {
        return new LongMappedAccess(this, 0L);
    }

    @Override
    public void updateAccess(LongMappedAccess access, long baseOffset) {
        access.setDataArray(this);
        access.setBaseOffset(baseOffset);
    }

    private long longSizeFromByteSize(long byteSize) {
        return (byteSize + 8L - 1L) / 8L;
    }

    private LongMappedAccessData(long size) {
        long longSize = this.longSizeFromByteSize(size);
        if (longSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("trying to create a " + this.getClass().getName() + " with more than " + 0x3FFFFFFF8L + " bytes.");
        }
        this.size = size;
        this.data = new long[(int)longSize];
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void resize(long size) {
        long longSize = this.longSizeFromByteSize(size);
        if (longSize == this.longSizeFromByteSize(this.size)) {
            return;
        }
        if (longSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("trying to resize a " + this.getClass().getName() + " with more than " + 0x3FFFFFFF8L + " bytes.");
        }
        long[] datacopy = new long[(int)longSize];
        int copyLength = Math.min(this.data.length, datacopy.length);
        System.arraycopy(this.data, 0, datacopy, 0, copyLength);
        this.data = datacopy;
        this.size = size;
    }
}

