/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.convolution.kernel;

import net.imglib2.RandomAccess;
import net.imglib2.algorithm.convolution.kernel.Kernel1D;
import net.imglib2.type.numeric.RealType;

public final class FloatConvolverRealType
implements Runnable {
    private final float[] kernel;
    private final RandomAccess<? extends RealType<?>> in;
    private final RandomAccess<? extends RealType<?>> out;
    private final int d;
    private final int k1k;
    private final int k1k1;
    private final long linelen;
    private final float[] buffer;

    public FloatConvolverRealType(Kernel1D kernel, RandomAccess<? extends RealType<?>> in, RandomAccess<? extends RealType<?>> out, int d, long lineLength) {
        this.in = in;
        this.out = out;
        this.d = d;
        this.kernel = this.doubleToFloat(kernel.fullKernel());
        this.k1k = this.kernel.length;
        this.k1k1 = this.k1k - 1;
        this.linelen = lineLength;
        this.buffer = new float[this.k1k + 1];
    }

    private float[] doubleToFloat(double[] in) {
        float[] out = new float[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = (float)in[i];
        }
        return out;
    }

    private void prefill() {
        float w = ((RealType)this.in.get()).getRealFloat();
        this.process(w);
        this.in.fwd(this.d);
    }

    private void next() {
        float w = ((RealType)this.in.get()).getRealFloat();
        ((RealType)this.out.get()).setReal(w * this.kernel[0] + this.buffer[1]);
        this.process(w);
        this.in.fwd(this.d);
        this.out.fwd(this.d);
    }

    private void process(float w) {
        for (int i = 1; i < this.k1k; ++i) {
            this.buffer[i] = w * this.kernel[i] + this.buffer[i + 1];
        }
    }

    @Override
    public void run() {
        for (int i = 0; i < this.k1k1; ++i) {
            this.prefill();
        }
        for (long i = 0L; i < this.linelen; ++i) {
            this.next();
        }
    }
}

