/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.interpolation.randomaccess;

import net.imglib2.RandomAccessible;
import net.imglib2.RealInterval;
import net.imglib2.algorithm.interpolation.randomaccess.BSplineInterpolator;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.type.numeric.RealType;

public class BSplineInterpolatorFactory<T extends RealType<T>>
implements InterpolatorFactory<T, RandomAccessible<T>> {
    final boolean clipping;
    final int radius;

    public BSplineInterpolatorFactory(boolean clipping, int radius) {
        this.clipping = clipping;
        this.radius = radius;
    }

    public BSplineInterpolatorFactory(boolean clipping) {
        this(clipping, 4);
    }

    public BSplineInterpolatorFactory(int order) {
        this(true, 4);
    }

    public BSplineInterpolatorFactory() {
        this(true);
    }

    @Override
    public BSplineInterpolator<T> create(RandomAccessible<T> randomAccessible) {
        return new BSplineInterpolator<T>(randomAccessible, this.radius, this.clipping);
    }

    @Override
    public BSplineInterpolator<T> create(RandomAccessible<T> randomAccessible, RealInterval interval) {
        return this.create(randomAccessible);
    }
}

