/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.util.unionfind;

import java.util.Arrays;
import java.util.function.IntBinaryOperator;
import net.imglib2.algorithm.util.unionfind.UnionFind;

public class IntArrayUnionFind
implements UnionFind {
    private final int[] parents;
    private int nSets;
    private final IntBinaryOperator comparator;

    public IntArrayUnionFind(int size) {
        this(size, Integer::compare);
    }

    public IntArrayUnionFind(int size, IntBinaryOperator comparator) {
        this(IntArrayUnionFind.intRange(new int[size]), size, comparator);
    }

    private IntArrayUnionFind(int[] parents, int nSets, IntBinaryOperator comparator) {
        this.parents = parents;
        this.nSets = nSets;
        this.comparator = comparator;
    }

    public int findRoot(int id) {
        int startIndex1 = id;
        int startIndex2 = id;
        int tmp = id;
        while (startIndex1 != this.parents[startIndex1]) {
            startIndex1 = this.parents[startIndex1];
        }
        while (startIndex2 != startIndex1) {
            tmp = this.parents[startIndex2];
            this.parents[startIndex2] = startIndex1;
            startIndex2 = tmp;
        }
        return startIndex1;
    }

    public int join(int id1, int id2) {
        if (id1 == id2) {
            return id1;
        }
        --this.nSets;
        if (this.comparator.applyAsInt(id1, id2) < 0) {
            this.parents[id2] = id1;
            return id1;
        }
        this.parents[id1] = id2;
        return id2;
    }

    @Override
    public long findRoot(long id) {
        return this.findRoot((int)id);
    }

    @Override
    public long join(long id1, long id2) {
        return this.join((int)id1, (int)id2);
    }

    @Override
    public long size() {
        return this.intSize();
    }

    @Override
    public long setCount() {
        return this.intSetCount();
    }

    public int intSize() {
        return this.parents.length;
    }

    public int intSetCount() {
        return this.nSets;
    }

    public IntArrayUnionFind clone() {
        return new IntArrayUnionFind((int[])this.parents.clone(), this.nSets, this.comparator);
    }

    private static int[] intRange(int[] data) {
        return IntArrayUnionFind.intRange(data, 0);
    }

    private static int[] intRange(int[] data, int offset) {
        Arrays.setAll(data, d -> d + offset);
        return data;
    }
}

