/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.scijava.Context;
import org.scijava.module.ModuleException;
import org.scijava.plugin.PluginService;
import org.scijava.script.ScriptLanguage;
import org.scijava.ui.swing.script.AutoImporter;

public class DefaultAutoImporters {
    private static Collection<AutoImporter> importers;

    static Reader prefixAutoImports(Context context, ScriptLanguage language, Reader reader, Writer errors) throws ModuleException {
        Object generator = DefaultAutoImporters.getImportGenerator(context, language);
        if (generator == null) {
            try {
                errors.write("[WARNING] Auto-imports not available for language '" + (language == null ? "(null)" : language.getLanguageName()) + "'.\n");
            }
            catch (IOException e) {
                throw new ModuleException((Throwable)e);
            }
            return reader;
        }
        try {
            errors.write("[WARNING] Auto-imports are active, but deprecated.\n");
        }
        catch (IOException e) {
            throw new ModuleException((Throwable)e);
        }
        String statements = generator.toString();
        try {
            PushbackReader result = new PushbackReader(reader, statements.length());
            result.unread(statements.toCharArray());
            return result;
        }
        catch (IOException e) {
            throw new ModuleException((Throwable)e);
        }
    }

    public static Object getImportGenerator(Context context, ScriptLanguage language) {
        String name;
        if (importers == null) {
            PluginService pluginService = (PluginService)context.getService(PluginService.class);
            importers = pluginService.createInstancesOfType(AutoImporter.class);
        }
        String string = name = language == null ? null : language.getLanguageName();
        if ("Javascript".equalsIgnoreCase(name) || "ECMAScript".equals(name)) {
            return new DefaultImportStatements("importClass(Packages.", ");\n", new String[0]);
        }
        if ("Beanshell".equalsIgnoreCase(name)) {
            return new DefaultImportStatements("import ", ";\n", new String[0]);
        }
        if ("Ruby".equalsIgnoreCase(name)) {
            return new DefaultImportStatements("java_import '", "'\n", new String[0]);
        }
        if ("Python".equalsIgnoreCase(name)) {
            return new DefaultImportStatements(null, null, new String[0]){

                @Override
                public void generate(StringBuilder builder, String packageName, List<String> classNames) {
                    if (classNames.size() == 0) {
                        return;
                    }
                    builder.append("from ").append(packageName).append(" import ");
                    boolean first = true;
                    for (String className : classNames) {
                        if (first) {
                            first = false;
                        } else {
                            builder.append(", ");
                        }
                        builder.append(className);
                    }
                    builder.append("\n");
                }
            };
        }
        return null;
    }

    private static class DefaultImportStatements
    implements ImportStatementGenerator {
        private final String prefix;
        private final String suffix;
        private final Set<String> exclude;

        DefaultImportStatements(String prefix, String suffix, String ... classNamesToExclude) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.exclude = new HashSet<String>(Arrays.asList(classNamesToExclude));
        }

        @Override
        public void generate(StringBuilder builder, String packageName, List<String> classNames) {
            if ("java.lang".equals(packageName)) {
                return;
            }
            for (String className : classNames) {
                if (this.exclude.contains(className)) continue;
                builder.append(this.prefix).append(packageName).append('.').append(className).append(this.suffix);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (AutoImporter importer : importers) {
                for (Map.Entry<String, List<String>> entry : importer.getDefaultImports().entrySet()) {
                    String packageName = entry.getKey();
                    List<String> classNames = entry.getValue();
                    this.generate(builder, packageName, classNames);
                }
            }
            return builder.toString();
        }
    }

    private static interface ImportStatementGenerator {
        public void generate(StringBuilder var1, String var2, List<String> var3);
    }
}

