/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.scijava.log.Logger;
import org.scijava.ui.swing.script.FileDrop;

public class FileSystemTree
extends JTree {
    public static final Icon ICON_ERROR = FileSystemTree.makeErrorIcon();
    final Logger log;
    private ArrayList<LeafListener> leaf_listeners = new ArrayList();
    private final DirectoryWatcher dir_watcher = new DirectoryWatcher();
    private final HashSet<String> ignored_extensions = new HashSet();
    private Pattern re_ignored_extensions = Pattern.compile("^.*$", 2);
    private FileFilter file_filter = f -> true;

    private static String withSlash(String path) {
        return '/' == (path = path.replace('\\', '/')).charAt(path.length() - 1) ? path : path + "/";
    }

    private static final Icon makeErrorIcon() {
        int[] pixels = new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFEFE, 0xFFEBEB, 0xFFC1C1, 0xFF9999, 0xFF8181, 0xFF8181, 0xFF9999, 0xFFC1C1, 0xFFEBEB, 0xFFFEFE, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFEBEB, 0xFF9595, 0xFF4040, 0xFF3A3A, 0xFF5959, 0xFF7878, 0xFF7878, 0xFF5959, 0xFF3A3A, 0xFF4040, 0xFF9595, 0xFFEBEB, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFEFE, 0xFFCDCD, 0xFF4C4C, 0xFF4141, 0xFFA7A7, 0xFFE6E6, 0xFFF6F6, 0xFFF3F3, 0xFFF3F3, 0xFFF3F3, 0xFFE6E6, 0xFFA7A7, 0xFF4141, 0xFF4C4C, 0xFFCDCD, 0xFFFEFE, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFCDCD, 0xFF3838, 0xFF6C6C, 0xFFE4E4, 0xFFFFFF, 0xFFFFFF, 0xFFB1B1, 0xFF3F3F, 0xFF3E3E, 0xFF8C8C, 0xFFFEFE, 0xFFFFFF, 0xFFE4E4, 0xFF6C6C, 0xFF3838, 0xFFCDCD, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFEBEB, 0xFF4C4C, 0xFF6C6C, 0xFFF2F2, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFF9898, 0xFF0101, 0xFF0000, 0xFF6767, 0xFFFEFE, 0xFFFFFF, 0xFFFFFF, 0xFFF2F2, 0xFF6C6C, 0xFF4C4C, 0xFFEBEB, 0xFFFFFF, 0xFFFEFE, 0xFF9595, 0xFF4141, 0xFFE4E4, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFF9898, 0xFF0101, 0xFF0000, 0xFF6767, 0xFFFEFE, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFE4E4, 0xFF4141, 0xFF9595, 0xFFFEFE, 0xFFEBEB, 0xFF4040, 0xFFA7A7, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFF9898, 0xFF0101, 0xFF0000, 0xFF6767, 0xFFFEFE, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFA7A7, 0xFF4040, 0xFFEBEB, 0xFFC1C1, 0xFF3A3A, 0xFFE6E6, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFF9898, 0xFF0101, 0xFF0000, 0xFF6767, 0xFFFEFE, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFE6E6, 0xFF3A3A, 0xFFC1C1, 0xFF9999, 0xFF5959, 0xFFFAFA, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFF9898, 0xFF0101, 0xFF0000, 0xFF6767, 0xFFFEFE, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFAFA, 0xFF5959, 0xFF9999, 0xFF8181, 0xFF7878, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFF9898, 0xFF0101, 0xFF0000, 0xFF6767, 0xFFFEFE, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFF7878, 0xFF8181, 0xFF8181, 0xFF7878, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFF9898, 0xFF0101, 0xFF0000, 0xFF6767, 0xFFFEFE, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFF7878, 0xFF8181, 0xFF9999, 0xFF5959, 0xFFFAFA, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFF9898, 0xFF0101, 0xFF0000, 0xFF6767, 0xFFFEFE, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFAFA, 0xFF5959, 0xFF9999, 0xFFC1C1, 0xFF3A3A, 0xFFE6E6, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFF9C9C, 0xFF0D0D, 0xFF0B0B, 0xFF6E6E, 0xFFFEFE, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFE6E6, 0xFF3A3A, 0xFFC1C1, 0xFFEBEB, 0xFF4040, 0xFFA7A7, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFE6E6, 0xFFBFBF, 0xFFBEBE, 0xFFDADA, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFA7A7, 0xFF4040, 0xFFEBEB, 0xFFFEFE, 0xFF9595, 0xFF4141, 0xFFE4E4, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFF0F0, 0xFF8484, 0xFF6969, 0xFFD8D8, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFE4E4, 0xFF4141, 0xFF9595, 0xFFFEFE, 0xFFFFFF, 0xFFEBEB, 0xFF4C4C, 0xFF6C6C, 0xFFF2F2, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFBCBC, 0xFF0C0C, 0xFF0101, 0xFF7B7B, 0xFFFEFE, 0xFFFFFF, 0xFFFFFF, 0xFFF2F2, 0xFF6C6C, 0xFF4C4C, 0xFFEBEB, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFCDCD, 0xFF3838, 0xFF6C6C, 0xFFE4E4, 0xFFFFFF, 0xFFFFFF, 0xFFD4D4, 0xFF2E2E, 0xFF1818, 0xFFA3A3, 0xFFFFFF, 0xFFFFFF, 0xFFE4E4, 0xFF6C6C, 0xFF3838, 0xFFCDCD, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFEFE, 0xFFCDCD, 0xFF4C4C, 0xFF4141, 0xFFA7A7, 0xFFE6E6, 0xFFF8F8, 0xFFDBDB, 0xFFCFCF, 0xFFF3F3, 0xFFE6E6, 0xFFA7A7, 0xFF4141, 0xFF4C4C, 0xFFCDCD, 0xFFFEFE, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFEBEB, 0xFF9595, 0xFF4040, 0xFF3A3A, 0xFF5959, 0xFF7878, 0xFF7878, 0xFF5959, 0xFF3A3A, 0xFF4040, 0xFF9595, 0xFFEBEB, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFEFE, 0xFFEBEB, 0xFFC1C1, 0xFF9999, 0xFF8181, 0xFF8181, 0xFF9999, 0xFFC1C1, 0xFFEBEB, 0xFFFEFE, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF};
        BufferedImage image = new BufferedImage(20, 20, 2);
        image.setRGB(0, 0, 20, 20, pixels, 0, 20);
        return new ImageIcon(image);
    }

    public FileSystemTree(Logger log) {
        this.log = log;
        this.setModel(new DefaultTreeModel(new Node("#root#")));
        this.setRootVisible(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setAutoscrolls(true);
        this.setScrollsOnExpand(true);
        this.setExpandsSelectedPaths(true);
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                Node node = (Node)event.getPath().getLastPathComponent();
                node.populateChildren(FileSystemTree.this.getModel(), FileSystemTree.this.file_filter);
                FileSystemTree.this.dir_watcher.register(node);
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                Node node = (Node)event.getPath().getLastPathComponent();
                node.removeAllChildren(FileSystemTree.this.getModel());
                FileSystemTree.this.dir_watcher.unregister(node);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                TreePath path = FileSystemTree.this.getPathForLocation(me.getX(), me.getY());
                if (null == path) {
                    return;
                }
                Node node = (Node)path.getLastPathComponent();
                if (2 == me.getClickCount() && node.isLeaf() && !node.isDirectory()) {
                    for (LeafListener l : FileSystemTree.this.leaf_listeners) {
                        l.leafDoubleClicked(new File(node.path));
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if (127 == ke.getKeyCode()) {
                    FileSystemTree.this.removeSelectionPaths(FileSystemTree.this.getSelectionPaths());
                }
            }
        });
        this.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                Node node = (Node)value;
                this.setText(new File(node.path).getName());
                if (node.isDirectory()) {
                    this.setToolTipText(node.path);
                    if (null != node.icon) {
                        this.setIcon(node.icon);
                    } else if (expanded) {
                        this.setIcon(this.openIcon);
                    } else {
                        this.setIcon(this.closedIcon);
                    }
                } else {
                    this.setIcon(this.leafIcon);
                }
                return this;
            }
        });
        this.setVisible(true);
    }

    public boolean ignoreExtension(String extension) {
        if (this.ignored_extensions.add(extension)) {
            this.updateIgnoreExtensionPattern();
            return true;
        }
        return false;
    }

    public boolean showExtension(String extension) {
        if (this.ignored_extensions.remove(extension)) {
            this.updateIgnoreExtensionPattern();
            return true;
        }
        return false;
    }

    private void updateIgnoreExtensionPattern() {
        if (this.ignored_extensions.isEmpty()) {
            this.re_ignored_extensions = Pattern.compile("^.*$", 2);
        } else {
            StringBuilder s = new StringBuilder("^.*\\.(");
            s.append(String.join((CharSequence)"|", this.ignored_extensions.toArray(new String[this.ignored_extensions.size()])));
            s.append(")$");
            this.re_ignored_extensions = Pattern.compile(s.toString(), 2);
        }
    }

    public void setFileFilter(FileFilter file_filter) {
        this.file_filter = file_filter;
        this.updateRecursively(file_filter);
    }

    private void updateRecursively(FileFilter file_filter) {
        Node node;
        ArrayList<Node> stack = new ArrayList<Node>();
        Node root = (Node)this.getModel().getRoot();
        for (int i = root.getChildCount() - 1; i > -1; --i) {
            stack.add(root.getChildAt(i));
        }
        ArrayList<Node> stack2 = new ArrayList<Node>(stack);
        HashSet<String> expanded = new HashSet<String>();
        while (!stack.isEmpty()) {
            node = (Node)stack.remove(0);
            if (!this.isExpanded(new TreePath(node.getPath()))) continue;
            expanded.add(node.path);
            for (int i = node.getChildCount() - 1; i > -1; --i) {
                Node child = node.getChildAt(i);
                if (!child.isDirectory()) continue;
                stack.add(child);
            }
        }
        while (!stack2.isEmpty()) {
            node = (Node)stack2.remove(0);
            if (!expanded.contains(node.path)) continue;
            node.removeAllChildren(this.getModel());
            node.populateChildren(this.getModel(), file_filter);
            int count = node.getChildCount();
            if (count > 0) {
                this.expandPath(new TreePath(node.getChildAt(0).getPath()));
            }
            for (int i = 0; i < count; ++i) {
                Node child = node.getChildAt(i);
                if (!expanded.contains(child.path)) continue;
                stack2.add(child);
            }
        }
    }

    public synchronized void addLeafListener(LeafListener l) {
        this.leaf_listeners.add(l);
    }

    public synchronized void removeLeafListener(LeafListener l) {
        this.leaf_listeners.remove(l);
    }

    public synchronized ArrayList<LeafListener> getLeafListeners() {
        return new ArrayList<LeafListener>(this.leaf_listeners);
    }

    public void addRootDirectory(String dir, boolean checkIfChild) {
        File file = new File(dir);
        if (!file.isDirectory()) {
            return;
        }
        String dirPath = FileSystemTree.withSlash(file.getAbsolutePath());
        Node root = (Node)this.getModel().getRoot();
        if (checkIfChild) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                Node node = root.getChildAt(i);
                if (!dirPath.startsWith(node.path)) continue;
                TreePath[] p = new TreePath[1];
                node.expandTo(dirPath, p);
                if (null == p[0]) continue;
                this.expandPath(p[0]);
                this.setSelectionPath(p[0]);
                this.scrollPathToVisible(p[0]);
                return;
            }
        }
        this.getModel().insertNodeInto(new Node(dirPath), root, root.getChildCount());
        this.getModel().nodesWereInserted(root, new int[]{root.getChildCount() - 1});
    }

    @Override
    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    public void updateUILater() {
        SwingUtilities.invokeLater(() -> this.updateUI());
    }

    public String getTopLevelFoldersString() {
        Node root = (Node)this.getModel().getRoot();
        if (0 == root.getChildCount()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(root.getChildAt(0).path);
        int l = root.getChildCount();
        for (int i = 1; i < l; ++i) {
            sb.append(':').append(root.getChildAt(i).path);
        }
        return sb.toString();
    }

    public void addTopLevelFoldersFrom(String folders) {
        for (String path : folders.split(":")) {
            File file = new File(path);
            if (!file.exists() || !file.isDirectory()) continue;
            this.addRootDirectory(file.getAbsolutePath(), false);
        }
    }

    public void destroy() {
        this.dir_watcher.interrupt();
        FileDrop.remove(this);
    }

    private class DirectoryWatcher
    extends Thread {
        private WatchService watcher;
        private final HashMap<WatchKey, Path> keys = new HashMap();
        private final HashMap<Path, Node> map = new HashMap();

        DirectoryWatcher() {
            this.setDaemon(true);
            try {
                this.watcher = FileSystems.getDefault().newWatchService();
                this.start();
            }
            catch (IOException e) {
                FileSystemTree.this.log.error((Object)"Failed to start filesystem watching.", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void register(Node node) {
            if (null == this.watcher) {
                FileSystemTree.this.log.error((Object)"Filesystem watching is not running.");
                return;
            }
            HashMap<WatchKey, Path> hashMap = this.keys;
            synchronized (hashMap) {
                try {
                    Path path = new File(node.path).toPath();
                    WatchKey key = path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                    this.keys.put(key, path);
                    this.map.put(path, node);
                }
                catch (IOException e) {
                    FileSystemTree.this.log.error((Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unregister(Node node) {
            HashMap<WatchKey, Path> hashMap = this.keys;
            synchronized (hashMap) {
                Iterator<Map.Entry<Path, Node>> it = this.map.entrySet().iterator();
                Path path = null;
                while (it.hasNext()) {
                    Map.Entry<Path, Node> e = it.next();
                    if (e.getValue() != node) continue;
                    path = e.getKey();
                    it.remove();
                    break;
                }
                if (null == path) {
                    return;
                }
                Iterator<Path> itp = this.keys.values().iterator();
                while (itp.hasNext()) {
                    if (!itp.next().equals(path)) continue;
                    itp.remove();
                    return;
                }
            }
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                Path path;
                WatchKey key;
                try {
                    key = this.watcher.take();
                }
                catch (InterruptedException x) {
                    return;
                }
                Path dir = this.keys.get(key);
                if (null == dir) {
                    FileSystemTree.this.log.error((Object)("Unrecognized WatchKey: " + key));
                    continue;
                }
                HashSet<Node> nodes = new HashSet<Node>();
                for (WatchEvent<?> event : key.pollEvents()) {
                    Path child;
                    Node node;
                    WatchEvent.Kind<?> kind = event.kind();
                    if (StandardWatchEventKinds.OVERFLOW == kind || StandardWatchEventKinds.ENTRY_MODIFY == kind || null == (node = this.map.get((child = dir.resolve((Path)event.context())).getParent()))) continue;
                    nodes.add(node);
                }
                SwingUtilities.invokeLater(() -> {
                    for (Node node : nodes) {
                        node.updateChildrenList(FileSystemTree.this.getModel(), FileSystemTree.this.file_filter);
                        FileSystemTree.this.expandPath(new TreePath(node.getPath()));
                    }
                });
                boolean valid = key.reset();
                if (valid || null == (path = this.keys.remove(key))) continue;
                this.map.remove(path);
            }
            return;
        }
    }

    public static interface LeafListener {
        public void leafDoubleClicked(File var1);
    }

    public class Node
    extends DefaultMutableTreeNode {
        private final String path;
        private Icon icon = null;

        public Node(String path) {
            this.path = FileSystemTree.withSlash(path);
        }

        public boolean isDirectory() {
            return new File(this.path).isDirectory();
        }

        public File[] updatedChildrenFiles(boolean sort, final FileFilter file_filter) {
            File file = new File(this.path);
            if (!file.isDirectory()) {
                return new File[0];
            }
            Object[] files = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return !f.isHidden() && !f.getName().endsWith("~") && !FileSystemTree.this.re_ignored_extensions.matcher(f.getName()).matches() && (f.isDirectory() || file_filter.accept(f));
                }
            });
            if (sort) {
                Arrays.sort(files);
            }
            return files;
        }

        public synchronized void populateChildren(DefaultTreeModel model, FileFilter file_filter) {
            try {
                if (this.isLeaf()) {
                    return;
                }
                int index = 0;
                for (File file : this.updatedChildrenFiles(true, file_filter)) {
                    model.insertNodeInto(new Node(file.getAbsolutePath()), this, index++);
                }
                this.icon = null;
            }
            catch (Throwable t) {
                this.icon = ICON_ERROR;
                FileSystemTree.this.log.error((Object)("Failed to populate folder " + this.path), t);
            }
        }

        public void expandTo(String path, TreePath[] full) {
            block3: {
                Node node;
                if (!path.startsWith(this.path)) break block3;
                LinkedList<Node> stack = new LinkedList<Node>();
                stack.add(this);
                block0: do {
                    node = (Node)stack.removeFirst();
                    if (!path.startsWith(node.path)) continue;
                    int count = node.getChildCount();
                    for (int i = 0; i < count; ++i) {
                        Node child = node.getChildAt(i);
                        if (!path.startsWith(child.path)) continue;
                        stack.addLast(child);
                        continue block0;
                    }
                } while (!stack.isEmpty());
                if (path.equals(node.path)) {
                    full[0] = new TreePath(node.getPath());
                }
            }
        }

        @Override
        public String toString() {
            return this.path;
        }

        @Override
        public synchronized int getChildCount() {
            return super.getChildCount();
        }

        @Override
        public synchronized Node getChildAt(int index) {
            if (0 == this.getChildCount()) {
                return null;
            }
            try {
                return (Node)super.getChildAt(index);
            }
            catch (ArrayIndexOutOfBoundsException ae) {
                FileSystemTree.this.log.error((Object)("FileSystemTree: no child at index " + index + " for file at " + this.path), (Throwable)ae);
                return null;
            }
        }

        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public Object getUserObject() {
            return this.path;
        }

        @Override
        public boolean isLeaf() {
            return !this.isRoot() && !this.isDirectory();
        }

        public synchronized void removeAllChildren(DefaultTreeModel model) {
            for (int i = super.getChildCount() - 1; i > -1; --i) {
                model.removeNodeFromParent((Node)super.getChildAt(i));
            }
        }

        public synchronized void updateChildrenList(DefaultTreeModel model, FileFilter file_filter) {
            this.removeAllChildren(model);
            this.populateChildren(model, file_filter);
        }
    }
}

