/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.ScaleGet;

public abstract class AbstractScale
implements ScaleGet {
    protected final double[] s;
    protected final RealPoint[] ds;

    protected AbstractScale(double[] s, RealPoint[] ds) {
        this.s = s;
        this.ds = ds;
    }

    public AbstractScale(double ... s) {
        this.s = (double[])s.clone();
        this.ds = new RealPoint[s.length];
    }

    public abstract void set(double ... var1);

    @Override
    public void applyInverse(double[] source, double[] target) {
        assert (source.length >= this.s.length && target.length >= this.s.length) : "Input dimensions too small.";
        for (int d = 0; d < this.s.length; ++d) {
            source[d] = target[d] / this.s[d];
        }
    }

    @Override
    public void applyInverse(float[] source, float[] target) {
        assert (source.length >= this.s.length && target.length >= this.s.length) : "Input dimensions too small.";
        for (int d = 0; d < this.s.length; ++d) {
            source[d] = (float)((double)target[d] / this.s[d]);
        }
    }

    @Override
    public void applyInverse(RealPositionable source, RealLocalizable target) {
        assert (source.numDimensions() >= this.s.length && target.numDimensions() >= this.s.length) : "Input dimensions too small.";
        for (int d = 0; d < this.s.length; ++d) {
            source.setPosition(target.getDoublePosition(d) / this.s[d], d);
        }
    }

    @Override
    public abstract AbstractScale inverse();

    public int numDimensions() {
        return this.s.length;
    }

    @Override
    public int numSourceDimensions() {
        return this.s.length;
    }

    @Override
    public int numTargetDimensions() {
        return this.s.length;
    }

    @Override
    public void apply(double[] source, double[] target) {
        assert (source.length >= this.s.length && target.length >= this.s.length) : "Input dimensions too small.";
        for (int d = 0; d < this.s.length; ++d) {
            target[d] = source[d] * this.s[d];
        }
    }

    @Override
    public void apply(float[] source, float[] target) {
        assert (source.length >= this.s.length && target.length >= this.s.length) : "Input dimensions too small.";
        for (int d = 0; d < this.s.length; ++d) {
            target[d] = (float)((double)source[d] * this.s[d]);
        }
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        assert (source.numDimensions() >= this.s.length && target.numDimensions() >= this.s.length) : "Input dimensions too small.";
        for (int d = 0; d < this.s.length; ++d) {
            target.setPosition(source.getDoublePosition(d) * this.s[d], d);
        }
    }

    @Override
    public double get(int row, int column) {
        assert (row >= 0 && row < this.numDimensions()) : "Dimension index out of bounds.";
        return row == column ? this.s[row] : 0.0;
    }

    @Override
    public double[] getRowPackedCopy() {
        int step = this.s.length + 2;
        double[] matrix = new double[this.s.length * this.s.length + this.s.length];
        for (int d = 0; d < this.s.length; ++d) {
            matrix[d * step] = this.s[d];
        }
        return matrix;
    }

    @Override
    public RealLocalizable d(int d) {
        assert (d >= 0 && d < this.numDimensions()) : "Dimension index out of bounds.";
        return this.ds[d];
    }

    @Override
    public abstract AbstractScale copy();

    @Override
    public double getScale(int d) {
        return this.s[d];
    }

    @Override
    public double[] getScaleCopy() {
        return (double[])this.s.clone();
    }

    @Override
    public double getTranslation(int d) {
        return 0.0;
    }

    @Override
    public double[] getTranslationCopy() {
        return new double[this.s.length];
    }
}

