/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import net.imagej.updater.PromptUserToUpdate;
import net.imagej.updater.UpToDate;
import org.scijava.command.Command;
import org.scijava.command.CommandService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UIService;

@Plugin(type=Command.class, label="Up-to-date check")
public class CheckForUpdates
implements Command {
    @Parameter
    private CommandService commandService;
    @Parameter(required=false)
    private UIService uiService;
    @Parameter(required=false)
    private LogService log;

    public void run() {
        block11: {
            try {
                UpToDate.Result result = UpToDate.check();
                switch (result) {
                    case UP_TO_DATE: 
                    case OFFLINE: 
                    case REMIND_LATER: 
                    case CHECK_TURNED_OFF: 
                    case UPDATES_MANAGED_DIFFERENTLY: 
                    case DEVELOPER: {
                        return;
                    }
                    case UPDATEABLE: {
                        this.commandService.run(PromptUserToUpdate.class, true, new Object[0]);
                        break;
                    }
                    case PROXY_NEEDS_AUTHENTICATION: {
                        throw new RuntimeException("TODO: authenticate proxy with the configured user/pass pair");
                    }
                    case PROTECTED_LOCATION: {
                        this.fail("Your ImageJ installation cannot be updated because it is in a protected location (e.g., \"C:\\Program Files\").\nPlease move your installation to a directory with write permission.");
                        break;
                    }
                    case READ_ONLY: {
                        this.fail("Your ImageJ installation cannot be updated because it is read-only.");
                        break;
                    }
                    case GPR_ACTIVATED: {
                        String gprURL = "https://weblog.rogueamoeba.com/2016/06/29/sierra-and-gatekeeper-path-randomization/";
                        this.fail("<html>Your ImageJ installation is affected by <a href=\"https://weblog.rogueamoeba.com/2016/06/29/sierra-and-gatekeeper-path-randomization/\">Gatekeeper Path Randomization</a>. Please try dragging the application somewhere else (e.g. /Applications) rather than running it straight out of your Downloads folder.");
                        break;
                    }
                    default: {
                        if (this.log != null) {
                            this.log.error((Object)("Unhandled UpToDate case: " + (Object)((Object)result)));
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (this.log == null) break block11;
                this.log.error((Throwable)e);
            }
        }
    }

    private void fail(String message) {
        if (this.log != null) {
            this.log.warn((Object)message);
        }
        if (this.uiService != null) {
            this.uiService.showDialog(message, "ImageJ Updater", DialogPrompt.MessageType.WARNING_MESSAGE);
        }
    }
}

