/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.util.List;
import net.imagej.updater.UpToDate;
import net.imagej.updater.UpdaterUI;
import net.imagej.updater.util.UpdaterUtil;
import org.scijava.command.Command;
import org.scijava.command.CommandInfo;
import org.scijava.command.CommandService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, label="There are updates available")
public class PromptUserToUpdate
implements Command {
    private static final String YES = "Yes, please";
    private static final String NEVER = "Never";
    private static final String LATER = "Remind me later";
    @Parameter
    private CommandService commandService;
    @Parameter
    private LogService log;
    @Parameter(label="Do you want to start the Updater now?", choices={"Yes, please", "Never", "Remind me later"})
    private String updateAction = "Yes, please";

    public void run() {
        if (Boolean.getBoolean("java.awt.headless")) {
            return;
        }
        if (this.updateAction.equals(YES)) {
            List updaters = this.commandService.getCommandsOfType(UpdaterUI.class);
            if (updaters.size() > 0) {
                this.commandService.run((CommandInfo)updaters.get(0), true, new Object[0]);
            } else {
                if (this.log == null) {
                    this.log = UpdaterUtil.getLogService();
                }
                this.log.error((Object)"No updater plugins found!");
            }
        } else if (this.updateAction.equals(NEVER)) {
            UpToDate.setLatestNag(Long.MAX_VALUE);
        } else if (this.updateAction.equals(LATER)) {
            UpToDate.setLatestNag();
        } else {
            throw new RuntimeException("Unknown update action: " + this.updateAction);
        }
    }
}

