/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.RandomAccessInputStream;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.units.unit.Unit;
import ome.xml.model.primitives.Timestamp;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class FEITiffReader
extends BaseTiffReader {
    public static final int SFEG_TAG = 34680;
    public static final int HELIOS_TAG = 34682;
    public static final int TITAN_TAG = 34683;
    private static final String DATE_FORMAT = "MM/dd/yyyy HH:mm:ss a";
    private static final double MAG_MULTIPLIER = 0.0024388925;
    private String imageName;
    private String imageDescription;
    private String date;
    private String userName;
    private String microscopeModel;
    private Length stageX;
    private Length stageY;
    private Length stageZ;
    private Double sizeX;
    private Double sizeY;
    private Double timeIncrement;
    private ArrayList<String> detectors;
    private Double magnification;

    public FEITiffReader() {
        super("FEI TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        return ifd.containsKey((Object)34680) || ifd.containsKey((Object)34682) || ifd.containsKey((Object)34683);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.imageName = null;
            this.imageDescription = null;
            this.date = null;
            this.userName = null;
            this.microscopeModel = null;
            this.stageZ = null;
            this.stageY = null;
            this.stageX = null;
            this.timeIncrement = null;
            this.sizeY = null;
            this.sizeX = null;
            this.detectors = null;
            this.magnification = null;
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        boolean helios = ((IFD)this.ifds.get(0)).containsKey((Object)34682);
        boolean titan = ((IFD)this.ifds.get(0)).containsKey((Object)34683);
        if (titan && ((IFD)this.ifds.get(0)).getIFDTextValue(34683).trim().isEmpty()) {
            titan = false;
        }
        String software = "S-FEG";
        if (titan) {
            software = "Titan";
        } else if (helios) {
            software = "Helios NanoLab";
        }
        this.addGlobalMeta("Software", software);
        int tagKey = 34680;
        if (titan) {
            tagKey = 34683;
        } else if (helios) {
            tagKey = 34682;
        }
        String tag = ((IFD)this.ifds.get(0)).getIFDTextValue(tagKey);
        if (tag == null) {
            return;
        }
        if ((tag = tag.trim()).isEmpty()) {
            return;
        }
        if (tag.startsWith("<")) {
            XMLTools.parseXML(tag, (DefaultHandler)new FEIHandler());
        } else {
            IniParser parser = new IniParser();
            IniList ini = parser.parseINI(new BufferedReader(new StringReader(tag)));
            this.detectors = new ArrayList();
            if (helios) {
                IniTable userTable = ini.getTable("User");
                this.date = (String)userTable.get("Date") + " " + (String)userTable.get("Time");
                if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                    String beamTableName;
                    IniTable beamTable;
                    this.userName = (String)userTable.get("User");
                    IniTable systemTable = ini.getTable("System");
                    if (systemTable == null) {
                        systemTable = ini.getTable("SYSTEM");
                    }
                    if (systemTable != null) {
                        this.microscopeModel = (String)systemTable.get("SystemType");
                    }
                    if ((beamTable = ini.getTable("Beam")) != null && (beamTableName = (String)beamTable.get("Beam")) != null) {
                        beamTable = ini.getTable(beamTableName);
                    }
                    if (beamTable != null) {
                        Double number;
                        String beamX = (String)beamTable.get("StageX");
                        String beamY = (String)beamTable.get("StageY");
                        String beamZ = (String)beamTable.get("StageZ");
                        IniTable stageTable = ini.getTable("Stage");
                        if (beamX != null) {
                            number = Double.valueOf(beamX);
                            this.stageX = new Length((Number)number, UNITS.REFERENCEFRAME);
                        } else if (stageTable != null) {
                            number = Double.valueOf((String)stageTable.get("StageX"));
                            this.stageX = new Length((Number)number, UNITS.REFERENCEFRAME);
                        }
                        if (beamY != null) {
                            number = Double.valueOf(beamY);
                            this.stageY = new Length((Number)number, UNITS.REFERENCEFRAME);
                        } else if (stageTable != null) {
                            number = Double.valueOf((String)stageTable.get("StageY"));
                            this.stageY = new Length((Number)number, UNITS.REFERENCEFRAME);
                        }
                        if (beamZ != null) {
                            number = Double.valueOf(beamZ);
                            this.stageZ = new Length((Number)number, UNITS.REFERENCEFRAME);
                        } else if (stageTable != null) {
                            number = Double.valueOf((String)stageTable.get("StageZ"));
                            this.stageZ = new Length((Number)number, UNITS.REFERENCEFRAME);
                        }
                    }
                    IniTable scanTable = ini.getTable("Scan");
                    this.sizeX = DataTools.parseDouble((String)scanTable.get("PixelWidth"));
                    this.sizeY = DataTools.parseDouble((String)scanTable.get("PixelHeight"));
                    this.timeIncrement = DataTools.parseDouble((String)scanTable.get("FrameTime"));
                }
            } else {
                IniTable dataTable = ini.getTable("DatabarData");
                this.imageName = (String)dataTable.get("ImageName");
                this.imageDescription = (String)dataTable.get("szUserText");
                String magnification = (String)ini.getTable("Vector").get("Magnification");
                this.sizeX = DataTools.parseDouble(magnification) * 0.0024388925;
                this.sizeY = DataTools.parseDouble(magnification) * 0.0024388925;
                IniTable scanTable = ini.getTable("Vector.Sysscan");
                Double posX = Double.valueOf((String)scanTable.get("PositionX"));
                Double posY = Double.valueOf((String)scanTable.get("PositionY"));
                this.stageX = new Length((Number)posX, UNITS.REFERENCEFRAME);
                this.stageY = new Length((Number)posY, UNITS.REFERENCEFRAME);
                IniTable detectorTable = ini.getTable("Vector.Video.Detectors");
                int detectorCount = Integer.parseInt((String)detectorTable.get("NrDetectorsConnected"));
                for (int i = 0; i < detectorCount; ++i) {
                    this.detectors.add((String)detectorTable.get("Detector_" + i + "_Name"));
                }
            }
            if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                HashMap<String, String> iniMap = ini.flattenIntoHashMap();
                this.metadata.putAll(iniMap);
            }
        }
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        if (this.date != null) {
            this.date = DateTools.formatDate(this.date, DATE_FORMAT);
            if (this.date != null) {
                store.setImageAcquisitionDate(new Timestamp(this.date), 0);
            }
        }
        if (this.imageName != null) {
            store.setImageName(this.imageName, 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String instrument;
            if (this.imageDescription != null) {
                store.setImageDescription(this.imageDescription, 0);
            }
            if (this.userName != null) {
                store.setExperimenterID(MetadataTools.createLSID((String)"Experimenter", (int[])new int[]{0}), 0);
                store.setExperimenterLastName(this.userName, 0);
            }
            if (this.microscopeModel != null) {
                instrument = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0});
                store.setInstrumentID(instrument, 0);
                store.setImageInstrumentRef(instrument, 0);
                store.setMicroscopeModel(this.microscopeModel, 0);
            }
            if (this.detectors != null && this.detectors.size() > 0) {
                instrument = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0});
                store.setInstrumentID(instrument, 0);
                store.setImageInstrumentRef(instrument, 0);
                for (int i = 0; i < this.detectors.size(); ++i) {
                    String detectorID = MetadataTools.createLSID((String)"Detector", (int[])new int[]{0, i});
                    store.setDetectorID(detectorID, 0, i);
                    store.setDetectorModel(this.detectors.get(i), 0, i);
                    store.setDetectorType(MetadataTools.getDetectorType((String)"Other"), 0, i);
                }
            }
            if (this.magnification != null) {
                store.setObjectiveID(MetadataTools.createLSID((String)"Objective", (int[])new int[]{0, 0}), 0, 0);
                store.setObjectiveNominalMagnification(this.magnification, 0, 0);
                store.setObjectiveCorrection(MetadataTools.getCorrection((String)"Other"), 0, 0);
                store.setObjectiveImmersion(MetadataTools.getImmersion((String)"Other"), 0, 0);
            }
            store.setStageLabelX(this.stageX, 0);
            store.setStageLabelY(this.stageY, 0);
            store.setStageLabelZ(this.stageZ, 0);
            store.setStageLabelName("", 0);
            boolean helios = ((IFD)this.ifds.get(0)).containsKey((Object)34682);
            Unit unit = UNITS.MICROMETER;
            if (helios) {
                unit = UNITS.METER;
            }
            Length physicalSizeX = FormatTools.getPhysicalSizeX((Double)this.sizeX, (Unit)unit);
            Length physicalSizeY = FormatTools.getPhysicalSizeY((Double)this.sizeY, (Unit)unit);
            if (physicalSizeX != null) {
                store.setPixelsPhysicalSizeX(physicalSizeX, 0);
            }
            if (physicalSizeY != null) {
                store.setPixelsPhysicalSizeY(physicalSizeY, 0);
            }
            if (this.timeIncrement != null) {
                store.setPixelsTimeIncrement(new Time((Number)this.timeIncrement, UNITS.SECOND), 0);
            }
        }
    }

    class FEIHandler
    extends BaseHandler {
        private StringBuilder sb;
        private String key;
        private String value;
        private Deque<String> parentNames = new ArrayDeque<String>();

        FEIHandler() {
        }

        @Override
        public void characters(char[] data, int start, int len) {
            this.sb.append(data, start, len);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.parentNames.push(qName);
            this.sb = new StringBuilder();
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            String name;
            this.processElement(qName);
            if (this.parentNames.size() > 0 && qName.equals(name = this.parentNames.peek())) {
                this.parentNames.pop();
            }
        }

        private void processElement(String qName) {
            String d = this.sb.toString().trim();
            if (d.isEmpty()) {
                return;
            }
            String parent = this.parentNames.peek();
            if (parent == null) {
                return;
            }
            if (parent.equals(qName)) {
                this.parentNames.pop();
                parent = this.parentNames.peek();
            }
            if (qName.equals("Label")) {
                this.key = d;
                this.value = null;
            } else if (qName.equals("Value")) {
                this.value = d;
            } else {
                this.key = parent + " " + qName;
                this.value = d;
            }
            if (this.key != null && this.value != null) {
                FEITiffReader.this.addGlobalMeta(this.key, this.value);
                if (this.key.equals("Stage X") || this.key.equals("StagePosition X")) {
                    Double number = Double.valueOf(this.value);
                    FEITiffReader.this.stageX = new Length((Number)number, UNITS.REFERENCEFRAME);
                } else if (this.key.equals("Stage Y") || this.key.equals("StagePosition Y")) {
                    Double number = Double.valueOf(this.value);
                    FEITiffReader.this.stageY = new Length((Number)number, UNITS.REFERENCEFRAME);
                } else if (this.key.equals("Stage Z") || this.key.equals("StagePosition Z")) {
                    Double number = Double.valueOf(this.value);
                    FEITiffReader.this.stageZ = new Length((Number)number, UNITS.REFERENCEFRAME);
                } else if (this.key.equals("Microscope")) {
                    FEITiffReader.this.microscopeModel = this.value;
                } else if (this.key.equals("User")) {
                    FEITiffReader.this.userName = this.value;
                } else if (this.key.equals("Magnification")) {
                    FEITiffReader.this.magnification = DataTools.parseDouble(this.value);
                } else if (this.key.endsWith("X") && "PixelSize".equals(parent) || this.key.endsWith(" pixelWidth") && "FeiImage".equals(parent)) {
                    FEITiffReader.this.sizeX = DataTools.parseDouble(this.value);
                } else if (this.key.endsWith("Y") && "PixelSize".equals(parent) || this.key.endsWith(" pixelHeight") && "FeiImage".equals(parent)) {
                    FEITiffReader.this.sizeY = DataTools.parseDouble(this.value);
                }
            }
        }
    }
}

