/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import loci.common.DataTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.in.LOFReader;
import loci.formats.in.LeicaMicrosystemsMetadata.LMSFileReader;
import loci.formats.in.LeicaMicrosystemsMetadata.LMSImageXmlDocument;
import loci.formats.in.LeicaMicrosystemsMetadata.MultipleImagesReader;
import loci.formats.in.LeicaMicrosystemsMetadata.XlefDocument;
import loci.formats.in.LeicaMicrosystemsMetadata.XlifDocument;
import org.apache.commons.io.comparator.PathFileComparator;

public class XLEFReader
extends LMSFileReader {
    private List<LMSFileReader> readers = new ArrayList<LMSFileReader>();

    public XLEFReader() {
        super("Extended leica file", "xlef");
        this.hasCompanionFiles = true;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int readerIndex = this.getReaderIndex(this.getSeries());
        LMSFileReader reader = this.readers.get(readerIndex);
        reader.setSeries(this.getSeriesPerReaderIndex(this.getSeries()));
        buf = reader.getImageFormat() == LMSFileReader.ImageFormat.JPEG ? this.openBytesJpeg(no, buf, x, y, w, h) : reader.openBytes(no, buf, x, y, w, h);
        return buf;
    }

    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        byte[] newBuffer;
        LMSFileReader reader = this.readers.get(this.getReaderIndex(this.getSeries()));
        int ch = this.getRGBChannelCount();
        int bpp = FormatTools.getBytesPerPixel((int)reader.getPixelType());
        try {
            newBuffer = DataTools.allocate(w, h, ch, bpp);
        }
        catch (IllegalArgumentException e) {
            throw new FormatException("Image plane too large. Only 2GB of data can be extracted at one time. You can work around the problem by opening the plane in tiles; for further details, see: https://docs.openmicroscopy.org/bio-formats/" + FormatTools.VERSION + "/about/bug-reporting.html#common-issues-to-check", (Throwable)e);
        }
        return this.openBytes(no, newBuffer, x, y, w, h);
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.associatedXmlDoc = new XlefDocument(id);
        ((XlefDocument)this.associatedXmlDoc).printReferences();
        List<LMSImageXmlDocument> xlifs = ((XlefDocument)this.associatedXmlDoc).getXlifs();
        if (xlifs.size() == 0) {
            throw new FormatException("Cannot open project: project has no valid image references");
        }
        for (int i = 0; i < xlifs.size(); ++i) {
            LMSFileReader reader;
            XlifDocument xlif = xlifs.get(i);
            switch (xlif.getImageFormat()) {
                case LOF: {
                    reader = new LOFReader(xlif);
                    reader.setIdWithMetadata(xlif.getImagePaths().get(0), xlif);
                    break;
                }
                case TIF: 
                case BMP: 
                case JPEG: 
                case PNG: {
                    reader = new MultipleImagesReader(xlif, i);
                    break;
                }
                default: {
                    throw new FormatException("Cannot open project: project contains invalid image formats");
                }
            }
            this.readers.add(reader);
        }
        this.translateMetadata(xlifs);
        this.setMetadataOfMultipleImagesReaders();
        this.sortMultipleImagesReaders();
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.currentId);
        files.addAll(((XlefDocument)this.associatedXmlDoc).getChildrenFiles(!noPixels));
        this.sortPaths(files);
        return files.toArray(new String[files.size()]);
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        ArrayList<String> files = new ArrayList<String>();
        LMSFileReader reader = this.readers.get(this.getReaderIndex(this.getSeries()));
        XlifDocument xlif = (XlifDocument)reader.associatedXmlDoc;
        files.add(xlif.getFilepath());
        files.addAll(xlif.getParentFiles());
        if (!noPixels) {
            files.addAll(xlif.getImagePaths());
        }
        this.sortPaths(files);
        return files.toArray(new String[files.size()]);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            for (LMSFileReader reader : this.readers) {
                if (reader instanceof LOFReader) {
                    ((LOFReader)reader).close(fileOnly);
                    continue;
                }
                if (!(reader instanceof MultipleImagesReader)) continue;
                ((MultipleImagesReader)reader).close(fileOnly);
            }
            this.readers.clear();
        }
    }

    public void reopenFile() throws IOException {
        super.reopenFile();
        for (LMSFileReader reader : this.readers) {
            reader.reopenFile();
        }
    }

    @Override
    public LMSFileReader.ImageFormat getImageFormat() {
        return this.readers.get(this.getReaderIndex(this.getSeries())).getImageFormat();
    }

    private int getReaderIndex(int seriesIndex) {
        for (int readerIndex = 0; readerIndex < this.readers.size(); ++readerIndex) {
            int lastSeriesIndexLastReader = this.sum(this.metaTemp.tileCount, 0, readerIndex - 1) - 1;
            int lastSeriesIndexThisReader = lastSeriesIndexLastReader + this.metaTemp.tileCount[readerIndex];
            if (seriesIndex < readerIndex || seriesIndex <= lastSeriesIndexLastReader || seriesIndex > lastSeriesIndexThisReader) continue;
            return readerIndex;
        }
        return -1;
    }

    private int getSeriesPerReaderIndex(int series) {
        int readerIndex = this.getReaderIndex(series);
        int sprIndex = series - this.sum(this.metaTemp.tileCount, 0, readerIndex - 1);
        return sprIndex;
    }

    private byte[] openBytesJpeg(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        LMSFileReader fReader = this.readers.get(this.getReaderIndex(this.getSeries()));
        if (fReader.getImageFormat() != LMSFileReader.ImageFormat.JPEG) {
            throw new IOException("Error: Cannot open jpeg bytes with reader " + ((Object)((Object)fReader)).getClass());
        }
        MultipleImagesReader reader = (MultipleImagesReader)fReader;
        if (!this.isRGB() && reader.getRGBChannelCount() == 3) {
            byte[] rgbBuffer;
            int bppJpeg = FormatTools.getBytesPerPixel((int)reader.getPixelType());
            try {
                rgbBuffer = DataTools.allocate(w, h, reader.getRGBChannelCount(), bppJpeg);
            }
            catch (IllegalArgumentException e) {
                throw new FormatException("Image plane too large. Only 2GB of data can be extracted at one time. You can work around the problem by opening the plane in tiles; for further details, see: https://docs.openmicroscopy.org/bio-formats/" + FormatTools.VERSION + "/about/bug-reporting.html#common-issues-to-check", (Throwable)e);
            }
            rgbBuffer = reader.openBytes(no, rgbBuffer, x, y, w, h);
            if (rgbBuffer.length == buf.length) {
                buf = rgbBuffer;
            } else {
                byte[] rBuf = this.getRgbChannel(0, rgbBuffer);
                int bppXlef = FormatTools.getBytesPerPixel((int)this.getPixelType());
                if (bppXlef > bppJpeg) {
                    int targetRes = (int)((Long)this.getSeriesMetadataValue("Bits per Sample")).longValue();
                    byte[] rBufUpscaled = new byte[rBuf.length * 2];
                    this.transformBytes8To16(rBuf, rBufUpscaled, targetRes);
                    System.arraycopy(rBufUpscaled, 0, buf, 0, buf.length);
                } else {
                    System.arraycopy(rBuf, 0, buf, 0, buf.length);
                }
            }
        } else {
            buf = reader.openBytes(no, buf, x, y, w, h);
        }
        return buf;
    }

    private void sortMultipleImagesReaders() throws FormatException {
        for (int i = 0; i < this.core.size(); ++i) {
            LMSFileReader reader = this.readers.get(this.getReaderIndex(i));
            if (!(reader instanceof MultipleImagesReader) || reader.getImageFormat() == LMSFileReader.ImageFormat.LOF) continue;
            ((MultipleImagesReader)reader).swapDimensions();
        }
    }

    private void setMetadataOfMultipleImagesReaders() {
        for (int i = 0; i < this.core.size(); ++i) {
            LMSFileReader reader = this.readers.get(this.getReaderIndex(i));
            if (!(reader instanceof MultipleImagesReader)) continue;
            ((MultipleImagesReader)reader).setCoreMetadata((CoreMetadata)this.core.get(i));
            ((MultipleImagesReader)reader).setMetadataTempBuffer(this.metaTemp);
        }
    }

    private void transformBytes8To16(byte[] in, byte[] out, int outRes) {
        if (in.length * 2 != out.length || in.length == 0 || out.length == 0) {
            throw new IllegalArgumentException("Error: buffer lengths are incorrect (in=" + in.length + ", out=" + out.length + ")");
        }
        if (outRes < 8 || outRes > 16) {
            throw new IllegalArgumentException("Error: only 8-16bit bpp are possible for output (" + outRes + "bpp used)");
        }
        int inPtr = 0;
        int outPtr = 0;
        double factor = Math.pow(2.0, outRes - 8);
        while (inPtr < in.length && outPtr < out.length) {
            int val = in[inPtr++];
            val = (int)((double)val * factor);
            out[outPtr++] = (byte)(val >> 8);
            out[outPtr++] = (byte)val;
        }
    }

    private byte[] getRgbChannel(int channel, byte[] in) {
        if (in.length == 0) {
            throw new IllegalArgumentException("Error: buffer is empty");
        }
        if (channel < 0 || channel > 2) {
            throw new IllegalArgumentException("Error: only channels 0 - 2 are allowed (R,G,B)");
        }
        byte[] out = new byte[in.length / 3];
        int channelOffset = in.length / 3;
        int rgbPtr = channelOffset * channel;
        int monoPtr = 0;
        while (monoPtr < out.length && rgbPtr < in.length) {
            out[monoPtr++] = in[rgbPtr++];
        }
        return out;
    }

    private int sum(int[] arr, int start, int end) {
        int n = start = start < 0 ? 0 : start;
        if (end < start) {
            return 0;
        }
        int sum = 0;
        for (int i = start; i <= end; ++i) {
            sum += arr[i];
        }
        return sum;
    }

    private void sortPaths(List<String> paths) {
        ArrayList<File> files = new ArrayList<File>();
        for (String path : paths) {
            files.add(new File(path));
        }
        Collections.sort(files, new PathComparator());
        paths.clear();
        for (File file : files) {
            paths.add(file.getAbsolutePath());
        }
        paths.remove(this.currentId);
        paths.add(0, this.currentId);
    }

    static class PathComparator
    implements Comparator<File> {
        PathComparator() {
        }

        @Override
        public int compare(File file1, File file2) {
            PathFileComparator comp = new PathFileComparator();
            return comp.compare(file1, file2);
        }
    }
}

