/*
 * Decompiled with CFR 0.152.
 */
package org.imagearchive.lsm.toolbox.gui;

import java.io.File;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.table.AbstractTableModel;

public class LsmImageTableModel
extends AbstractTableModel {
    public ArrayList<File> files;
    public String[] columnTitles = new String[]{"Filename", "Size", "Last modifed"};

    public LsmImageTableModel(ArrayList<File> files) {
        this.files = files;
    }

    public LsmImageTableModel() {
        this.files = new ArrayList();
    }

    @Override
    public int getRowCount() {
        return this.files.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnTitles.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnTitles[columnIndex];
    }

    @Override
    public Object getValueAt(int row, int col) {
        File file = this.files.get(row);
        if (col == 0) {
            return file.getName();
        }
        if (col == 1) {
            return new DecimalFormat("###.##").format((float)file.length() / 1024.0f) + " kbytes";
        }
        if (col == 2) {
            return new SimpleDateFormat("dd/MM/yyyy, HH:mm:ss").format(new Date(file.lastModified()));
        }
        return "N/A";
    }

    public Class<String> getColumnClass(int col) {
        return String.class;
    }

    public void addFile(File file) {
        this.files.add(file);
        this.fireTableDataChanged();
    }

    public void removeFile(int index) {
        this.files.remove(index);
        this.fireTableDataChanged();
    }

    public void removeFile(int row, int col) {
        this.files.remove(row * this.columnTitles.length + col);
        this.fireTableDataChanged();
    }

    public void removeAllFiles() {
        this.files.removeAll(this.files);
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object object, int row, int col) {
        this.files.set(row * this.columnTitles.length + col, (File)object);
        this.fireTableDataChanged();
        this.fireTableCellUpdated(row, col);
    }

    public void insertFile(Object object, int row, int col) {
        this.files.add(row * this.columnTitles.length + col, (File)object);
        this.fireTableDataChanged();
    }

    public void setFileAt(File file, int row, int col) {
        this.setValueAt(file, row, col);
    }

    public File getFileAt(int row, int col) {
        return this.files.get(row * this.columnTitles.length + col);
    }

    public ArrayList<File> getFiles() {
        return this.files;
    }
}

