/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.timelapse;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.util.Arrays;

public class Phase_Map
implements PlugInFilter {
    private static final double FOURIER_PERIOD = Math.PI * 4 / (6.0 + Math.sqrt(38.0));
    private double octaveNumber = 4.0;
    private double voicesPerOctave = 50.0;
    private double gaussSigma = 2.0;
    private double x0 = 100.0;
    private double x1 = 400.0;
    private double sigma0 = 1.0;
    private double sigma1 = 1.0;
    private double subtractionPoint = 50.0;
    private boolean plotWaveCounts;
    private boolean showProfileStack;
    private boolean anchorProfileStack;
    private boolean cutTailsFromProfileStack;
    private boolean showPhaseProfileMap;
    private ImagePlus imp;
    private static final int WAVE_COUNT_CUT_OFF = 2;

    private double phase(double[] data, int dataSize, double s, int tau) {
        double wR = 0.0;
        double wI = 0.0;
        for (int i = 0; i < dataSize; ++i) {
            double u = (double)(i - tau) / s;
            double decay = Math.exp(-u * u / 2.0);
            double gaborR = Math.cos(6.0 * u) * decay;
            double gaborI = Math.sin(6.0 * u) * decay;
            wR += data[i] * gaborR;
            wI += data[i] * -gaborI;
        }
        return Math.atan2(wI, wR);
    }

    protected static int[] gaussianLUT() {
        int[] lut = new int[256];
        for (int i = 0; i < 255; ++i) {
            double phase = ((double)i - 127.5) * Math.PI / 127.5;
            double factor = Math.exp(-phase * phase);
            int red = (int)(factor * 255.0);
            int green = (int)(factor * 330.0);
            int blue = (int)(factor * 400.0);
            lut[i] = red << 16 | (green > 255 ? 255 : green) << 8 | (blue > 255 ? 255 : blue);
        }
        return lut;
    }

    protected static LUT createLUT() {
        int i;
        byte[] red = new byte[256];
        byte[] green = new byte[256];
        byte[] blue = new byte[256];
        for (i = 0; i < 128; ++i) {
            red[i] = (byte)((128 - i) * (128 - i) * 127 / 128 / 128);
            green[i] = (byte)((128 - i) * 220 / 128);
            blue[i] = i < 64 ? (byte)(220 + i * -70 / 64) : (byte)((128 - i) * 150 / 64);
        }
        for (i = 128; i < 192; ++i) {
            green[i] = blue[i] = (byte)((i - 128) * 255 / 64);
            red[i] = blue[i];
        }
        for (i = 192; i < 256; ++i) {
            red[i] = (byte)(255 + (i - 192) * -128 / 64);
            green[i] = blue[i] = (byte)(255 + (i - 192) * -35 / 64);
        }
        return new LUT(red, green, blue);
    }

    private float[] phaseMap(ImageProcessor kymograph, boolean showProfileMap) {
        int t;
        int width = kymograph.getWidth();
        int height = kymograph.getHeight();
        FloatProcessor fp = (FloatProcessor)(kymograph instanceof FloatProcessor ? kymograph.duplicate() : kymograph.convertToFloat());
        float[] pixels = (float[])fp.getPixels();
        float[] output = new float[width * height];
        double[] data = new double[height];
        int[] rowLength = new int[height];
        Gauss1D gauss = new Gauss1D(this.gaussSigma);
        for (int t2 = 0; t2 < height; ++t2) {
            gauss.gauss(pixels, t2 * width, width);
        }
        for (int x = 0; x < width; ++x) {
            int t3;
            double voiceNumber = (double)x < this.x0 ? this.sigma0 : ((double)x > this.x1 ? this.sigma1 : this.sigma0 + ((double)x - this.x0) * (this.sigma1 - this.sigma0) / (this.x1 - this.x0));
            double s = Math.pow(2.0, this.octaveNumber - 1.0 + voiceNumber / this.voicesPerOctave) / FOURIER_PERIOD;
            int dataSize = height;
            for (t3 = 0; t3 < height; ++t3) {
                data[t3] = pixels[x + t3 * width];
                if (!(data[t3] < 2.0)) continue;
                dataSize = t3;
                break;
            }
            for (t3 = 0; t3 < dataSize; ++t3) {
                output[x + t3 * width] = (float)this.phase(data, dataSize, s, t3);
            }
        }
        if (!showProfileMap) {
            return output;
        }
        float[] phaseMap = output;
        output = new float[width * height];
        for (t = 0; t < height; ++t) {
            int curWidth = width;
            for (int x = 0; x < width; ++x) {
                if (!(pixels[x + t * width] < 2.0f)) continue;
                curWidth = x;
                break;
            }
            rowLength[t] = curWidth;
        }
        for (t = 0; t < height; ++t) {
            int x;
            for (x = 0; x < rowLength[t]; ++x) {
                float phaseOffset = (phaseMap[x + t * width] - phaseMap[(int)this.subtractionPoint + t * width] + (float)Math.PI) % ((float)Math.PI * 2);
                if (phaseOffset < 0.0f) {
                    phaseOffset += (float)Math.PI * 2;
                }
                output[x + t * width] = phaseOffset - (float)Math.PI;
            }
            for (x = rowLength[t] + 1; x < width; ++x) {
                output[x + t * width] = 0.0f;
            }
        }
        return output;
    }

    private float[] getProfile(float[] pixels, int offset, int length) {
        float[] profile = new float[length];
        for (int i = 0; i < length; ++i) {
            float diff;
            profile[i] = pixels[offset + i];
            if (i <= 0 || !((double)Math.abs(diff = (profile[i] - profile[i - 1]) / (float)Math.PI) >= 0.5)) continue;
            int n = i;
            profile[n] = (float)((double)profile[n] - Math.PI * (double)Math.round(diff));
        }
        return profile;
    }

    private float[] getProfileAtTimepoint(int t, float[] map, int width, int height) {
        int length;
        int offset = t * width;
        for (length = width; length > 0 && map[offset + length - 1] == 0.0f; --length) {
        }
        return this.getProfile(map, offset, length);
    }

    public static float[] range(int from, int to, float factor) {
        float[] range = new float[to - from];
        for (int i = 0; i < range.length; ++i) {
            range[i] = (float)from + (float)i * factor;
        }
        return range;
    }

    public static float[] divide(float[] array, float factor) {
        float[] result = new float[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i] / factor;
        }
        return result;
    }

    private ImagePlus getProfileStack(String title, float[] map, int width, int height, float pixelSpacing, String pixelSpacingUnit, boolean anchorToZero, boolean cutTails) {
        ImageStack stack = null;
        float[][] profiles = new float[height][];
        float minT = Float.MAX_VALUE;
        float maxT = -3.4028235E38f;
        float maxX = -3.4028235E38f;
        for (int t = 0; t < height; ++t) {
            int length;
            profiles[t] = this.getProfileAtTimepoint(t, map, width, height);
            if (maxX < (float)profiles[t].length) {
                maxX = profiles[t].length;
            }
            if (anchorToZero) {
                int i = profiles[t].length - 1;
                while (i >= 0) {
                    float[] fArray = profiles[t];
                    int n = i--;
                    fArray[n] = fArray[n] - profiles[t][0];
                }
            }
            if (cutTails && profiles[t].length > 2) {
                float[] sorted = Arrays.copyOf(profiles[t], profiles[t].length);
                Arrays.sort(sorted);
                float min = sorted[2];
                for (length = profiles[t].length; length > 0 && profiles[t][length - 1] > min; --length) {
                }
                if (length < profiles[t].length) {
                    profiles[t] = Arrays.copyOf(profiles[t], length);
                }
            }
            float[] sorted = profiles[t];
            int min = sorted.length;
            for (length = 0; length < min; ++length) {
                float f = sorted[length];
                if (minT > f) {
                    minT = f;
                }
                if (!(maxT < f)) continue;
                maxT = f;
            }
        }
        float pi2 = (float)Math.PI * 2;
        for (int t = 0; t < height; ++t) {
            float[] x = Phase_Map.range(0, profiles[t].length, pixelSpacing);
            Plot plot = new Plot("profile", "distance" + ("".equals(pixelSpacingUnit) ? "" : " (" + pixelSpacingUnit + ")"), "phase (\u00d7 2\u03c0)", x, Phase_Map.divide(profiles[t], (float)Math.PI * 2));
            plot.setFrameSize(850, 400);
            plot.setLimits(0.0, (double)maxX, (double)(minT / ((float)Math.PI * 2)), (double)(maxT / ((float)Math.PI * 2)));
            ImageProcessor ip = plot.getProcessor();
            if (stack == null) {
                stack = new ImageStack(ip.getWidth(), ip.getHeight());
            }
            stack.addSlice("t=" + t, ip);
        }
        ImagePlus result = new ImagePlus(title, stack);
        Calibration calibration = result.getCalibration();
        if (calibration == null) {
            calibration = new Calibration();
            result.setCalibration(calibration);
        }
        calibration.pixelWidth = pixelSpacing;
        calibration.setUnit(pixelSpacingUnit);
        StringBuilder builder = new StringBuilder();
        builder.append("[\n");
        for (int t = 0; t < profiles.length; ++t) {
            builder.append("  [");
            for (int i = 0; i < profiles[t].length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(profiles[t][i]);
            }
            builder.append(t + 1 < profiles.length ? "],\n" : "]\n");
        }
        builder.append("]\n");
        result.setProperty("Info", (Object)builder.toString());
        return result;
    }

    private float[] getWaveCounts(float[] map, int width, int height) {
        float[] waveCounts = new float[height];
        for (int t = 0; t < height; ++t) {
            float[] profile = this.getProfileAtTimepoint(t, map, width, height);
            if (profile.length <= 2) continue;
            Arrays.sort(profile);
            waveCounts[t] = (float)((double)((profile[profile.length - 2] - profile[2]) / 2.0f) / Math.PI);
        }
        return waveCounts;
    }

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 159;
    }

    public void run(ImageProcessor ip) {
        GenericDialog gd = new GenericDialog("Phase Map");
        gd.addNumericField("Octave_number", this.octaveNumber, 0);
        gd.addNumericField("Voices_per_octave", this.voicesPerOctave, 0);
        gd.addNumericField("Gauss_sigma_(x-axis)", this.gaussSigma, 2);
        gd.addNumericField("x0", this.x0, 0);
        gd.addNumericField("x1", this.x1, 0);
        gd.addNumericField("sigma0", this.sigma0, 0);
        gd.addNumericField("sigma1", this.sigma1, 0);
        gd.addCheckbox("Plot_wave_counts", this.plotWaveCounts);
        gd.addCheckbox("Show_profile_stack", this.showProfileStack);
        gd.addCheckbox("Anchor_profile_stack i.e. normalize to start at (0,0)", this.anchorProfileStack);
        gd.addCheckbox("Cut_tails_from_profile_stack i.e. skip spurious signal at tail", this.cutTailsFromProfileStack);
        gd.addCheckbox("Show_phase_profile_map", this.showPhaseProfileMap);
        gd.addNumericField("Subtraction_point", this.subtractionPoint, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.octaveNumber = gd.getNextNumber();
        this.voicesPerOctave = gd.getNextNumber();
        this.gaussSigma = gd.getNextNumber();
        this.x0 = gd.getNextNumber();
        this.x1 = gd.getNextNumber();
        this.sigma0 = gd.getNextNumber();
        this.sigma1 = gd.getNextNumber();
        this.plotWaveCounts = gd.getNextBoolean();
        this.showProfileStack = gd.getNextBoolean();
        this.anchorProfileStack = gd.getNextBoolean();
        this.cutTailsFromProfileStack = gd.getNextBoolean();
        this.showPhaseProfileMap = gd.getNextBoolean();
        this.subtractionPoint = gd.getNextNumber();
        int width = ip.getWidth();
        int height = ip.getHeight();
        Calibration calibration = this.imp.getCalibration();
        float pixelSpacing = calibration == null || calibration.pixelWidth == 0.0 ? 1.0f : (float)calibration.pixelWidth;
        String pixelSpacingUnit = calibration == null || "".equals(calibration.getUnit()) ? "pixels" : calibration.getUnit();
        float frameInterval = calibration == null || calibration.frameInterval == 0.0 ? 1.0f : (float)calibration.frameInterval;
        String frameIntervalUnit = calibration == null || "".equals(calibration.getTimeUnit()) ? "" : calibration.getTimeUnit();
        float[] phaseMapPixels = this.phaseMap(ip, false);
        FloatProcessor resultPhaseMap = new FloatProcessor(width, height, phaseMapPixels);
        resultPhaseMap.setMinAndMax(-Math.PI, Math.PI);
        resultPhaseMap.setLut(Phase_Map.createLUT());
        FloatProcessor phaseMap = resultPhaseMap;
        new ImagePlus("Phase Map of " + this.imp.getTitle(), (ImageProcessor)phaseMap).show();
        if (this.plotWaveCounts) {
            float[] counts = this.getWaveCounts(phaseMapPixels, width, height);
            float[] x = Phase_Map.range(0, counts.length, frameInterval);
            new Plot("Wave counts of " + this.imp.getTitle(), "time" + ("".equals(frameIntervalUnit) ? "" : " (" + frameIntervalUnit + ")"), "wave count", x, counts).show();
        }
        if (this.showProfileStack) {
            this.getProfileStack("Profile Stack  of " + this.imp.getTitle(), phaseMapPixels, width, height, pixelSpacing, pixelSpacingUnit, this.anchorProfileStack, this.cutTailsFromProfileStack).show();
        }
        if (this.showPhaseProfileMap) {
            FloatProcessor resultPhaseProfileMap = new FloatProcessor(width, height, this.phaseMap(ip, true));
            resultPhaseProfileMap.setMinAndMax(-Math.PI, Math.PI);
            resultPhaseProfileMap.setLut(Phase_Map.createLUT());
            FloatProcessor phaseProfileMap = resultPhaseProfileMap;
            new ImagePlus("Phase Profile Map of " + this.imp.getTitle(), (ImageProcessor)phaseProfileMap).show();
        }
    }

    protected static class Gauss1D {
        private final int radius;
        private final double[] kernel;

        public Gauss1D(double sigma) {
            int i;
            this.radius = (int)Math.ceil(sigma * 2.0);
            this.kernel = new double[1 + 2 * this.radius];
            double total = 0.0;
            for (i = -this.radius; i <= this.radius; ++i) {
                this.kernel[i + this.radius] = Math.exp(-0.5 * (double)i * (double)i / sigma / sigma);
                total += this.kernel[i + this.radius];
            }
            i = 0;
            while (i < this.kernel.length) {
                int n = i++;
                this.kernel[n] = this.kernel[n] / total;
            }
        }

        public void gauss(double[] data, int offset, int dataSize) {
            int k;
            int j;
            double value;
            int i;
            double[] result = new double[dataSize];
            if (result.length < this.kernel.length) {
                throw new IllegalArgumentException("Too few data");
            }
            for (i = 0; i < this.radius; ++i) {
                value = 0.0;
                j = -this.radius;
                k = this.radius + 1 - i;
                while (j < -i) {
                    value += data[offset + k] * this.kernel[this.radius + j];
                    ++j;
                    --k;
                }
                for (j = -i; j <= this.radius; ++j) {
                    value += data[offset + i + j] * this.kernel[this.radius + j];
                }
                result[i] = value;
            }
            for (i = this.radius; i < dataSize - this.radius; ++i) {
                value = 0.0;
                for (j = -this.radius; j <= this.radius; ++j) {
                    value += data[offset + i + j] * this.kernel[this.radius + j];
                }
                result[i] = value;
            }
            for (i = dataSize - this.radius; i < dataSize; ++i) {
                value = 0.0;
                for (j = -this.radius; j < dataSize - i; ++j) {
                    value += data[offset + i + j] * this.kernel[this.radius + j];
                }
                j = dataSize - i;
                k = dataSize - 1;
                while (j <= this.radius) {
                    value += data[offset + k] * this.kernel[this.radius + j];
                    ++j;
                    --k;
                }
                result[i] = value;
            }
            System.arraycopy(result, 0, data, offset, dataSize);
        }

        public void gauss(float[] data, int offset, int dataSize) {
            int k;
            int j;
            float value;
            int i;
            float[] result = new float[dataSize];
            if (result.length < this.kernel.length) {
                throw new IllegalArgumentException("Too few data");
            }
            for (i = 0; i < this.radius; ++i) {
                value = 0.0f;
                j = -this.radius;
                k = this.radius + 1 - i;
                while (j < -i) {
                    value = (float)((double)value + (double)data[offset + k] * this.kernel[this.radius + j]);
                    ++j;
                    --k;
                }
                for (j = -i; j <= this.radius; ++j) {
                    value = (float)((double)value + (double)data[offset + i + j] * this.kernel[this.radius + j]);
                }
                result[i] = value;
            }
            for (i = this.radius; i < dataSize - this.radius; ++i) {
                value = 0.0f;
                for (j = -this.radius; j <= this.radius; ++j) {
                    value = (float)((double)value + (double)data[offset + i + j] * this.kernel[this.radius + j]);
                }
                result[i] = value;
            }
            for (i = dataSize - this.radius; i < dataSize; ++i) {
                value = 0.0f;
                for (j = -this.radius; j < dataSize - i; ++j) {
                    value = (float)((double)value + (double)data[offset + i + j] * this.kernel[this.radius + j]);
                }
                j = dataSize - i;
                k = dataSize - 1;
                while (j <= this.radius) {
                    value = (float)((double)value + (double)data[offset + k] * this.kernel[this.radius + j]);
                    ++j;
                    --k;
                }
                result[i] = value;
            }
            System.arraycopy(result, 0, data, offset, dataSize);
        }
    }
}

