/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.timelapse;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.Plot;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import sc.fiji.timelapse.PlotUtils;

public class ProfileStack
extends ImagePlus {
    protected ImagePlus image;
    protected float[][] profiles;
    protected PolygonRoi[] rois;
    protected float xMin;
    protected float yMin;
    protected float xMax;
    protected float yMax;

    public ProfileStack(ImagePlus image, PolygonRoi[] rois) {
        this.image = image;
        this.rois = rois;
        this.makeProfiles();
    }

    protected void makeProfiles() {
        this.xMin = 0.0f;
        this.yMin = Float.MAX_VALUE;
        this.yMax = -3.4028235E38f;
        this.xMax = -3.4028235E38f;
        ImageStack stack = this.image.getStack();
        this.profiles = new float[stack.getSize()][];
        for (int slice = 1; slice <= this.profiles.length; ++slice) {
            if (this.rois[slice - 1] == null) continue;
            this.profiles[slice - 1] = PlotUtils.getProfile(stack.getProcessor(slice), this.rois[slice - 1], true, Line.getWidth());
            if (this.xMax < (float)this.profiles[slice - 1].length) {
                this.xMax = this.profiles[slice - 1].length;
            }
            for (float value : this.profiles[slice - 1]) {
                if (this.yMax < value) {
                    this.yMax = value;
                }
                if (!(this.yMin > value)) continue;
                this.yMin = value;
            }
        }
        float xMargin = this.xMax > this.xMin ? 0.05f * (this.xMax - this.xMin) : 0.0f;
        float yMargin = this.yMax > this.yMin ? 0.05f * (this.yMax - this.yMin) : 0.0f;
        this.xMin -= xMargin;
        this.xMax += xMargin;
        this.yMin -= yMargin;
        this.yMax += yMargin;
        ImageStack plots = null;
        for (int i = 0; i < this.profiles.length; ++i) {
            double[] dArray;
            if (this.rois[i] != null) {
                dArray = PlotUtils.toDouble(this.profiles[i]);
            } else {
                double[] dArray2 = new double[1];
                dArray = dArray2;
                dArray2[0] = this.yMin;
            }
            double[] values = dArray;
            if (values.length < 1) {
                values = new double[]{this.yMin};
            }
            double[] xValues = PlotUtils.range(0.0, values.length - 1);
            Plot plot = new Plot("Slice " + (i + 1), "distance", "intensity", xValues, values);
            plot.setLimits((double)this.xMin, (double)this.xMax, (double)this.yMin, (double)this.yMax);
            ImageProcessor ip = plot.getProcessor();
            if (plots == null) {
                plots = new ImageStack(ip.getWidth(), ip.getHeight());
            }
            plots.addSlice("Slice " + (i + 1), ip);
        }
        this.setTitle("Profiles of " + this.image.getTitle());
        this.setStack(plots);
        Calibration calibration = new Calibration();
        calibration.pixelWidth = (this.xMax - this.xMin) / (float)(this.getWidth() - 65 - 18);
        calibration.pixelHeight = (this.yMin - this.yMax) / (float)(this.getHeight() - 15 - 40);
        calibration.xOrigin = 65.0 - (double)this.xMin / calibration.pixelWidth;
        calibration.yOrigin = (double)(this.getHeight() - 40) - (double)this.yMin / calibration.pixelHeight;
        this.setCalibration(calibration);
    }

    public void show() {
        if (this.isVisible()) {
            return;
        }
        super.show();
        this.setSlice(this.profiles.length);
    }

    public int x2distance(int x) {
        return (int)(this.xMin + (this.xMax - this.xMin) * (float)(x - 65) / (float)(this.getWidth() - 65 - 18));
    }

    public int distance2x(int distance) {
        return 65 + (int)((float)(this.getWidth() - 65 - 18) * ((float)distance - this.xMin) / (this.xMax - this.xMin));
    }

    public float get(int slice, int distance) {
        if (slice < 1 || slice > this.profiles.length) {
            return 0.0f;
        }
        float[] profile = this.profiles[slice - 1];
        if (distance < 0 || distance >= profile.length) {
            return 0.0f;
        }
        return profile[distance];
    }

    public int intensity2y(float intensity) {
        return this.getHeight() - 40 - (int)((float)(this.getHeight() - 15 - 40) * (intensity - this.yMin) / (this.yMax - this.yMin));
    }

    public void mark(int slice, int distance) {
        this.image.setPosition(slice);
        if (distance < 0) {
            this.unmark();
            return;
        }
        PolygonRoi roi = this.rois[slice - 1];
        if (roi == null) {
            this.image.killRoi();
            return;
        }
        this.image.setRoi((Roi)roi);
        roi = (PolygonRoi)roi.clone();
        roi.fitSplineForStraightening();
        if (distance >= roi.getNCoordinates()) {
            this.unmark();
            return;
        }
        Rectangle bounds = roi.getBounds();
        int x = roi.getXCoordinates()[distance] + bounds.x;
        int y = roi.getYCoordinates()[distance] + bounds.y;
        Overlay overlay = new Overlay((Roi)new OvalRoi(x - 10, y - 10, 21, 21));
        this.image.setOverlay(overlay);
    }

    public void unmark() {
        this.image.setOverlay(null);
    }
}

