/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ini.trakem2.display.AbstractOffscreenThread;
import ini.trakem2.utils.CachingThread;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractRepaintThread
extends CachingThread {
    protected final AbstractOffscreenThread off;
    private final List<PaintEvent> events = new LinkedList<PaintEvent>();
    private final Component target;

    public AbstractRepaintThread(Component target, String name, AbstractOffscreenThread off) {
        super(name);
        this.target = target;
        this.off = off;
        this.setPriority(6);
        try {
            this.setDaemon(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.start();
    }

    public final void paint(Rectangle clipRect) {
        this.paint(clipRect, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Rectangle clipRect, boolean update_graphics) {
        List<PaintEvent> list = this.events;
        synchronized (list) {
            this.events.add(new PaintEvent(clipRect, update_graphics));
            this.events.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        this.interrupt();
        List<PaintEvent> list = this.events;
        synchronized (list) {
            this.events.notifyAll();
        }
        this.off.quit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                Graphics g;
                PaintEvent[] pe;
                List<PaintEvent> list = this.events;
                synchronized (list) {
                    while (0 == this.events.size()) {
                        if (this.isInterrupted()) {
                            return;
                        }
                        try {
                            this.events.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (this.isInterrupted()) {
                    return;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                List<PaintEvent> list2 = this.events;
                synchronized (list2) {
                    pe = new PaintEvent[this.events.size()];
                    this.events.toArray(pe);
                    this.events.clear();
                }
                if (0 == pe.length) continue;
                Rectangle clipRect = pe[0].clipRect;
                boolean update_graphics = pe[0].update_graphics;
                for (int i = 1; i < pe.length; ++i) {
                    if (null != clipRect) {
                        if (null == pe[i].clipRect) {
                            clipRect = null;
                        } else {
                            clipRect.add(pe[i].clipRect);
                        }
                    }
                    if (!update_graphics) {
                        update_graphics = pe[i].update_graphics;
                        continue;
                    }
                    if (null == clipRect) break;
                }
                if (update_graphics) {
                    this.handleUpdateGraphics(this.target, clipRect);
                }
                if (null == (g = this.target.getGraphics())) continue;
                g.setClip(0, 0, this.target.getWidth(), this.target.getHeight());
                this.target.paint(g);
                g.dispose();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected abstract void handleUpdateGraphics(Component var1, Rectangle var2);

    public void waitForOffs() {
        this.off.waitOnRepaintCycle();
    }

    private class PaintEvent {
        final Rectangle clipRect;
        final boolean update_graphics;

        PaintEvent(Rectangle clipRect, boolean update_graphics) {
            this.clipRect = clipRect;
            this.update_graphics = update_graphics;
        }
    }
}

