/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.io;

import amira.AmiraMeshDecoder;
import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.process.ImageProcessor;
import ini.trakem2.display.AreaList;
import ini.trakem2.display.Layer;
import ini.trakem2.display.YesNoDialog;
import ini.trakem2.utils.AreaUtils;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import mpi.fruitfly.general.MultiThreading;

public class AmiraImporter {
    public static Collection<AreaList> importAmiraLabels(Layer first_layer, double xo, double yo, String default_dir) {
        String path;
        AmiraMeshDecoder dec;
        OpenDialog od = new OpenDialog("Choose Amira Labels File", default_dir, "");
        String filename = od.getFileName();
        if (null == filename || 0 == filename.length()) {
            return null;
        }
        String dir = od.getDirectory();
        if (IJ.isWindows()) {
            dir = dir.replace('\\', '/');
        }
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        if (!(dec = new AmiraMeshDecoder()).open(path = dir + filename)) {
            YesNoDialog yn = new YesNoDialog("Error", "File was not an Amira labels file.\nChoose another one?");
            if (yn.yesPressed()) {
                return AmiraImporter.importAmiraLabels(first_layer, xo, yo, default_dir);
            }
            return null;
        }
        ImagePlus imp = null;
        if (dec.isTable()) {
            Utils.showMessage("Select the other file (the labels)!");
            return null;
        }
        FileInfo fi = new FileInfo();
        fi.fileName = filename;
        fi.directory = dir;
        imp = new ImagePlus("Amira", dec.getStack());
        dec.parameters.setParameters(imp);
        return AmiraImporter.extractAmiraLabels(imp, dec.parameters, first_layer, xo, yo);
    }

    public static Collection<AreaList> extractAmiraLabels(ImagePlus labels, AmiraParameters ap, Layer first_layer, double xo, double yo) {
        String[] materials = ap.getMaterialList();
        Map<Float, AreaList> alis = AmiraImporter.extractAreaLists(labels, first_layer, xo, yo, 0.4f, false);
        for (int i = 0; i < materials.length; ++i) {
            int id = ap.getMaterialID(materials[i]);
            double[] color = ap.getMaterialColor(id);
            String name = ap.getMaterialName(id);
            if (name.equals("Exterior")) {
                Utils.log("Ignoring Amira's \"Exterior\" label");
                continue;
            }
            AreaList ali = alis.get(new Float(id));
            if (null == ali) {
                Utils.log("ERROR: no AreaList for label id " + id);
                continue;
            }
            ali.setColor(new Color((float)color[0], (float)color[1], (float)color[2]));
            ali.setTitle(name);
        }
        return alis.values();
    }

    public static Map<Float, AreaList> extractAreaLists(ImagePlus imp, Layer first_layer, double base_x, double base_y, float alpha, final boolean add_background) {
        try {
            final HashMap map = new HashMap();
            final ImageStack stack = imp.getStack();
            final AtomicInteger ai = new AtomicInteger(1);
            final AtomicInteger completed_slices = new AtomicInteger(0);
            final int n_slices = imp.getNSlices();
            final Thread parent = Thread.currentThread();
            Thread[] threads = MultiThreading.newThreads();
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Rectangle box = new Rectangle(0, 0, 1, 1);
                        int i = ai.getAndIncrement();
                        while (i <= n_slices) {
                            ImageProcessor ip;
                            HashMap hashMap = map;
                            synchronized (hashMap) {
                                ip = stack.getProcessor(i);
                            }
                            if (parent.isInterrupted()) {
                                return;
                            }
                            HashMap<Float, Area> layer_map = new HashMap<Float, Area>();
                            HashMap hashMap2 = map;
                            synchronized (hashMap2) {
                                map.put(i, layer_map);
                            }
                            AreaUtils.extractAreas(ip, layer_map, add_background, box, parent, true);
                            Utils.showProgress((float)completed_slices.incrementAndGet() / (float)n_slices);
                            i = ai.getAndIncrement();
                        }
                    }
                };
            }
            MultiThreading.startAndJoin(threads);
            Utils.showProgress(1.0);
            if (parent.isInterrupted()) {
                return null;
            }
            HashMap<Float, AreaList> alis = new HashMap<Float, AreaList>();
            Utils.log2("Recreating arealists...");
            Utils.log2("map.size() = " + map.size());
            double thickness = first_layer.getThickness();
            double first_z = first_layer.getZ();
            for (Map.Entry e : map.entrySet()) {
                int slice_index = (Integer)e.getKey();
                HashMap layer_map = (HashMap)e.getValue();
                for (Map.Entry fa : layer_map.entrySet()) {
                    Float label = (Float)fa.getKey();
                    AreaList ali = alis.get(label);
                    if (null == ali) {
                        ali = new AreaList(first_layer.getProject(), "Label " + label.intValue(), base_x, base_y);
                        alis.put(label, ali);
                    }
                    double z = first_z + (double)(slice_index - 1) * thickness;
                    Layer layer = first_layer.getParent().getLayer(z, thickness, true);
                    ali.setArea(layer.getId(), (Area)fa.getValue());
                }
            }
            Utils.log2("Done recreating.");
            first_layer.getParent().addAll(alis.values());
            Utils.log2("Done adding all to LayerSet");
            float hue = 0.0f;
            for (Map.Entry e : alis.entrySet()) {
                AreaList ali = (AreaList)e.getValue();
                ali.setProperty("label", Integer.toString(((Float)e.getKey()).intValue()));
                ali.calculateBoundingBox(null);
                ali.setColor(Color.getHSBColor(hue, 1.0f, 1.0f));
                ali.setAlpha(alpha);
                if (!((hue += 0.38197f) > 1.0f)) continue;
                hue -= 1.0f;
            }
            Utils.log2("Done setting properties");
            return alis;
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
    }
}

