/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kappa;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.imagej.ImageJ;
import org.scijava.command.Command;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.kappa.gui.KappaFrame;

@Plugin(type=Command.class, menuPath="Plugins>Analyze>Kappa - Curvature Analysis")
public class KappaPlugin
implements Command {
    @Parameter
    private ImageJ ij;
    @Parameter
    private LogService log;
    public static final String PLUGIN_NAME = "Kappa";
    public static final String VERSION = KappaPlugin.version();

    public void run() {
        this.log.info((Object)("Running Kappa version " + VERSION));
        KappaFrame frame = new KappaFrame(this.ij.context());
        frame.setMinimumSize(new Dimension(700, 550));
        frame.setTitle("Kappa version " + VERSION);
        try {
            BufferedImage im = ImageIO.read(KappaFrame.class.getResource("/logo.png"));
            frame.setIconImage(im);
            frame.setDefaultCloseOperation(2);
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        }
        catch (IOException ex) {
            Logger.getLogger(KappaFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static String version() {
        String version = null;
        Package pack = KappaPlugin.class.getPackage();
        if (pack != null) {
            version = pack.getImplementationVersion();
        }
        return version == null ? "DEVELOPMENT" : version;
    }
}

