/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import org.jogamp.java3d.utils.geometry.BBox;
import org.jogamp.java3d.utils.geometry.Heap;
import org.jogamp.java3d.utils.geometry.NoHash;
import org.jogamp.java3d.utils.geometry.Numerics;
import org.jogamp.java3d.utils.geometry.Triangulator;

class EarClip {
    EarClip() {
    }

    static void classifyAngles(Triangulator triRef, int ind) {
        int ind2;
        int ind1 = ind;
        int i1 = triRef.fetchData(ind1);
        int ind0 = triRef.fetchPrevData(ind1);
        int i0 = triRef.fetchData(ind0);
        do {
            ind2 = triRef.fetchNextData(ind1);
            int i2 = triRef.fetchData(ind2);
            int angle = Numerics.isConvexAngle(triRef, i0, i1, i2, ind1);
            triRef.setAngle(ind1, angle);
            i0 = i1;
            i1 = i2;
        } while ((ind1 = ind2) != ind);
    }

    static void classifyEars(Triangulator triRef, int ind) {
        int[] ind0 = new int[1];
        int[] ind2 = new int[1];
        double[] ratio = new double[1];
        Heap.initHeap(triRef);
        int ind1 = ind;
        int i1 = triRef.fetchData(ind1);
        do {
            if (triRef.getAngle(ind1) > 0 && EarClip.isEar(triRef, ind1, ind0, ind2, ratio)) {
                Heap.dumpOnHeap(triRef, ratio[0], ind1, ind0[0], ind2[0]);
            }
            ind1 = triRef.fetchNextData(ind1);
            i1 = triRef.fetchData(ind1);
        } while (ind1 != ind);
    }

    static boolean isEar(Triangulator triRef, int ind2, int[] ind1, int[] ind3, double[] ratio) {
        BBox bb;
        int i2 = triRef.fetchData(ind2);
        ind3[0] = triRef.fetchNextData(ind2);
        int i3 = triRef.fetchData(ind3[0]);
        int ind4 = triRef.fetchNextData(ind3[0]);
        int i4 = triRef.fetchData(ind4);
        ind1[0] = triRef.fetchPrevData(ind2);
        int i1 = triRef.fetchData(ind1[0]);
        int ind0 = triRef.fetchPrevData(ind1[0]);
        int i0 = triRef.fetchData(ind0);
        if (i1 == i3 || i1 == i2 || i2 == i3 || triRef.getAngle(ind2) == 2) {
            ratio[0] = 0.0;
            return true;
        }
        if (i0 == i3) {
            if (triRef.getAngle(ind0) < 0 || triRef.getAngle(ind3[0]) < 0) {
                ratio[0] = 0.0;
                return true;
            }
            return false;
        }
        if (i1 == i4) {
            if (triRef.getAngle(ind1[0]) < 0 || triRef.getAngle(ind4) < 0) {
                ratio[0] = 0.0;
                return true;
            }
            return false;
        }
        boolean convex = triRef.getAngle(ind1[0]) > 0;
        boolean coneOk = Numerics.isInCone(triRef, i0, i1, i2, i3, convex);
        if (!coneOk) {
            return false;
        }
        convex = triRef.getAngle(ind3[0]) > 0;
        coneOk = Numerics.isInCone(triRef, i2, i3, i4, i1, convex);
        if (coneOk && !NoHash.noHashIntersectionExists(triRef, i2, ind2, i3, i1, bb = new BBox(triRef, i1, i3))) {
            ratio[0] = triRef.earsSorted ? Numerics.getRatio(triRef, i1, i3, i2) : 1.0;
            return true;
        }
        return false;
    }

    static boolean clipEar(Triangulator triRef, boolean[] done) {
        int i3;
        int i1;
        int ind3;
        int ind1;
        double[] ratio = new double[1];
        int[] index0 = new int[1];
        int[] index1 = new int[1];
        int[] index2 = new int[1];
        int[] index3 = new int[1];
        int[] index4 = new int[1];
        int[] ind2 = new int[1];
        boolean testCnt = false;
        do {
            if (!Heap.deleteFromHeap(triRef, ind2, index1, index3)) {
                return false;
            }
            ind1 = triRef.fetchPrevData(ind2[0]);
            i1 = triRef.fetchData(ind1);
            ind3 = triRef.fetchNextData(ind2[0]);
            i3 = triRef.fetchData(ind3);
        } while (index1[0] != ind1 || index3[0] != ind3);
        int i2 = triRef.fetchData(ind2[0]);
        triRef.deleteLinks(ind2[0]);
        triRef.storeTriangle(ind1, ind2[0], ind3);
        int ind0 = triRef.fetchPrevData(ind1);
        int i0 = triRef.fetchData(ind0);
        if (ind0 == ind3) {
            done[0] = true;
            return true;
        }
        int angle1 = Numerics.isConvexAngle(triRef, i0, i1, i3, ind1);
        int ind4 = triRef.fetchNextData(ind3);
        int i4 = triRef.fetchData(ind4);
        int angle3 = Numerics.isConvexAngle(triRef, i1, i3, i4, ind3);
        if (i1 != i3) {
            if (angle1 >= 0 && triRef.getAngle(ind1) < 0) {
                NoHash.deleteReflexVertex(triRef, ind1);
            }
            if (angle3 >= 0 && triRef.getAngle(ind3) < 0) {
                NoHash.deleteReflexVertex(triRef, ind3);
            }
        } else if (angle1 >= 0 && triRef.getAngle(ind1) < 0) {
            NoHash.deleteReflexVertex(triRef, ind1);
        } else if (angle3 >= 0 && triRef.getAngle(ind3) < 0) {
            NoHash.deleteReflexVertex(triRef, ind3);
        }
        triRef.setAngle(ind1, angle1);
        triRef.setAngle(ind3, angle3);
        if (angle1 > 0 && EarClip.isEar(triRef, ind1, index0, index2, ratio)) {
            Heap.insertIntoHeap(triRef, ratio[0], ind1, index0[0], index2[0]);
        }
        if (angle3 > 0 && EarClip.isEar(triRef, ind3, index2, index4, ratio)) {
            Heap.insertIntoHeap(triRef, ratio[0], ind3, index2[0], index4[0]);
        }
        ind0 = triRef.fetchPrevData(ind1);
        i0 = triRef.fetchData(ind0);
        ind4 = triRef.fetchNextData(ind3);
        i4 = triRef.fetchData(ind4);
        if (ind0 == ind4) {
            triRef.storeTriangle(ind1, ind3, ind4);
            done[0] = true;
        } else {
            done[0] = false;
        }
        return true;
    }
}

