/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.controller;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.util.Callback;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import sc.fiji.filamentdetector.FilamentWorkflow;
import sc.fiji.filamentdetector.gui.controller.AbstractController;
import sc.fiji.filamentdetector.kymograph.KymographGenerator;
import sc.fiji.filamentdetector.kymograph.linedrawer.LineDrawer;
import sc.fiji.filamentdetector.kymograph.linedrawer.LongestFilamentLineDrawer;

public class KymographBuilderController
extends AbstractController
implements Initializable {
    private static String FXML_PATH = "/sc/fiji/filamentdetector/gui/view/KymographBuilderView.fxml";
    @Parameter
    private Context context;
    @Parameter
    private LogService log;
    @Parameter
    private StatusService status;
    @FXML
    private Label nTrackedFilamentsField;
    @FXML
    private ComboBox<LineDrawer> lineDrawerCombobox;
    @FXML
    private Label lineDrawerDescription;
    @FXML
    private CheckBox saveCheckbox;
    @FXML
    private CheckBox onlyBuildOneCheckbox;
    @FXML
    private CheckBox showKymographsCheckbox;
    @FXML
    private TextField lineThicknessField;
    @FXML
    private TextField startOffsetField;
    @FXML
    private TextField endOffsetField;
    @FXML
    private CheckBox saveLinesCheckbox;
    private Thread kymographThread;
    private Task<Integer> kymographTask;
    private FilamentWorkflow filamentWorkflow;
    private KymographGenerator kymographGenerator;
    private List<LineDrawer> lineDrawers;

    public KymographBuilderController(Context context, FilamentWorkflow filamentWorkflow) {
        context.inject((Object)this);
        this.setFXMLPath(FXML_PATH);
        this.filamentWorkflow = filamentWorkflow;
        this.kymographGenerator = new KymographGenerator(context);
    }

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.saveCheckbox.setSelected(this.kymographGenerator.getKymographParameters().isSaveKymographs());
        this.onlyBuildOneCheckbox.setSelected(this.kymographGenerator.getKymographParameters().isBuildOneRandomKymograph());
        this.showKymographsCheckbox.setSelected(this.kymographGenerator.getKymographParameters().isShowKymographs());
        this.saveLinesCheckbox.setSelected(this.kymographGenerator.getKymographParameters().isSaveKymographLines());
        this.lineThicknessField.setText(Double.toString(this.kymographGenerator.getKymographParameters().getLineThickness()));
        this.startOffsetField.setText(Double.toString(this.kymographGenerator.getKymographParameters().getStartOffsetLength()));
        this.endOffsetField.setText(Double.toString(this.kymographGenerator.getKymographParameters().getEndOffsetLength()));
        this.lineDrawerCombobox.setCellFactory((Callback)new Callback<ListView<LineDrawer>, ListCell<LineDrawer>>(){

            public ListCell<LineDrawer> call(ListView<LineDrawer> p) {
                return new ListCell<LineDrawer>(){

                    protected void updateItem(LineDrawer t, boolean bln) {
                        super.updateItem((Object)t, bln);
                        if (t != null) {
                            this.setText(t.toString());
                        } else {
                            this.setText(null);
                        }
                    }
                };
            }
        });
        this.lineDrawerCombobox.getSelectionModel().selectedItemProperty().addListener((options, oldValue, newValue) -> {
            if (newValue != null) {
                this.lineDrawerDescription.setText(newValue.getDescription());
            }
        });
        this.lineThicknessField.textProperty().addListener((observable, oldValue, newValue) -> this.updateParameters());
        this.startOffsetField.textProperty().addListener((observable, oldValue, newValue) -> this.updateParameters());
        this.endOffsetField.textProperty().addListener((observable, oldValue, newValue) -> this.updateParameters());
        this.lineDrawers = new ArrayList<LineDrawer>();
        this.lineDrawers.add(new LongestFilamentLineDrawer());
        this.lineDrawerCombobox.setItems(FXCollections.observableList(this.lineDrawers));
        this.lineDrawerCombobox.getSelectionModel().selectFirst();
    }

    public void initPane() {
        if (this.filamentWorkflow.getTrackedFilaments() == null || this.filamentWorkflow.getTrackedFilaments().size() == 0) {
            this.status.showStatus("No tracked filaments detected. Please use the \"Track Filaments\" panel first.");
            this.getPane().setDisable(true);
            this.nTrackedFilamentsField.setText("");
        } else {
            this.getPane().setDisable(false);
            this.nTrackedFilamentsField.setText(Integer.toString(this.filamentWorkflow.getTrackedFilaments().size()));
            this.kymographGenerator.setImageDisplay(this.filamentWorkflow.getImageDisplay());
            this.kymographGenerator.setTrackedFilaments(this.filamentWorkflow.getTrackedFilaments());
        }
    }

    public void updateParameters() {
        this.kymographGenerator.getKymographParameters().setBuildOneRandomKymograph(this.onlyBuildOneCheckbox.isSelected());
        this.kymographGenerator.getKymographParameters().setSaveKymographs(this.saveCheckbox.isSelected());
        this.kymographGenerator.getKymographParameters().setShowKymographs(this.showKymographsCheckbox.isSelected());
        this.kymographGenerator.getKymographParameters().setSaveKymographLines(this.saveLinesCheckbox.isSelected());
        this.kymographGenerator.getKymographParameters().setLineThickness(Double.parseDouble(this.lineThicknessField.getText()));
        this.kymographGenerator.getKymographParameters().setStartOffsetLength(Double.parseDouble(this.startOffsetField.getText()));
        this.kymographGenerator.getKymographParameters().setEndOffsetLength(Double.parseDouble(this.endOffsetField.getText()));
        this.kymographGenerator.getKymographParameters().setLineDrawer((LineDrawer)this.lineDrawerCombobox.getSelectionModel().getSelectedItem());
    }

    @FXML
    void buildKymographs(ActionEvent event) {
        if (this.kymographTask != null) {
            this.kymographTask.cancel();
        }
        if (this.kymographThread != null) {
            this.kymographThread.stop();
        }
        this.kymographTask = new Task<Integer>(){

            protected Integer call() throws Exception {
                KymographBuilderController.this.kymographGenerator.setImageDisplay(KymographBuilderController.this.filamentWorkflow.getImageDisplay());
                KymographBuilderController.this.kymographGenerator.setTrackedFilaments(KymographBuilderController.this.filamentWorkflow.getTrackedFilaments());
                KymographBuilderController.this.kymographGenerator.build();
                return 0;
            }

            protected void succeeded() {
                super.succeeded();
                String statusMessage = KymographBuilderController.this.kymographGenerator.nKymographs() + " kymograph(s) has been generated with the following parameters : ";
                KymographBuilderController.this.status.showStatus(statusMessage);
                KymographBuilderController.this.status.showStatus(KymographBuilderController.this.kymographGenerator.getKymographParameters().toString());
                if (KymographBuilderController.this.kymographGenerator.getKymographParameters().isSaveKymographs()) {
                    if (KymographBuilderController.this.kymographGenerator.kymographsHasBeenSaved()) {
                        KymographBuilderController.this.status.showStatus("Kymographs has been saved in the parent folder of the image.");
                    } else {
                        KymographBuilderController.this.status.showStatus("The parent folder of the image is not set. Please save the image and restart the plugin.");
                    }
                }
            }

            protected void cancelled() {
                super.cancelled();
            }

            protected void failed() {
                super.failed();
                KymographBuilderController.this.status.showStatus("Something failed during kymograph building : ");
                StackTraceElement[] stackTrace = this.getException().getStackTrace();
                KymographBuilderController.this.status.showStatus(Arrays.stream(stackTrace).map(StackTraceElement::toString).collect(Collectors.joining("\n")));
            }
        };
        this.kymographThread = new Thread((Runnable)this.kymographTask);
        this.kymographThread.setDaemon(true);
        this.kymographThread.start();
    }
}

