/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.kymograph;

import ij.gui.Line;
import org.apache.commons.lang3.ArrayUtils;
import sc.fiji.filamentdetector.kymograph.linedrawer.LineDrawer;
import sc.fiji.filamentdetector.model.TrackedFilament;

public class LineGenerator {
    private TrackedFilament trackedFilament;
    private double lineTickness;
    private double startOffsetLength;
    private double endOffsetLength;

    public LineGenerator(double lineTickness, double startOffsetLength, double endOffsetLength) {
        this.lineTickness = lineTickness;
        this.startOffsetLength = startOffsetLength;
        this.endOffsetLength = endOffsetLength;
    }

    public TrackedFilament getTrackedFilament() {
        return this.trackedFilament;
    }

    public void setTrackedFilament(TrackedFilament trackedFilament) {
        this.trackedFilament = trackedFilament;
    }

    public Line build(LineDrawer lineDrawer) throws Exception {
        double[] lineCoords = lineDrawer.draw(this.trackedFilament);
        lineCoords = this.extendTips(lineCoords, this.startOffsetLength, this.endOffsetLength);
        Line line = new Line(lineCoords[0], lineCoords[1], lineCoords[2], lineCoords[3]);
        line.setStrokeWidth(this.lineTickness);
        line.setPosition(-1);
        return line;
    }

    protected double[] extendTips(double[] lineCoords, double startOffsetLength, double endOffsetLength) throws Exception {
        double[] newStart = new double[2];
        double[] newEnd = new double[2];
        newStart = this.extendTip(lineCoords, startOffsetLength);
        double tmp = lineCoords[0];
        lineCoords[0] = lineCoords[2];
        lineCoords[2] = tmp;
        tmp = lineCoords[1];
        lineCoords[1] = lineCoords[3];
        lineCoords[3] = tmp;
        newEnd = this.extendTip(lineCoords, endOffsetLength);
        return ArrayUtils.addAll((double[])newStart, (double[])newEnd);
    }

    protected double[] extendTip(double[] lineCoords, double offsetLength) throws Exception {
        double x0 = lineCoords[0];
        double y0 = lineCoords[1];
        double x1 = lineCoords[2];
        double y1 = lineCoords[3];
        double distanceRatio = this.getDistanceRatio(x0, y0, x1, y1, offsetLength);
        double newX = (1.0 - (distanceRatio *= -1.0)) * x0 + distanceRatio * x1;
        double newY = (1.0 - distanceRatio) * y0 + distanceRatio * y1;
        return new double[]{newX, newY};
    }

    protected double getDistanceRatio(double x0, double y0, double x1, double y1, double offsetLength) {
        double lineLength = Math.sqrt(Math.pow(x0 - x1, 2.0) + Math.pow(y0 - y1, 2.0));
        double newLength = offsetLength;
        return newLength / lineLength;
    }
}

