/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation;

import fiji.util.gui.GenericDialogPlus;
import fiji.util.gui.OverlayedImageCanvas;
import hr.irb.fastRandomForest.FastRandomForest;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.Toolbar;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.process.FloatPolygon;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.AlphaComposite;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import trainableSegmentation.FeatureStack;
import trainableSegmentation.ImageOverlay;
import trainableSegmentation.RoiListOverlay;
import trainableSegmentation.Weka_Segmentation;
import weka.classifiers.AbstractClassifier;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

@Deprecated
public class Trainable_Segmentation
implements PlugIn {
    private final Composite transparency050 = AlphaComposite.getInstance(3, 0.5f);
    private final Composite transparency025 = AlphaComposite.getInstance(3, 0.25f);
    private int overlayOpacity = 33;
    private Composite overlayAlpha = AlphaComposite.getInstance(3, (float)this.overlayOpacity / 100.0f);
    private static final int MAX_NUM_CLASSES = 5;
    private java.util.List<Roi>[] examples = new ArrayList[5];
    private ImagePlus trainingImage;
    private ImagePlus displayImage;
    private ImagePlus classifiedImage;
    private FeatureStack featureStack = null;
    private CustomWindow win;
    private int[] traceCounter = new int[5];
    private boolean showColorOverlay;
    private Instances wholeImageData;
    private Instances loadedTrainingData;
    private AbstractClassifier classifier = null;
    private FastRandomForest rf;
    private boolean updateWholeData = true;
    private JButton trainButton;
    private JButton overlayButton;
    private JButton resultButton;
    private JButton applyButton;
    private JButton probimgButton;
    private JButton loadDataButton;
    private JButton saveDataButton;
    private JButton settingsButton;
    private JButton addClassButton;
    private RoiListOverlay[] roiOverlay;
    private ImageOverlay resultOverlay;
    private final Color[] colors = new Color[]{Color.red, Color.green, Color.blue, Color.cyan, Color.magenta};
    private String[] classLabels = new String[]{"class 1", "class 2", "class 3", "class 4", "class 5"};
    private LUT overlayLUT;
    private int numOfClasses = 2;
    private List[] exampleList;
    private JButton[] addExampleButton;
    private int numOfTrees = 200;
    private int randomFeatures = 2;
    private ArrayList<String> loadedClassNames = null;
    private final ExecutorService exec = Executors.newFixedThreadPool(1);
    private boolean useGUI = true;
    private ActionListener listener = new ActionListener(){

        @Override
        public void actionPerformed(final ActionEvent e) {
            Trainable_Segmentation.this.exec.submit(new Runnable(){

                @Override
                public void run() {
                    if (e.getSource() == Trainable_Segmentation.this.trainButton) {
                        try {
                            Trainable_Segmentation.this.trainClassifier();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    } else if (e.getSource() == Trainable_Segmentation.this.overlayButton) {
                        Trainable_Segmentation.this.toggleOverlay();
                    } else if (e.getSource() == Trainable_Segmentation.this.resultButton) {
                        Trainable_Segmentation.this.showClassificationImage();
                    } else if (e.getSource() == Trainable_Segmentation.this.applyButton) {
                        Trainable_Segmentation.this.applyClassifierToTestData();
                    } else if (e.getSource() == Trainable_Segmentation.this.probimgButton) {
                        Trainable_Segmentation.this.createProbImgFromTestData();
                    } else if (e.getSource() == Trainable_Segmentation.this.loadDataButton) {
                        Trainable_Segmentation.this.loadTrainingData();
                    } else if (e.getSource() == Trainable_Segmentation.this.saveDataButton) {
                        Trainable_Segmentation.this.saveTrainingData();
                    } else if (e.getSource() == Trainable_Segmentation.this.addClassButton) {
                        Trainable_Segmentation.this.addNewClass();
                    } else if (e.getSource() == Trainable_Segmentation.this.settingsButton) {
                        Trainable_Segmentation.this.showSettingsDialog();
                    } else {
                        for (int i = 0; i < Trainable_Segmentation.this.numOfClasses; ++i) {
                            if (e.getSource() == Trainable_Segmentation.this.exampleList[i]) {
                                Trainable_Segmentation.this.deleteSelected(e);
                                break;
                            }
                            if (e.getSource() != Trainable_Segmentation.this.addExampleButton[i]) continue;
                            Trainable_Segmentation.this.addExamples(i);
                            break;
                        }
                    }
                }
            });
        }
    };
    private ItemListener itemListener = new ItemListener(){

        @Override
        public void itemStateChanged(final ItemEvent e) {
            Trainable_Segmentation.this.exec.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < Trainable_Segmentation.this.numOfClasses; ++i) {
                        if (e.getSource() != Trainable_Segmentation.this.exampleList[i]) continue;
                        Trainable_Segmentation.this.listSelected(e, i);
                    }
                }
            });
        }
    };

    public Trainable_Segmentation() {
        int i;
        this.useGUI = true;
        byte[] red = new byte[256];
        byte[] green = new byte[256];
        byte[] blue = new byte[256];
        int shift = 51;
        for (i = 0; i < 256; ++i) {
            int colorIndex = i / 52;
            red[i] = (byte)this.colors[colorIndex].getRed();
            green[i] = (byte)this.colors[colorIndex].getGreen();
            blue[i] = (byte)this.colors[colorIndex].getBlue();
        }
        this.overlayLUT = new LUT(red, green, blue);
        this.exampleList = new List[5];
        this.addExampleButton = new JButton[5];
        this.roiOverlay = new RoiListOverlay[5];
        this.resultOverlay = new ImageOverlay();
        this.trainButton = new JButton("Train classifier");
        this.trainButton.setToolTipText("Start training the classifier");
        this.overlayButton = new JButton("Toggle overlay");
        this.overlayButton.setToolTipText("Toggle between current segmentation and original image");
        this.overlayButton.setEnabled(false);
        this.resultButton = new JButton("Create result");
        this.resultButton.setToolTipText("Generate result image");
        this.resultButton.setEnabled(false);
        this.applyButton = new JButton("Apply classifier");
        this.applyButton.setToolTipText("Load data and apply current classifier");
        this.applyButton.setEnabled(false);
        this.probimgButton = new JButton("Create probability image");
        this.probimgButton.setToolTipText("Instead of creating a segmentation, create a multi-channel image containing the probabilities for each class");
        this.probimgButton.setEnabled(false);
        this.loadDataButton = new JButton("Load data");
        this.loadDataButton.setToolTipText("Load previous segmentation from an ARFF file");
        this.saveDataButton = new JButton("Save data");
        this.saveDataButton.setToolTipText("Save current segmentation into an ARFF file");
        this.addClassButton = new JButton("Create new class");
        this.addClassButton.setToolTipText("Add one more label to mark different areas");
        this.settingsButton = new JButton("Settings");
        this.settingsButton.setToolTipText("Display settings dialog");
        for (i = 0; i < this.numOfClasses; ++i) {
            this.examples[i] = new ArrayList<Roi>();
            this.exampleList[i] = new List(5);
            this.exampleList[i].setForeground(this.colors[i]);
        }
        this.showColorOverlay = false;
        this.rf = new FastRandomForest();
        this.rf.setNumTrees(this.numOfTrees);
        this.rf.setNumFeatures(this.randomFeatures);
        this.rf.setSeed(123);
        this.classifier = this.rf;
    }

    public void run(String arg) {
        if (null == WindowManager.getCurrentImage()) {
            this.trainingImage = IJ.openImage();
            if (null == this.trainingImage) {
                return;
            }
        } else {
            this.trainingImage = new ImagePlus("Trainable Segmentation", WindowManager.getCurrentImage().getProcessor().duplicate());
        }
        if (Math.max(this.trainingImage.getWidth(), this.trainingImage.getHeight()) > 1024 && !IJ.showMessageWithCancel((String)"Warning", (String)"At least one dimension of the image \nis larger than 1024 pixels. \nFeature stack creation and classifier training \nmight take some time depending on your computer.\nProceed?")) {
            return;
        }
        this.trainingImage.setProcessor("Trainable Segmentation", this.trainingImage.getProcessor().duplicate().convertToByte(true));
        this.featureStack = new FeatureStack(this.trainingImage);
        this.displayImage = new ImagePlus();
        this.displayImage.setProcessor("Trainable Segmentation", this.trainingImage.getProcessor().duplicate());
        Toolbar.getInstance().setTool(6);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Trainable_Segmentation.this.win = new CustomWindow(Trainable_Segmentation.this.displayImage);
                Trainable_Segmentation.this.win.pack();
            }
        });
    }

    private void setButtonsEnabled(Boolean s) {
        if (this.useGUI) {
            this.trainButton.setEnabled(s);
            this.overlayButton.setEnabled(s);
            this.resultButton.setEnabled(s);
            this.applyButton.setEnabled(s);
            this.probimgButton.setEnabled(s);
            this.loadDataButton.setEnabled(s);
            this.saveDataButton.setEnabled(s);
            this.addClassButton.setEnabled(s);
            this.settingsButton.setEnabled(s);
            for (int i = 0; i < this.numOfClasses; ++i) {
                this.exampleList[i].setEnabled(s);
                this.addExampleButton[i].setEnabled(s);
            }
        }
    }

    private void addExamples(int i) {
        Roi r = this.displayImage.getRoi();
        if (null == r) {
            return;
        }
        this.displayImage.killRoi();
        this.examples[i].add(r);
        this.exampleList[i].add("trace " + this.traceCounter[i]);
        int n = i;
        this.traceCounter[n] = this.traceCounter[n] + 1;
        this.drawExamples();
    }

    private void drawExamples() {
        for (int i = 0; i < this.numOfClasses; ++i) {
            this.roiOverlay[i].setColor(this.colors[i]);
            ArrayList<Roi> rois = new ArrayList<Roi>();
            for (Roi r : this.examples[i]) {
                rois.add(r);
            }
            this.roiOverlay[i].setRoi(rois);
        }
        this.displayImage.updateAndDraw();
    }

    public void writeDataToARFF(Instances data, String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));
            try {
                out.write(data.toString());
                out.close();
            }
            catch (IOException e) {
                IJ.showMessage((String)"IOException");
            }
        }
        catch (FileNotFoundException e) {
            IJ.showMessage((String)"File not found!");
        }
    }

    public Instances readDataFromARFF(String filename) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), StandardCharsets.UTF_8));
            try {
                Instances data = new Instances((Reader)reader);
                data.setClassIndex(data.numAttributes() - 1);
                reader.close();
                return data;
            }
            catch (IOException e) {
                IJ.showMessage((String)"IOException");
            }
        }
        catch (FileNotFoundException e) {
            IJ.showMessage((String)"File not found!");
        }
        return null;
    }

    public Instances createTrainingInstances() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int i = 1; i <= this.featureStack.getSize(); ++i) {
            String attString = this.featureStack.getSliceLabel(i);
            attributes.add(new Attribute(attString));
        }
        ArrayList<String> classes = new ArrayList<String>();
        int numOfInstances = 0;
        for (int i = 0; i < this.numOfClasses; ++i) {
            if (!this.examples[i].isEmpty()) {
                classes.add(this.classLabels[i]);
            }
            numOfInstances += this.examples[i].size();
        }
        attributes.add(new Attribute("class", classes));
        Instances trainingData = new Instances("segment", attributes, numOfInstances);
        IJ.log((String)"\nTraining input:");
        for (int l = 0; l < this.numOfClasses; ++l) {
            int nl = 0;
            for (int j = 0; j < this.examples[l].size(); ++j) {
                Roi r = this.examples[l].get(j);
                if (r instanceof PolygonRoi && r.getType() != 3) {
                    int n;
                    if (r.getStrokeWidth() == 1.0f) {
                        int[] x = r.getPolygon().xpoints;
                        int[] y = r.getPolygon().ypoints;
                        n = r.getPolygon().npoints;
                        for (int i = 0; i < n; ++i) {
                            double[] values = new double[this.featureStack.getSize() + 1];
                            for (int z = 1; z <= this.featureStack.getSize(); ++z) {
                                values[z - 1] = this.featureStack.getProcessor(z).getPixelValue(x[i], y[i]);
                            }
                            values[this.featureStack.getSize()] = l;
                            trainingData.add((Instance)new DenseInstance(1.0, values));
                            ++nl;
                        }
                        continue;
                    }
                    int width = Math.round(r.getStrokeWidth());
                    FloatPolygon p = r.getFloatPolygon();
                    n = p.npoints;
                    double x2 = p.xpoints[0] - (p.xpoints[1] - p.xpoints[0]);
                    double y2 = p.ypoints[0] - (p.ypoints[1] - p.ypoints[0]);
                    for (int i = 0; i < n; ++i) {
                        double x1 = x2;
                        double y1 = y2;
                        x2 = p.xpoints[i];
                        y2 = p.ypoints[i];
                        double dx = x2 - x1;
                        double dy = y1 - y2;
                        double length = (float)Math.sqrt(dx * dx + dy * dy);
                        double x = x2 - (dy /= length) * (double)width / 2.0;
                        double y = y2 - (dx /= length) * (double)width / 2.0;
                        int n2 = width;
                        do {
                            if (x >= 0.0 && x < (double)this.featureStack.getWidth() && y >= 0.0 && y < (double)this.featureStack.getHeight()) {
                                double[] values = new double[this.featureStack.getSize() + 1];
                                for (int z = 1; z <= this.featureStack.getSize(); ++z) {
                                    values[z - 1] = this.featureStack.getProcessor(z).getInterpolatedValue(x, y);
                                }
                                values[this.featureStack.getSize()] = l;
                                trainingData.add((Instance)new DenseInstance(1.0, values));
                                ++nl;
                            }
                            x += dy;
                            y += dx;
                        } while (--n2 > 0);
                    }
                    continue;
                }
                ShapeRoi shapeRoi = new ShapeRoi(r);
                Rectangle rect = shapeRoi.getBounds();
                int lastX = rect.x + rect.width;
                int lastY = rect.y + rect.height;
                for (int x = rect.x; x < lastX; ++x) {
                    for (int y = rect.y; y < lastY; ++y) {
                        if (!shapeRoi.contains(x, y)) continue;
                        double[] values = new double[this.featureStack.getSize() + 1];
                        for (int z = 1; z <= this.featureStack.getSize(); ++z) {
                            values[z - 1] = this.featureStack.getProcessor(z).getPixelValue(x, y);
                        }
                        values[this.featureStack.getSize()] = l;
                        trainingData.add((Instance)new DenseInstance(1.0, values));
                        ++nl;
                    }
                }
            }
            IJ.log((String)("# of pixels selected as " + this.classLabels[l] + ": " + nl));
        }
        return trainingData;
    }

    public void trainClassifier() {
        long end;
        int nonEmpty = 0;
        for (int i = 0; i < this.numOfClasses; ++i) {
            if (this.examples[i].isEmpty()) continue;
            ++nonEmpty;
        }
        if (nonEmpty < 2 && this.loadedTrainingData == null) {
            IJ.showMessage((String)"Cannot train without at least 2 sets of examples!");
            return;
        }
        this.setButtonsEnabled(false);
        if (this.featureStack.isEmpty()) {
            IJ.showStatus((String)"Creating feature stack...");
            this.featureStack.updateFeaturesMT();
        }
        IJ.showStatus((String)"Training classifier...");
        Instances data = null;
        if (nonEmpty < 2) {
            IJ.log((String)"Training from loaded data only...");
        } else {
            long start = System.currentTimeMillis();
            data = this.createTrainingInstances();
            end = System.currentTimeMillis();
            IJ.log((String)("Creating training data took: " + (end - start) + "ms"));
            data.setClassIndex(data.numAttributes() - 1);
        }
        if (this.loadedTrainingData != null && data != null) {
            IJ.log((String)"Merging data...");
            for (int i = 0; i < this.loadedTrainingData.numInstances(); ++i) {
                data.add(this.loadedTrainingData.instance(i));
            }
            IJ.log((String)"Finished");
        } else if (data == null) {
            data = this.loadedTrainingData;
            IJ.log((String)"Taking loaded data as only data...");
        }
        IJ.showStatus((String)"Training classifier...");
        IJ.log((String)"Training classifier...");
        if (null == data) {
            IJ.log((String)"WTF");
        }
        long start = System.currentTimeMillis();
        try {
            this.classifier.buildClassifier(data);
        }
        catch (Exception e) {
            IJ.showMessage((String)e.getMessage());
            e.printStackTrace();
            return;
        }
        end = System.currentTimeMillis();
        DecimalFormat df = new DecimalFormat("0.0000");
        String outOfBagError = this.rf != null ? ", out of bag error: " + df.format(this.rf.measureOutOfBagError()) : "";
        IJ.log((String)("Finished training in " + (end - start) + "ms" + outOfBagError));
        if (this.updateWholeData) {
            this.updateTestSet();
            IJ.log((String)("Test dataset updated (" + this.wholeImageData.numInstances() + " instances, " + this.wholeImageData.numAttributes() + " attributes)."));
        }
        IJ.log((String)"Classifying whole image...");
        this.classifiedImage = this.applyClassifier(this.wholeImageData, this.trainingImage.getWidth(), this.trainingImage.getHeight(), Runtime.getRuntime().availableProcessors());
        IJ.log((String)"Finished segmentation of whole image.");
        if (this.useGUI) {
            this.overlayButton.setEnabled(true);
            this.resultButton.setEnabled(true);
            this.applyButton.setEnabled(true);
            this.probimgButton.setEnabled(true);
            this.showColorOverlay = false;
            this.toggleOverlay();
            this.setButtonsEnabled(true);
        }
    }

    private void updateTestSet() {
        IJ.showStatus((String)"Reading whole image data...");
        long start = System.currentTimeMillis();
        ArrayList<String> classNames = null;
        if (this.loadedTrainingData != null) {
            classNames = this.loadedClassNames;
        } else {
            classNames = new ArrayList();
            for (int i = 0; i < this.numOfClasses; ++i) {
                if (this.examples[i].isEmpty()) continue;
                classNames.add(this.classLabels[i]);
            }
        }
        this.wholeImageData = this.featureStack.createInstances(classNames);
        long end = System.currentTimeMillis();
        IJ.log((String)("Creating whole image data took: " + (end - start) + "ms"));
        this.wholeImageData.setClassIndex(this.wholeImageData.numAttributes() - 1);
        this.updateWholeData = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImagePlus applyClassifier(final Instances data, int w, int h, int numThreads) {
        IJ.log((String)("Applying classifier in " + numThreads + " threads..."));
        IJ.showStatus((String)"Classifying image...");
        long start = System.currentTimeMillis();
        ExecutorService exe = Executors.newFixedThreadPool(numThreads);
        double[][] results = new double[numThreads][];
        Instances[] partialData = new Instances[numThreads];
        int partialSize = data.numInstances() / numThreads;
        Future[] fu = new Future[numThreads];
        final AtomicInteger counter = new AtomicInteger();
        for (int i = 0; i < numThreads; ++i) {
            partialData[i] = i == numThreads - 1 ? new Instances(data, i * partialSize, data.numInstances() - i * partialSize) : new Instances(data, i * partialSize, partialSize);
            fu[i] = exe.submit(Trainable_Segmentation.classifyIntances(partialData[i], this.classifier, counter));
        }
        ScheduledExecutorService monitor = Executors.newScheduledThreadPool(1);
        ScheduledFuture<?> task = monitor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                IJ.showProgress((int)counter.get(), (int)data.numInstances());
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        for (int i = 0; i < numThreads; ++i) {
            try {
                results[i] = (double[])fu[i].get();
                continue;
            }
            catch (InterruptedException e) {
                IJ.log((String)"Interruption exception");
                e.printStackTrace();
                ImagePlus imagePlus = null;
                return imagePlus;
            }
            catch (ExecutionException e) {
                IJ.log((String)"Execution exception");
                e.printStackTrace();
                ImagePlus imagePlus = null;
                return imagePlus;
            }
            finally {
                exe.shutdown();
                task.cancel(true);
                monitor.shutdownNow();
                IJ.showProgress((double)1.0);
            }
        }
        exe.shutdown();
        double[] classificationResult = new double[data.numInstances()];
        for (int i = 0; i < numThreads; ++i) {
            System.arraycopy(results[i], 0, classificationResult, i * partialSize, results[i].length);
        }
        IJ.showProgress((double)1.0);
        long end = System.currentTimeMillis();
        IJ.log((String)("Classifying whole image data took: " + (end - start) + "ms"));
        IJ.showStatus((String)"Displaying result...");
        FloatProcessor classifiedImageProcessor = new FloatProcessor(w, h, classificationResult);
        classifiedImageProcessor.convertToByte(true);
        ImagePlus classImg = new ImagePlus("Classification result", (ImageProcessor)classifiedImageProcessor);
        return classImg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImagePlus[] getClassifierDistribution(final Instances data, int w, int h, int numThreads) {
        IJ.log((String)("Calculating probability distribution in " + numThreads + " threads..."));
        long start = System.currentTimeMillis();
        ExecutorService exe = Executors.newFixedThreadPool(numThreads);
        double[][][] results = new double[numThreads][][];
        Instances[] partialData = new Instances[numThreads];
        int partialSize = data.numInstances() / numThreads;
        Future[] fu = new Future[numThreads];
        final AtomicInteger counter = new AtomicInteger();
        for (int i = 0; i < numThreads; ++i) {
            partialData[i] = i == numThreads - 1 ? new Instances(data, i * partialSize, data.numInstances() - i * partialSize) : new Instances(data, i * partialSize, partialSize);
            fu[i] = exe.submit(Trainable_Segmentation.probFromInstances(partialData[i], this.classifier, counter));
        }
        ScheduledExecutorService monitor = Executors.newScheduledThreadPool(1);
        ScheduledFuture<?> task = monitor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                IJ.showProgress((int)counter.get(), (int)data.numInstances());
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        for (int i = 0; i < numThreads; ++i) {
            try {
                results[i] = (double[][])fu[i].get();
                continue;
            }
            catch (InterruptedException e) {
                IJ.log((String)"Interruption exception");
                e.printStackTrace();
                ImagePlus[] imagePlusArray = null;
                return imagePlusArray;
            }
            catch (ExecutionException e) {
                IJ.log((String)"Execution exception");
                e.printStackTrace();
                ImagePlus[] imagePlusArray = null;
                return imagePlusArray;
            }
            finally {
                exe.shutdown();
                task.cancel(true);
                monitor.shutdownNow();
                IJ.showProgress((double)1.0);
            }
        }
        exe.shutdown();
        double[][] probDistribution = new double[this.numOfClasses][data.numInstances()];
        for (int c = 0; c < this.numOfClasses; ++c) {
            for (int i = 0; i < numThreads; ++i) {
                System.arraycopy(results[i][c], 0, probDistribution[c], i * partialSize, results[i][c].length);
            }
        }
        IJ.showProgress((double)1.0);
        long end = System.currentTimeMillis();
        IJ.log((String)("Probability distribution for whole image data took: " + (end - start) + "ms"));
        IJ.showStatus((String)"Displaying result...");
        ImagePlus[] classImgs = new ImagePlus[this.numOfClasses];
        for (int c = 0; c < this.numOfClasses; ++c) {
            FloatProcessor classifiedImageProcessor = new FloatProcessor(w, h, probDistribution[c]);
            classifiedImageProcessor.convertToByte(true);
            classImgs[c] = new ImagePlus("Classification result", (ImageProcessor)classifiedImageProcessor);
        }
        return classImgs;
    }

    private static Callable<double[]> classifyIntances(final Instances data, final AbstractClassifier classifier, final AtomicInteger counter) {
        return new Callable<double[]>(){

            @Override
            public double[] call() {
                int numInstances = data.numInstances();
                double[] classificationResult = new double[numInstances];
                for (int i = 0; i < numInstances; ++i) {
                    try {
                        if (0 == i % 4000) {
                            counter.addAndGet(4000);
                        }
                        classificationResult[i] = classifier.classifyInstance(data.instance(i));
                        continue;
                    }
                    catch (Exception e) {
                        IJ.showMessage((String)"Could not apply Classifier!");
                        e.printStackTrace();
                        return null;
                    }
                }
                return classificationResult;
            }
        };
    }

    private static Callable<double[][]> probFromInstances(final Instances data, final AbstractClassifier classifier, final AtomicInteger counter) {
        return new Callable<double[][]>(){

            @Override
            public double[][] call() {
                int numInstances = data.numInstances();
                int numOfClasses = data.numClasses();
                double[][] probabilityDistribution = new double[numOfClasses][numInstances];
                for (int i = 0; i < numInstances; ++i) {
                    try {
                        if (0 == i % 4000) {
                            counter.addAndGet(4000);
                        }
                        double[] probs = classifier.distributionForInstance(data.instance(i));
                        for (int c = 0; c < numOfClasses; ++c) {
                            probabilityDistribution[c][i] = probs[c];
                        }
                        continue;
                    }
                    catch (Exception e) {
                        IJ.showMessage((String)"Could not apply Classifier!");
                        e.printStackTrace();
                        return null;
                    }
                }
                return probabilityDistribution;
            }
        };
    }

    void toggleOverlay() {
        boolean bl = this.showColorOverlay = !this.showColorOverlay;
        if (this.showColorOverlay) {
            ImageProcessor overlay = this.classifiedImage.getProcessor().duplicate();
            double shift = 51.0;
            overlay.multiply(shift + 1.0);
            overlay = overlay.convertToByte(false);
            overlay.setColorModel((ColorModel)this.overlayLUT);
            this.resultOverlay.setImage(overlay);
        } else {
            this.resultOverlay.setImage(null);
        }
        this.displayImage.updateAndDraw();
    }

    void listSelected(ItemEvent e, int i) {
        this.drawExamples();
        this.displayImage.setColor(Color.YELLOW);
        for (int j = 0; j < this.numOfClasses; ++j) {
            if (j == i) {
                Roi newRoi = this.examples[i].get(this.exampleList[i].getSelectedIndex());
                newRoi.setImage(this.displayImage);
                this.displayImage.setRoi(newRoi);
                continue;
            }
            this.exampleList[j].deselect(this.exampleList[j].getSelectedIndex());
        }
        this.displayImage.updateAndDraw();
    }

    void deleteSelected(ActionEvent e) {
        for (int i = 0; i < this.numOfClasses; ++i) {
            if (e.getSource() != this.exampleList[i]) continue;
            int index = this.exampleList[i].getSelectedIndex();
            if (this.displayImage.getRoi().equals((Object)this.examples[i].get(index))) {
                this.displayImage.killRoi();
            }
            this.examples[i].remove(index);
            this.exampleList[i].remove(index);
        }
        this.drawExamples();
    }

    void showClassificationImage() {
        ImagePlus resultImage = new ImagePlus("classification result", this.classifiedImage.getProcessor().convertToByte(true).duplicate());
        resultImage.show();
    }

    public void applyClassifierToTestData() {
        int decision;
        JFileChooser fileChooser = new JFileChooser("/home/jan/workspace/mpi/yolk/data/downsampled/2010-04-02 histon");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(true);
        int returnVal = fileChooser.showOpenDialog(null);
        if (returnVal != 0) {
            return;
        }
        File[] imageFiles = fileChooser.getSelectedFiles();
        boolean showResults = true;
        boolean storeResults = false;
        if (imageFiles.length >= 3 && (decision = JOptionPane.showConfirmDialog(null, "You decided to process three or more image files. Do you want the results to be stored on the disk instead of opening them in Fiji?", "Save results?", 0)) == 0) {
            showResults = false;
            storeResults = true;
        }
        int numProcessors = Runtime.getRuntime().availableProcessors();
        IJ.log((String)("Processing " + imageFiles.length + " image files in " + numProcessors + " threads...."));
        this.setButtonsEnabled(false);
        Thread[] threads = new Thread[numProcessors];
        int numFurtherThreads = Math.max(1, (numProcessors - imageFiles.length) / imageFiles.length + 1);
        for (int i = 0; i < numProcessors; ++i) {
            class ImageProcessingThread
            extends Thread {
                private final int numThread;
                private final int numProcessors;
                private final int numFurtherThreads;
                private final File[] imageFiles;
                private final boolean storeResults;
                private final boolean showResults;

                public ImageProcessingThread(int numThread, int numProcessors, int numFurtherThreads, File[] imageFiles, boolean storeResults, boolean showResults) {
                    this.numThread = numThread;
                    this.numProcessors = numProcessors;
                    this.numFurtherThreads = numFurtherThreads;
                    this.imageFiles = imageFiles;
                    this.storeResults = storeResults;
                    this.showResults = showResults;
                }

                @Override
                public void run() {
                    for (int i = this.numThread; i < this.imageFiles.length; i += this.numProcessors) {
                        File file = this.imageFiles[i];
                        ImagePlus testImage = IJ.openImage((String)file.getPath());
                        IJ.log((String)("Processing image " + file.getName() + " in thread " + this.numThread));
                        ImagePlus segmentation = Trainable_Segmentation.this.applyClassifierToTestImage(testImage, this.numFurtherThreads);
                        if (this.showResults) {
                            segmentation.show();
                            testImage.show();
                        }
                        if (!this.storeResults) continue;
                        IJ.save((ImagePlus)segmentation, (String)(file.getPath() + "seg.tif"));
                        segmentation.close();
                        testImage.close();
                    }
                }
            }
            threads[i] = new ImageProcessingThread(i, numProcessors, numFurtherThreads, imageFiles, storeResults, showResults);
            threads[i].start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setButtonsEnabled(true);
    }

    public void createProbImgFromTestData() {
        int decision;
        JFileChooser fileChooser = new JFileChooser("/home/jan/workspace/mpi/yolk/data/downsampled/2010-04-02 histon");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(true);
        int returnVal = fileChooser.showOpenDialog(null);
        if (returnVal != 0) {
            return;
        }
        File[] imageFiles = fileChooser.getSelectedFiles();
        boolean showResults = true;
        boolean storeResults = false;
        if (imageFiles.length >= 3 && (decision = JOptionPane.showConfirmDialog(null, "You decided to process three or more image files. Do you want the results to be stored on the disk instead of opening them in Fiji?", "Save results?", 0)) == 0) {
            showResults = false;
            storeResults = true;
        }
        int numProcessors = Runtime.getRuntime().availableProcessors();
        IJ.log((String)("Processing " + imageFiles.length + " image files in " + numProcessors + " threads...."));
        this.setButtonsEnabled(false);
        Thread[] threads = new Thread[numProcessors];
        int numFurtherThreads = Math.max(1, (numProcessors - imageFiles.length) / imageFiles.length + 1);
        for (int i = 0; i < numProcessors; ++i) {
            class ImageProcessingThread
            extends Thread {
                private final int numThread;
                private final int numProcessors;
                private final int numFurtherThreads;
                private final File[] imageFiles;
                private final boolean storeResults;
                private final boolean showResults;

                public ImageProcessingThread(int numThread, int numProcessors, int numFurtherThreads, File[] imageFiles, boolean storeResults, boolean showResults) {
                    this.numThread = numThread;
                    this.numProcessors = numProcessors;
                    this.numFurtherThreads = numFurtherThreads;
                    this.imageFiles = imageFiles;
                    this.storeResults = storeResults;
                    this.showResults = showResults;
                }

                @Override
                public void run() {
                    for (int i = this.numThread; i < this.imageFiles.length; i += this.numProcessors) {
                        File file = this.imageFiles[i];
                        ImagePlus testImage = IJ.openImage((String)file.getPath());
                        IJ.log((String)("Processing image " + file.getName() + " in thread " + this.numThread));
                        ImagePlus probImage = Trainable_Segmentation.this.createProbImgFromTestData(testImage, this.numFurtherThreads);
                        if (this.showResults) {
                            probImage.show();
                            testImage.show();
                        }
                        if (!this.storeResults) continue;
                        IJ.save((ImagePlus)probImage, (String)(file.getPath() + "prob.tif"));
                        probImage.close();
                        testImage.close();
                    }
                }
            }
            threads[i] = new ImageProcessingThread(i, numProcessors, numFurtherThreads, imageFiles, storeResults, showResults);
            threads[i].start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setButtonsEnabled(true);
    }

    public ImagePlus applyClassifierToTestImage(final ImagePlus testImage, int numThreads) {
        IJ.log((String)("Processing slices of " + testImage.getTitle() + " in " + numThreads + " threads..."));
        ArrayList<Object> classNames = new ArrayList();
        if (null == this.loadedClassNames) {
            for (int i = 0; i < this.numOfClasses; ++i) {
                if (this.examples[i].isEmpty()) continue;
                classNames.add(this.classLabels[i]);
            }
        } else {
            classNames = this.loadedClassNames;
        }
        final ImagePlus[] classifiedSlices = new ImagePlus[testImage.getStackSize()];
        int numFurtherThreads = Math.max(1, (numThreads - testImage.getStackSize()) / testImage.getStackSize() + 1);
        class ApplyClassifierThread
        extends Thread {
            private final int startSlice;
            private final int numSlices;
            private final int numFurtherThreads;
            private final ArrayList<String> classNames;

            public ApplyClassifierThread(int startSlice, int numSlices, int numFurtherThreads, ArrayList<String> classNames) {
                this.startSlice = startSlice;
                this.numSlices = numSlices;
                this.numFurtherThreads = numFurtherThreads;
                this.classNames = classNames;
            }

            @Override
            public void run() {
                for (int i = this.startSlice; i < this.startSlice + this.numSlices; ++i) {
                    ImagePlus testSlice = new ImagePlus(testImage.getImageStack().getSliceLabel(i), testImage.getImageStack().getProcessor(i).convertToByte(true));
                    IJ.showStatus((String)"Creating features...");
                    IJ.log((String)("Creating features for slice " + i + "..."));
                    FeatureStack testImageFeatures = new FeatureStack(testSlice);
                    testImageFeatures.setEnabledFeatures(featureStack.getEnabledFeatures());
                    testImageFeatures.updateFeaturesMT();
                    Instances testData = testImageFeatures.createInstances(this.classNames);
                    ImagePlus testClassImage = this.applyClassifier(testData, testSlice.getWidth(), testSlice.getHeight(), this.numFurtherThreads);
                    testClassImage.setTitle("classified_" + testSlice.getTitle());
                    testClassImage.setProcessor(testClassImage.getProcessor().convertToByte(true).duplicate());
                    classifiedSlices[i - 1] = testClassImage;
                }
            }
        }
        ApplyClassifierThread[] threads = new ApplyClassifierThread[numThreads];
        int numSlices = testImage.getStackSize() / numThreads;
        for (int i = 0; i < numThreads; ++i) {
            int startSlice = i * numSlices + 1;
            if (i == numThreads - 1) {
                numSlices = testImage.getStackSize() - (numThreads - 1) * (testImage.getStackSize() / numThreads);
            }
            IJ.log((String)("Starting thread " + i + " processing " + numSlices + " slices, starting with " + startSlice));
            threads[i] = new ApplyClassifierThread(startSlice, numSlices, numFurtherThreads, classNames);
            threads[i].start();
        }
        ImageStack classified = new ImageStack(testImage.getWidth(), testImage.getHeight());
        for (ApplyClassifierThread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < testImage.getStackSize(); ++i) {
            classified.addSlice(classifiedSlices[i].getTitle(), classifiedSlices[i].getProcessor());
        }
        return new ImagePlus("Classification result", classified);
    }

    public ImagePlus createProbImgFromTestData(final ImagePlus testImage, int numThreads) {
        IJ.log((String)("Processing slices of " + testImage.getTitle() + " in " + numThreads + " threads..."));
        ArrayList<Object> classNames = new ArrayList();
        if (null == this.loadedClassNames) {
            for (int i = 0; i < this.numOfClasses; ++i) {
                if (this.examples[i].isEmpty()) continue;
                classNames.add(this.classLabels[i]);
            }
        } else {
            classNames = this.loadedClassNames;
        }
        int numFurtherThreads = Math.max(1, (numThreads - testImage.getStackSize()) / testImage.getStackSize() + 1);
        final ImagePlus[] probSlices = new ImagePlus[testImage.getStackSize() * this.numOfClasses];
        class ProbImageThread
        extends Thread {
            private final int startSlice;
            private final int numSlices;
            private final int numFurtherThreads;
            private final ArrayList<String> classNames;

            public ProbImageThread(int startSlice, int numSlices, int numFurtherThreads, ArrayList<String> classNames) {
                this.startSlice = startSlice;
                this.numSlices = numSlices;
                this.numFurtherThreads = numFurtherThreads;
                this.classNames = classNames;
            }

            @Override
            public void run() {
                for (int i = this.startSlice; i < this.startSlice + this.numSlices; ++i) {
                    ImagePlus testSlice = new ImagePlus(testImage.getImageStack().getSliceLabel(i), testImage.getImageStack().getProcessor(i).convertToByte(true));
                    IJ.showStatus((String)"Creating features for test image...");
                    IJ.log((String)("Creating features for test image " + i + "..."));
                    FeatureStack testImageFeatures = new FeatureStack(testSlice);
                    testImageFeatures.setEnabledFeatures(featureStack.getEnabledFeatures());
                    testImageFeatures.updateFeaturesST();
                    Instances testData = testImageFeatures.createInstances(this.classNames);
                    testData.setClassIndex(testData.numAttributes() - 1);
                    ImagePlus[] testClassImages = this.getClassifierDistribution(testData, testSlice.getWidth(), testSlice.getHeight(), this.numFurtherThreads);
                    for (int c = 0; c < numOfClasses; ++c) {
                        probSlices[(i - 1) * ((Trainable_Segmentation)this).numOfClasses + c] = testClassImages[c];
                    }
                }
            }
        }
        ProbImageThread[] threads = new ProbImageThread[numThreads];
        int numSlices = testImage.getStackSize() / numThreads;
        for (int i = 0; i < numThreads; ++i) {
            int startSlice = i * numSlices + 1;
            if (i == numThreads - 1) {
                numSlices = testImage.getStackSize() - (numThreads - 1) * (testImage.getStackSize() / numThreads);
            }
            IJ.log((String)("Starting thread " + i + " processing " + numSlices + " slices, starting with " + startSlice));
            threads[i] = new ProbImageThread(startSlice, numSlices, numFurtherThreads, classNames);
            threads[i].start();
        }
        ImageStack probStack = new ImageStack(testImage.getWidth(), testImage.getHeight());
        for (ProbImageThread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (int i = 0; i < testImage.getStackSize() * this.numOfClasses; ++i) {
            probStack.addSlice(probSlices[i].getTitle(), probSlices[i].getProcessor().convertToByte(true).duplicate());
        }
        ImagePlus probImage = new ImagePlus("Class probability image", probStack);
        probImage.setDimensions(this.numOfClasses, testImage.getNSlices(), testImage.getNFrames());
        probImage.setOpenAsHyperStack(true);
        return probImage;
    }

    public void loadTrainingData() {
        OpenDialog od = new OpenDialog("Choose data file", "");
        if (od.getFileName() == null) {
            return;
        }
        this.loadTrainingData(od.getDirectory() + od.getFileName());
    }

    public void saveTrainingData() {
        boolean examplesEmpty = true;
        for (int i = 0; i < this.numOfClasses; ++i) {
            if (this.examples[i].isEmpty()) continue;
            examplesEmpty = false;
            break;
        }
        if (examplesEmpty && this.loadedTrainingData == null) {
            IJ.showMessage((String)"There is no data to save");
            return;
        }
        if (this.featureStack.getSize() < 2) {
            this.setButtonsEnabled(false);
            this.featureStack.updateFeaturesMT();
            this.setButtonsEnabled(true);
        }
        Instances data = this.createTrainingInstances();
        data.setClassIndex(data.numAttributes() - 1);
        if (null != this.loadedTrainingData && null != data) {
            IJ.log((String)"merging data");
            for (int i = 0; i < this.loadedTrainingData.numInstances(); ++i) {
                data.add(this.loadedTrainingData.instance(i));
            }
            IJ.log((String)"Finished");
        } else if (null == data) {
            data = this.loadedTrainingData;
        }
        SaveDialog sd = new SaveDialog("Choose save file", "data", ".arff");
        if (sd.getFileName() == null) {
            return;
        }
        IJ.log((String)("Writing training data: " + data.numInstances() + " instances..."));
        this.writeDataToARFF(data, sd.getDirectory() + sd.getFileName());
        IJ.log((String)("Wrote training data: " + sd.getDirectory() + sd.getFileName()));
    }

    private void addNewClass() {
        if (this.numOfClasses == 5) {
            IJ.showMessage((String)"Trainable Segmentation", (String)"Sorry, maximum number of classes has been reached");
            return;
        }
        String inputName = JOptionPane.showInputDialog("Please input a new label name");
        if (null == inputName) {
            return;
        }
        if (null == inputName || 0 == inputName.length()) {
            IJ.error((String)"Invalid name for class");
            return;
        }
        if (0 == (inputName = inputName.trim()).toLowerCase().indexOf("add to ")) {
            inputName = inputName.substring(7);
        }
        this.classLabels[this.numOfClasses] = inputName;
        this.win.addClass();
        this.repaintWindow();
        this.updateWholeData = true;
    }

    private void repaintWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Trainable_Segmentation.this.win.invalidate();
                Trainable_Segmentation.this.win.validate();
                Trainable_Segmentation.this.win.repaint();
            }
        });
    }

    public boolean showSettingsDialog() {
        GenericDialogPlus gd = new GenericDialogPlus("Segmentation settings");
        boolean[] oldEnableFeatures = this.featureStack.getEnabledFeatures();
        gd.addMessage("Training features:");
        int rows = (int)Math.round((double)FeatureStack.availableFeatures.length / 2.0);
        gd.addCheckboxGroup(rows, 2, FeatureStack.availableFeatures, oldEnableFeatures);
        Weka_Segmentation.disableMissingFeatures((GenericDialog)gd);
        if (this.loadedTrainingData != null) {
            Vector v = gd.getCheckboxes();
            for (Checkbox c : v) {
                c.setEnabled(false);
            }
            gd.addMessage("WARNING: no features are selectable while using loaded data");
        }
        gd.addMessage("General options:");
        gd.addMessage("Fast Random Forest settings:");
        gd.addNumericField("Number of trees:", (double)this.numOfTrees, 0);
        gd.addNumericField("Random features", (double)this.randomFeatures, 0);
        gd.addMessage("Class names:");
        for (int i = 0; i < this.numOfClasses; ++i) {
            gd.addStringField("Class " + (i + 1), this.classLabels[i], 15);
        }
        gd.addMessage("Advanced options:");
        gd.addButton("Save feature stack", (ActionListener)new ButtonListener("Select location to save feature stack", this.featureStack));
        gd.addSlider("Result overlay opacity", 0.0, 100.0, (double)this.overlayOpacity);
        gd.addHelp("http://fiji.sc/wiki/Trainable_Segmentation_Plugin");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        int numOfFeatures = FeatureStack.availableFeatures.length;
        boolean[] newEnableFeatures = new boolean[numOfFeatures];
        boolean featuresChanged = false;
        for (int i = 0; i < numOfFeatures; ++i) {
            newEnableFeatures[i] = gd.getNextBoolean();
            if (newEnableFeatures[i] == oldEnableFeatures[i]) continue;
            featuresChanged = true;
        }
        int newNumTrees = (int)gd.getNextNumber();
        int newRandomFeatures = (int)gd.getNextNumber();
        boolean classNameChanged = false;
        for (int i = 0; i < this.numOfClasses; ++i) {
            String s = gd.getNextString();
            if (null == s || 0 == s.length()) {
                IJ.log((String)("Invalid name for class " + (i + 1)));
                continue;
            }
            if ((s = s.trim()).equals(this.classLabels[i])) continue;
            if (0 == s.toLowerCase().indexOf("add to ")) {
                s = s.substring(7);
            }
            this.classLabels[i] = s;
            classNameChanged = true;
            this.addExampleButton[i].setText("Add to " + this.classLabels[i]);
        }
        int newOpacity = (int)gd.getNextNumber();
        if (newOpacity != this.overlayOpacity) {
            this.overlayOpacity = newOpacity;
            this.overlayAlpha = AlphaComposite.getInstance(3, (float)this.overlayOpacity / 100.0f);
            this.resultOverlay.setComposite(this.overlayAlpha);
            if (this.showColorOverlay) {
                this.displayImage.updateAndDraw();
            }
        }
        if (classNameChanged) {
            this.updateWholeData = true;
            this.win.pack();
        }
        if (newNumTrees != this.numOfTrees || newRandomFeatures != this.randomFeatures) {
            this.updateClassifier(newNumTrees, newRandomFeatures);
        }
        if (featuresChanged) {
            this.setButtonsEnabled(false);
            this.featureStack.setEnabledFeatures(newEnableFeatures);
            this.featureStack.updateFeaturesMT();
            this.setButtonsEnabled(true);
            this.updateWholeData = true;
        }
        return true;
    }

    private boolean updateClassifier(int newNumTrees, int newRandomFeatures) {
        if (newNumTrees < 1 || newRandomFeatures < 1) {
            return false;
        }
        this.numOfTrees = newNumTrees;
        this.randomFeatures = newRandomFeatures;
        this.rf.setNumTrees(this.numOfTrees);
        this.rf.setNumFeatures(this.randomFeatures);
        return true;
    }

    public Trainable_Segmentation(ImagePlus trainingImage) {
        this.useGUI = false;
        this.trainingImage = trainingImage;
        for (int i = 0; i < this.numOfClasses; ++i) {
            this.examples[i] = new ArrayList<Roi>();
        }
        this.rf = new FastRandomForest();
        this.rf.setNumTrees(this.numOfTrees);
        this.rf.setNumFeatures(this.randomFeatures);
        this.rf.setSeed(123);
        this.classifier = this.rf;
        this.featureStack = new FeatureStack(trainingImage);
    }

    public boolean loadTrainingData(String pathname) {
        IJ.log((String)("Loading data from " + pathname + "..."));
        this.loadedTrainingData = this.readDataFromARFF(pathname);
        Enumeration attributes = this.loadedTrainingData.enumerateAttributes();
        int numFeatures = FeatureStack.availableFeatures.length;
        boolean[] usedFeatures = new boolean[numFeatures];
        while (attributes.hasMoreElements()) {
            Attribute a = (Attribute)attributes.nextElement();
            for (int i = 0; i < numFeatures; ++i) {
                if (!a.name().startsWith(FeatureStack.availableFeatures[i])) continue;
                usedFeatures[i] = true;
            }
        }
        Attribute classAttribute = this.loadedTrainingData.classAttribute();
        Enumeration classValues = classAttribute.enumerateValues();
        this.loadedClassNames = new ArrayList();
        int j = 0;
        while (classValues.hasMoreElements()) {
            String className = ((String)classValues.nextElement()).trim();
            this.loadedClassNames.add(className);
            IJ.log((String)("Read class name: " + className));
            if (!className.equals(this.classLabels[j])) {
                String s = this.classLabels[0];
                for (int i = 1; i < this.numOfClasses; ++i) {
                    s = s.concat(", " + this.classLabels[i]);
                }
                IJ.error((String)("ERROR: Loaded classes and current classes do not match!\nExpected: " + s));
                this.loadedTrainingData = null;
                return false;
            }
            ++j;
        }
        if (j != this.numOfClasses) {
            IJ.error((String)"ERROR: Loaded number of classes and current number do not match!");
            this.loadedTrainingData = null;
            return false;
        }
        IJ.log((String)("Loaded data: " + this.loadedTrainingData.numInstances() + " instances, " + this.loadedTrainingData.numAttributes() + " attributes."));
        boolean featuresChanged = false;
        boolean[] oldEnableFeatures = this.featureStack.getEnabledFeatures();
        for (int i = 0; i < numFeatures; ++i) {
            if (usedFeatures[i] == oldEnableFeatures[i]) continue;
            featuresChanged = true;
        }
        if (featuresChanged) {
            this.setButtonsEnabled(false);
            this.featureStack.setEnabledFeatures(usedFeatures);
            this.featureStack.updateFeaturesMT();
            this.setButtonsEnabled(true);
            this.updateWholeData = true;
        }
        return true;
    }

    public ImagePlus getClassifiedImage() {
        return this.classifiedImage;
    }

    static class ButtonListener
    implements ActionListener {
        private String title;
        private TextField text;
        private FeatureStack featureStack;

        public ButtonListener(String title, FeatureStack featureStack) {
            this.title = title;
            this.featureStack = featureStack;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.featureStack.isEmpty()) {
                IJ.error((String)"Error", (String)"The feature stack has not been initialized yet, please train first.");
                return;
            }
            SaveDialog sd = new SaveDialog(this.title, "feature-stack", ".tif");
            String dir = sd.getDirectory();
            String filename = sd.getFileName();
            if (null == dir || null == filename) {
                return;
            }
            if (!this.featureStack.saveStackAsTiff(dir + filename)) {
                IJ.error((String)"Error", (String)"Feature stack could not be saved");
                return;
            }
            IJ.log((String)("Feature stack saved as " + dir + filename));
        }
    }

    private class CustomWindow
    extends ImageWindow {
        private GridBagLayout boxAnnotation;
        private GridBagConstraints annotationsConstraints;
        private JPanel annotationsPanel;
        private JPanel buttonsPanel;
        private JPanel trainingJPanel;
        private JPanel optionsJPanel;
        private Panel all;

        CustomWindow(ImagePlus imp) {
            int i;
            super(imp, (ImageCanvas)new CustomCanvas(imp));
            this.boxAnnotation = new GridBagLayout();
            this.annotationsConstraints = new GridBagConstraints();
            this.annotationsPanel = new JPanel();
            this.buttonsPanel = new JPanel();
            this.trainingJPanel = new JPanel();
            this.optionsJPanel = new JPanel();
            this.all = new Panel();
            final CustomCanvas canvas = (CustomCanvas)this.getCanvas();
            for (i = 0; i < 5; ++i) {
                ((Trainable_Segmentation)Trainable_Segmentation.this).roiOverlay[i] = new RoiListOverlay();
                Trainable_Segmentation.this.roiOverlay[i].setComposite(Trainable_Segmentation.this.transparency050);
                ((OverlayedImageCanvas)this.ic).addOverlay((OverlayedImageCanvas.Overlay)Trainable_Segmentation.this.roiOverlay[i]);
            }
            Trainable_Segmentation.this.resultOverlay.setComposite(Trainable_Segmentation.this.overlayAlpha);
            ((OverlayedImageCanvas)this.ic).addOverlay((OverlayedImageCanvas.Overlay)Trainable_Segmentation.this.resultOverlay);
            this.removeAll();
            this.setTitle("Trainable Segmentation");
            this.annotationsConstraints.anchor = 18;
            this.annotationsConstraints.gridwidth = 1;
            this.annotationsConstraints.gridheight = 1;
            this.annotationsConstraints.gridx = 0;
            this.annotationsConstraints.gridy = 0;
            this.annotationsPanel.setBorder(BorderFactory.createTitledBorder("Labels"));
            this.annotationsPanel.setLayout(this.boxAnnotation);
            for (i = 0; i < Trainable_Segmentation.this.numOfClasses; ++i) {
                Trainable_Segmentation.this.exampleList[i].addActionListener(Trainable_Segmentation.this.listener);
                Trainable_Segmentation.this.exampleList[i].addItemListener(Trainable_Segmentation.this.itemListener);
                ((Trainable_Segmentation)Trainable_Segmentation.this).addExampleButton[i] = new JButton("Add to " + Trainable_Segmentation.this.classLabels[i]);
                Trainable_Segmentation.this.addExampleButton[i].setToolTipText("Add markings of label '" + Trainable_Segmentation.this.classLabels[i] + "'");
                this.annotationsConstraints.fill = 2;
                this.annotationsConstraints.insets = new Insets(5, 5, 6, 6);
                this.boxAnnotation.setConstraints(Trainable_Segmentation.this.addExampleButton[i], this.annotationsConstraints);
                this.annotationsPanel.add(Trainable_Segmentation.this.addExampleButton[i]);
                ++this.annotationsConstraints.gridy;
                this.annotationsConstraints.insets = new Insets(0, 0, 0, 0);
                this.boxAnnotation.setConstraints(Trainable_Segmentation.this.exampleList[i], this.annotationsConstraints);
                this.annotationsPanel.add(Trainable_Segmentation.this.exampleList[i]);
                ++this.annotationsConstraints.gridy;
            }
            Trainable_Segmentation.this.addExampleButton[0].setSelected(true);
            for (i = 0; i < Trainable_Segmentation.this.numOfClasses; ++i) {
                Trainable_Segmentation.this.addExampleButton[i].addActionListener(Trainable_Segmentation.this.listener);
            }
            Trainable_Segmentation.this.trainButton.addActionListener(Trainable_Segmentation.this.listener);
            Trainable_Segmentation.this.overlayButton.addActionListener(Trainable_Segmentation.this.listener);
            Trainable_Segmentation.this.resultButton.addActionListener(Trainable_Segmentation.this.listener);
            Trainable_Segmentation.this.applyButton.addActionListener(Trainable_Segmentation.this.listener);
            Trainable_Segmentation.this.probimgButton.addActionListener(Trainable_Segmentation.this.listener);
            Trainable_Segmentation.this.loadDataButton.addActionListener(Trainable_Segmentation.this.listener);
            Trainable_Segmentation.this.saveDataButton.addActionListener(Trainable_Segmentation.this.listener);
            Trainable_Segmentation.this.addClassButton.addActionListener(Trainable_Segmentation.this.listener);
            Trainable_Segmentation.this.settingsButton.addActionListener(Trainable_Segmentation.this.listener);
            this.trainingJPanel.setBorder(BorderFactory.createTitledBorder("Training"));
            GridBagLayout trainingLayout = new GridBagLayout();
            GridBagConstraints trainingConstraints = new GridBagConstraints();
            trainingConstraints.anchor = 18;
            trainingConstraints.fill = 2;
            trainingConstraints.gridwidth = 1;
            trainingConstraints.gridheight = 1;
            trainingConstraints.gridx = 0;
            trainingConstraints.gridy = 0;
            trainingConstraints.insets = new Insets(5, 5, 6, 6);
            this.trainingJPanel.setLayout(trainingLayout);
            this.trainingJPanel.add((Component)Trainable_Segmentation.this.trainButton, trainingConstraints);
            ++trainingConstraints.gridy;
            this.trainingJPanel.add((Component)Trainable_Segmentation.this.overlayButton, trainingConstraints);
            ++trainingConstraints.gridy;
            this.trainingJPanel.add((Component)Trainable_Segmentation.this.resultButton, trainingConstraints);
            ++trainingConstraints.gridy;
            this.optionsJPanel.setBorder(BorderFactory.createTitledBorder("Options"));
            GridBagLayout optionsLayout = new GridBagLayout();
            GridBagConstraints optionsConstraints = new GridBagConstraints();
            optionsConstraints.anchor = 18;
            optionsConstraints.fill = 2;
            optionsConstraints.gridwidth = 1;
            optionsConstraints.gridheight = 1;
            optionsConstraints.gridx = 0;
            optionsConstraints.gridy = 0;
            optionsConstraints.insets = new Insets(5, 5, 6, 6);
            this.optionsJPanel.setLayout(optionsLayout);
            this.optionsJPanel.add((Component)Trainable_Segmentation.this.applyButton, optionsConstraints);
            ++optionsConstraints.gridy;
            this.optionsJPanel.add((Component)Trainable_Segmentation.this.probimgButton, optionsConstraints);
            ++optionsConstraints.gridy;
            this.optionsJPanel.add((Component)Trainable_Segmentation.this.loadDataButton, optionsConstraints);
            ++optionsConstraints.gridy;
            this.optionsJPanel.add((Component)Trainable_Segmentation.this.saveDataButton, optionsConstraints);
            ++optionsConstraints.gridy;
            this.optionsJPanel.add((Component)Trainable_Segmentation.this.addClassButton, optionsConstraints);
            ++optionsConstraints.gridy;
            this.optionsJPanel.add((Component)Trainable_Segmentation.this.settingsButton, optionsConstraints);
            ++optionsConstraints.gridy;
            GridBagLayout buttonsLayout = new GridBagLayout();
            GridBagConstraints buttonsConstraints = new GridBagConstraints();
            this.buttonsPanel.setLayout(buttonsLayout);
            buttonsConstraints.anchor = 18;
            buttonsConstraints.fill = 2;
            buttonsConstraints.gridwidth = 1;
            buttonsConstraints.gridheight = 1;
            buttonsConstraints.gridx = 0;
            buttonsConstraints.gridy = 0;
            this.buttonsPanel.add((Component)this.trainingJPanel, buttonsConstraints);
            ++buttonsConstraints.gridy;
            this.buttonsPanel.add((Component)this.optionsJPanel, buttonsConstraints);
            ++buttonsConstraints.gridy;
            buttonsConstraints.insets = new Insets(5, 5, 6, 6);
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints allConstraints = new GridBagConstraints();
            this.all.setLayout(layout);
            allConstraints.anchor = 18;
            allConstraints.fill = 1;
            allConstraints.gridwidth = 1;
            allConstraints.gridheight = 1;
            allConstraints.gridx = 0;
            allConstraints.gridy = 0;
            allConstraints.weightx = 0.0;
            allConstraints.weighty = 0.0;
            this.all.add((Component)this.buttonsPanel, allConstraints);
            ++allConstraints.gridx;
            allConstraints.weightx = 1.0;
            allConstraints.weighty = 1.0;
            this.all.add((Component)((Object)canvas), allConstraints);
            ++allConstraints.gridx;
            allConstraints.anchor = 12;
            allConstraints.weightx = 0.0;
            allConstraints.weighty = 0.0;
            this.all.add((Component)this.annotationsPanel, allConstraints);
            GridBagLayout wingb = new GridBagLayout();
            GridBagConstraints winc = new GridBagConstraints();
            winc.anchor = 18;
            winc.fill = 1;
            winc.weightx = 1.0;
            winc.weighty = 1.0;
            this.setLayout(wingb);
            this.add(this.all, winc);
            for (Component p : new Component[]{this.all, this.buttonsPanel}) {
                for (KeyListener kl : this.getKeyListeners()) {
                    p.addKeyListener(kl);
                }
            }
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Trainable_Segmentation.this.exec.shutdownNow();
                    for (int i = 0; i < Trainable_Segmentation.this.numOfClasses; ++i) {
                        Trainable_Segmentation.this.addExampleButton[i].removeActionListener(Trainable_Segmentation.this.listener);
                    }
                    Trainable_Segmentation.this.trainButton.removeActionListener(Trainable_Segmentation.this.listener);
                    Trainable_Segmentation.this.overlayButton.removeActionListener(Trainable_Segmentation.this.listener);
                    Trainable_Segmentation.this.resultButton.removeActionListener(Trainable_Segmentation.this.listener);
                    Trainable_Segmentation.this.applyButton.removeActionListener(Trainable_Segmentation.this.listener);
                    Trainable_Segmentation.this.probimgButton.removeActionListener(Trainable_Segmentation.this.listener);
                    Trainable_Segmentation.this.loadDataButton.removeActionListener(Trainable_Segmentation.this.listener);
                    Trainable_Segmentation.this.saveDataButton.removeActionListener(Trainable_Segmentation.this.listener);
                    Trainable_Segmentation.this.addClassButton.removeActionListener(Trainable_Segmentation.this.listener);
                    Trainable_Segmentation.this.settingsButton.removeActionListener(Trainable_Segmentation.this.listener);
                    Trainable_Segmentation.this.numOfClasses = 2;
                }
            });
            canvas.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent ce) {
                    Rectangle r = canvas.getBounds();
                    canvas.setDstDimensions(r.width, r.height);
                }
            });
        }

        public void repaintAll() {
            this.annotationsPanel.repaint();
            this.getCanvas().repaint();
            this.buttonsPanel.repaint();
            this.all.repaint();
        }

        public void addClass() {
            ((Trainable_Segmentation)Trainable_Segmentation.this).examples[((Trainable_Segmentation)Trainable_Segmentation.this).numOfClasses] = new ArrayList();
            ((Trainable_Segmentation)Trainable_Segmentation.this).exampleList[((Trainable_Segmentation)Trainable_Segmentation.this).numOfClasses] = new List(5);
            Trainable_Segmentation.this.exampleList[Trainable_Segmentation.this.numOfClasses].setForeground(Trainable_Segmentation.this.colors[Trainable_Segmentation.this.numOfClasses]);
            Trainable_Segmentation.this.exampleList[Trainable_Segmentation.this.numOfClasses].addActionListener(Trainable_Segmentation.this.listener);
            Trainable_Segmentation.this.exampleList[Trainable_Segmentation.this.numOfClasses].addItemListener(Trainable_Segmentation.this.itemListener);
            ((Trainable_Segmentation)Trainable_Segmentation.this).addExampleButton[((Trainable_Segmentation)Trainable_Segmentation.this).numOfClasses] = new JButton("Add to " + Trainable_Segmentation.this.classLabels[Trainable_Segmentation.this.numOfClasses]);
            this.annotationsConstraints.fill = 2;
            this.annotationsConstraints.insets = new Insets(5, 5, 6, 6);
            this.boxAnnotation.setConstraints(Trainable_Segmentation.this.addExampleButton[Trainable_Segmentation.this.numOfClasses], this.annotationsConstraints);
            this.annotationsPanel.add(Trainable_Segmentation.this.addExampleButton[Trainable_Segmentation.this.numOfClasses]);
            ++this.annotationsConstraints.gridy;
            this.annotationsConstraints.insets = new Insets(0, 0, 0, 0);
            this.boxAnnotation.setConstraints(Trainable_Segmentation.this.exampleList[Trainable_Segmentation.this.numOfClasses], this.annotationsConstraints);
            this.annotationsPanel.add(Trainable_Segmentation.this.exampleList[Trainable_Segmentation.this.numOfClasses]);
            ++this.annotationsConstraints.gridy;
            Trainable_Segmentation.this.addExampleButton[Trainable_Segmentation.this.numOfClasses].addActionListener(Trainable_Segmentation.this.listener);
            Trainable_Segmentation.this.numOfClasses++;
            this.repaintAll();
        }
    }

    private class CustomCanvas
    extends OverlayedImageCanvas {
        CustomCanvas(ImagePlus imp) {
            super(imp);
            Dimension dim = new Dimension(Math.min(512, imp.getWidth()), Math.min(512, imp.getHeight()));
            this.setMinimumSize(dim);
            this.setSize(dim.width, dim.height);
            this.setDstDimensions(dim.width, dim.height);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent ke) {
                    CustomCanvas.this.repaint();
                }
            });
        }

        public void setDrawingSize(int w, int h) {
        }

        public void setDstDimensions(int width, int height) {
            int y;
            this.dstWidth = width;
            this.dstHeight = height;
            int w = Math.min((int)((double)width / this.magnification), this.imp.getWidth());
            int h = Math.min((int)((double)height / this.magnification), this.imp.getHeight());
            int x = this.srcRect.x;
            if (x + w > this.imp.getWidth()) {
                x = w - this.imp.getWidth();
            }
            if ((y = this.srcRect.y) + h > this.imp.getHeight()) {
                y = h - this.imp.getHeight();
            }
            this.srcRect.setRect(x, y, w, h);
            this.repaint();
        }

        public void paint(Graphics g) {
            Rectangle srcRect = this.getSrcRect();
            double mag = this.getMagnification();
            int dw = (int)((double)srcRect.width * mag);
            int dh = (int)((double)srcRect.height * mag);
            g.setClip(0, 0, dw, dh);
            super.paint(g);
            int w = this.getWidth();
            int h = this.getHeight();
            g.setClip(0, 0, w, h);
            g.setColor(this.getBackground());
            g.fillRect(dw, 0, w - dw, h);
            g.fillRect(0, dh, w, h - dh);
        }
    }
}

