/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation.unsupervised;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageRoi;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.StackWindow;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import trainableSegmentation.FeatureStackArray;
import trainableSegmentation.unsupervised.ColorClustering;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyPanel;
import weka.gui.explorer.ClustererAssignmentsPlotInstances;
import weka.gui.visualize.VisualizePanel;

public class Color_Clustering
implements PlugIn {
    private final ExecutorService exec = Executors.newFixedThreadPool(1);
    protected ImagePlus image = null;
    protected ImagePlus originalImage = null;
    private boolean[] selectedChannels;
    private int numSamples;
    private int numChannels;
    private AbstractClusterer clusterer = null;
    private Thread currentTask = null;
    private ImagePlus clusteredImage = null;
    private CustomWindow win;
    private ColorClustering colorClustering = null;
    private boolean featuresCreated = false;
    private FeatureStackArray featureStackArray = null;
    String inputImageTitle = null;
    String inputImageShortTitle = null;
    boolean finishedClustering = false;

    public void saveClusterer() {
        SaveDialog sd = new SaveDialog("Save model as...", "clusterer", ".model");
        if (sd.getFileName() == null) {
            return;
        }
        if (!this.colorClustering.saveClusterer(sd.getDirectory() + sd.getFileName())) {
            IJ.error((String)"Error while writing clusterer into a file");
            return;
        }
    }

    public void loadClusterer() {
        int i;
        OpenDialog od = new OpenDialog("Choose Weka clusterer file", "");
        if (od.getFileName() == null) {
            return;
        }
        IJ.log((String)("Loading Weka clusterer from " + od.getDirectory() + od.getFileName() + "..."));
        if (!this.colorClustering.loadClusterer(od.getDirectory() + od.getFileName())) {
            IJ.error((String)"Error when loading Weka clusterer from file");
            IJ.log((String)"Error: clusterer could not be loaded.");
            return;
        }
        this.clusterer = this.colorClustering.getTheClusterer();
        Instances featuresInstances = this.colorClustering.getFeaturesInstances();
        boolean[] enabledChannels = new boolean[this.numChannels];
        for (i = 0; i < this.numChannels; ++i) {
            enabledChannels[i] = false;
        }
        block1: for (i = 0; i < featuresInstances.numAttributes(); ++i) {
            String name = featuresInstances.attribute(i).name();
            for (int j = 0; j < this.numChannels; ++j) {
                if (!this.win.channelCheckbox[j].getText().equals(name)) continue;
                enabledChannels[j] = true;
                continue block1;
            }
        }
        for (i = 0; i < this.numChannels; ++i) {
            if (this.win.channelCheckbox[i].isSelected() != enabledChannels[i]) {
                this.featuresCreated = false;
            }
            this.win.channelCheckbox[i].setSelected(enabledChannels[i]);
        }
        this.win.clustererEditor.setValue((Object)this.clusterer);
        IJ.log((String)("Loaded clusterer:" + this.clusterer));
        this.finishedClustering = true;
        if (!this.featuresCreated && !this.win.createFeatures()) {
            this.finishedClustering = false;
            return;
        }
        IJ.log((String)"Creating new clustered image...");
        this.clusteredImage = this.colorClustering.createClusteredImage(this.featureStackArray);
        this.win.updateResultOverlay();
        IJ.log((String)"Done");
    }

    public void run(String s) {
        if (null == WindowManager.getCurrentImage()) {
            this.originalImage = IJ.openImage();
            if (this.originalImage == null) {
                return;
            }
        } else {
            this.originalImage = WindowManager.getCurrentImage();
            this.originalImage.getWindow().setVisible(false);
        }
        this.inputImageTitle = this.originalImage.getTitle();
        this.inputImageShortTitle = this.originalImage.getShortTitle();
        this.image = this.originalImage.duplicate();
        this.image.setSlice(this.originalImage.getSlice());
        this.image.setTitle("Color Clustering");
        IJ.log((String)"Loading all available Weka clustering methods...");
        IJ.showStatus((String)"Loading all available Weka clustering methods...");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Color_Clustering.this.win = new CustomWindow(Color_Clustering.this.image);
                Color_Clustering.this.win.pack();
            }
        });
    }

    static /* synthetic */ boolean[] access$1402(Color_Clustering x0, boolean[] x1) {
        x0.selectedChannels = x1;
        return x1;
    }

    private class CustomWindow
    extends StackWindow {
        private static final long serialVersionUID = -8066394344204413879L;
        private Panel all;
        JPanel paramsPanel;
        JPanel clusteringPanel;
        JPanel resultsPanel;
        private JPanel channelSelectionPanel;
        private JPanel clustererPanel;
        private JPanel samplePanel;
        JCheckBox[] channelCheckbox;
        private GenericObjectEditor clustererEditor;
        private JButton runClusterButton;
        private JButton createFile;
        private JButton createResult;
        private JButton createProbabilityMap;
        private JButton visualizeData;
        private JButton saveClusterer;
        private JButton loadClusterer;
        private boolean warned;
        private JSlider pixelSlider;
        private JSlider opacitySlider;
        ChangeListener sampleChange;
        ChangeListener opacityChange;
        ActionListener runButtonListener;
        ActionListener saveTheClusterer;
        ActionListener fileCreation;
        ActionListener resultCreation;
        ActionListener probMapCreator;
        ActionListener dataVisualizer;
        ActionListener clusterLoader;
        ActionListener channelSelect;

        void updateResultOverlay() {
            if (null != Color_Clustering.this.clusteredImage) {
                int slice = Color_Clustering.this.image.getCurrentSlice();
                ImageRoi roi = null;
                roi = new ImageRoi(0, 0, Color_Clustering.this.clusteredImage.getImageStack().getProcessor(slice));
                roi.setOpacity((double)this.opacitySlider.getValue() / 100.0);
                Color_Clustering.this.image.setOverlay(new Overlay((Roi)roi));
            }
        }

        CustomWindow(ImagePlus imp) {
            super(imp, new ImageCanvas(imp));
            this.all = new Panel();
            this.paramsPanel = new JPanel();
            this.clusteringPanel = new JPanel();
            this.resultsPanel = new JPanel();
            this.channelSelectionPanel = new JPanel();
            this.clustererPanel = new JPanel();
            this.samplePanel = new JPanel();
            this.channelCheckbox = null;
            this.clustererEditor = new GenericObjectEditor();
            this.runClusterButton = null;
            this.createFile = null;
            this.createResult = null;
            this.createProbabilityMap = null;
            this.visualizeData = null;
            this.saveClusterer = null;
            this.loadClusterer = null;
            this.warned = false;
            this.sampleChange = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!CustomWindow.this.warned && Color_Clustering.this.numSamples > 1000000) {
                        IJ.error((String)"Warning", (String)"Pixel count very high!");
                        CustomWindow.this.warned = true;
                    } else if (CustomWindow.this.warned && Color_Clustering.this.numSamples < 1000000) {
                        CustomWindow.this.warned = false;
                    }
                    if (Color_Clustering.this.featuresCreated) {
                        Color_Clustering.this.featuresCreated = false;
                    }
                    JSlider slider = (JSlider)CustomWindow.this.samplePanel.getComponent(0);
                    Color_Clustering.this.numSamples = Color_Clustering.this.image.getHeight() * Color_Clustering.this.image.getWidth() * Color_Clustering.this.image.getNSlices() * slider.getValue() / 100;
                    JTextArea textArea = (JTextArea)CustomWindow.this.samplePanel.getComponent(1);
                    textArea.setText(Integer.toString(slider.getValue()) + "% (" + Color_Clustering.this.numSamples + ") px");
                }
            };
            this.opacityChange = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    CustomWindow.this.updateResultOverlay();
                }
            };
            this.runButtonListener = new ActionListener(){

                @Override
                public void actionPerformed(final ActionEvent e) {
                    final String command = e.getActionCommand();
                    Color_Clustering.this.exec.submit(new Runnable(){

                        @Override
                        public void run() {
                            if (e.getSource() == CustomWindow.this.runClusterButton) {
                                CustomWindow.this.runClusterOrStop(command);
                            }
                        }
                    });
                }
            };
            this.saveTheClusterer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color_Clustering.this.exec.submit(new Runnable(){

                        @Override
                        public void run() {
                            Color_Clustering.this.saveClusterer();
                        }
                    });
                }
            };
            this.fileCreation = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color_Clustering.this.exec.submit(new Runnable(){

                        @Override
                        public void run() {
                            CustomWindow.this.updateClusterer();
                            SaveDialog sd = new SaveDialog("Save features as...", "features", ".arff");
                            if (null != sd.getDirectory()) {
                                if (!Color_Clustering.this.featuresCreated && !CustomWindow.this.createFeatures()) {
                                    IJ.log((String)"Error while creating features!");
                                    return;
                                }
                                String path = sd.getDirectory() + sd.getFileName();
                                IJ.log((String)"Saving features to ARFF file...");
                                if (Color_Clustering.this.colorClustering.createFile(path, Color_Clustering.this.colorClustering.getFeaturesInstances())) {
                                    IJ.log((String)("Saved features as " + path));
                                }
                            }
                        }
                    });
                }
            };
            this.resultCreation = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color_Clustering.this.exec.submit(new Runnable(){

                        @Override
                        public void run() {
                            ImagePlus result = Color_Clustering.this.clusteredImage.duplicate();
                            result.setCalibration(Color_Clustering.this.image.getCalibration());
                            result.setFileInfo(Color_Clustering.this.image.getFileInfo());
                            result.setTitle(Color_Clustering.this.inputImageShortTitle + "-clusters");
                            result.show();
                        }
                    });
                }
            };
            this.probMapCreator = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color_Clustering.this.exec.submit(new Runnable(){

                        @Override
                        public void run() {
                            if (!Color_Clustering.this.featuresCreated) {
                                IJ.log((String)"Creating features...");
                                CustomWindow.this.createFeatures();
                            }
                            if (Color_Clustering.this.clusterer == null) {
                                CustomWindow.this.updateClusterer();
                            }
                            if (!Color_Clustering.this.finishedClustering) {
                                CustomWindow.this.buildClusterer();
                            }
                            IJ.log((String)"Creating probability map image...");
                            ImagePlus result = Color_Clustering.this.colorClustering.createProbabilityMaps(Color_Clustering.this.featureStackArray);
                            result.setCalibration(Color_Clustering.this.image.getCalibration());
                            result.setFileInfo(Color_Clustering.this.image.getFileInfo());
                            result.setTitle(Color_Clustering.this.inputImageShortTitle + "-clusterprobmap");
                            result.show();
                            IJ.log((String)"Done");
                        }
                    });
                }
            };
            this.dataVisualizer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color_Clustering.this.exec.submit(new Runnable(){

                        @Override
                        public void run() {
                            CustomWindow.this.visualizeData();
                        }
                    });
                }
            };
            this.clusterLoader = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color_Clustering.this.exec.submit(new Runnable(){

                        @Override
                        public void run() {
                            Color_Clustering.this.win.enableComponents(false);
                            Color_Clustering.this.loadClusterer();
                            Color_Clustering.this.win.updateComponentEnabling();
                        }
                    });
                }
            };
            this.channelSelect = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color_Clustering.this.exec.submit(new Runnable(){

                        @Override
                        public void run() {
                            Color_Clustering.this.featuresCreated = false;
                        }
                    });
                }
            };
            Color_Clustering.this.colorClustering = new ColorClustering(Color_Clustering.this.image);
            ImageCanvas canvas = this.getCanvas();
            Color_Clustering.this.numChannels = ColorClustering.Channel.numChannels();
            this.channelSelectionPanel.setLayout(new GridLayout(3, Color_Clustering.this.numChannels / 3, 6, 0));
            this.channelSelectionPanel.setBorder(BorderFactory.createTitledBorder("Channel"));
            this.channelSelectionPanel.setToolTipText("Choose channels to be used");
            String[] channelList = ColorClustering.Channel.getAllLabels();
            this.channelCheckbox = new JCheckBox[Color_Clustering.this.numChannels];
            for (int i = 0; i < Color_Clustering.this.numChannels; ++i) {
                this.channelCheckbox[i] = new JCheckBox(channelList[i]);
                this.channelCheckbox[i].addActionListener(this.channelSelect);
                this.channelSelectionPanel.add((Component)this.channelCheckbox[i], i);
            }
            this.pixelSlider = new JSlider(1, 100, 50);
            this.samplePanel.setBorder(BorderFactory.createTitledBorder("Number of Samples"));
            this.samplePanel.setToolTipText("Select a percentage of pixels to be used when training the clusterer");
            this.samplePanel.add((Component)this.pixelSlider, 0);
            JTextArea txtNumSamples = null;
            if ((double)(Color_Clustering.this.image.getHeight() * Color_Clustering.this.image.getWidth() * Color_Clustering.this.image.getNSlices()) * 0.5 < 30000.0) {
                txtNumSamples = new JTextArea("50% (" + Integer.toString(Color_Clustering.this.image.getHeight() * Color_Clustering.this.image.getWidth() * Color_Clustering.this.image.getNSlices() * this.pixelSlider.getValue() / 100) + ") px");
            } else {
                double x = 30000.0 / (double)(Color_Clustering.this.image.getHeight() * Color_Clustering.this.image.getWidth() * Color_Clustering.this.image.getNSlices());
                if (x < 0.01) {
                    x = 0.01;
                }
                txtNumSamples = new JTextArea(Integer.toString((int)(x * 100.0)) + "% (" + Integer.toString(Color_Clustering.this.image.getHeight() * Color_Clustering.this.image.getWidth() * Color_Clustering.this.image.getNSlices() * (int)(x * 100.0) / 100) + ") px");
                this.pixelSlider.setValue((int)(x * 100.0));
            }
            Color_Clustering.this.numSamples = Color_Clustering.this.image.getHeight() * Color_Clustering.this.image.getWidth() * Color_Clustering.this.image.getNSlices() * this.pixelSlider.getValue() / 100;
            this.samplePanel.add((Component)txtNumSamples, 1);
            this.pixelSlider.addChangeListener(this.sampleChange);
            GridBagConstraints clustererConstraints = new GridBagConstraints();
            this.clustererPanel.setLayout(new GridBagLayout());
            clustererConstraints.insets = new Insets(5, 5, 6, 6);
            clustererConstraints.anchor = 10;
            clustererConstraints.fill = 1;
            clustererConstraints.gridwidth = 1;
            clustererConstraints.gridheight = 1;
            clustererConstraints.gridx = 0;
            clustererConstraints.gridy = 0;
            clustererConstraints.weightx = 0.0;
            clustererConstraints.weighty = 0.0;
            Color_Clustering.this.clusterer = (AbstractClusterer)new SimpleKMeans();
            PropertyPanel clustererEditorPanel = new PropertyPanel((PropertyEditor)this.clustererEditor);
            this.clustererEditor.setClassType(Clusterer.class);
            this.clustererEditor.setValue((Object)Color_Clustering.this.clusterer);
            this.clustererEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    CustomWindow.this.updateClusterer();
                }
            });
            clustererConstraints.weightx = 1.0;
            this.clustererPanel.add((Component)clustererEditorPanel, clustererConstraints);
            ++clustererConstraints.gridy;
            this.clustererPanel.setBorder(BorderFactory.createTitledBorder("Clusterer"));
            this.clustererPanel.setToolTipText("Choose clusterer to be used");
            this.runClusterButton = new JButton("Run");
            JPanel runClusterButtonPanel = new JPanel();
            this.runClusterButton.setToolTipText("Cluster the image!");
            runClusterButtonPanel.add(this.runClusterButton);
            this.clustererPanel.add((Component)runClusterButtonPanel, clustererConstraints);
            ++clustererConstraints.gridy;
            this.runClusterButton.addActionListener(this.runButtonListener);
            GridBagConstraints overlayConstraints = new GridBagConstraints();
            JPanel overlayPanel = new JPanel();
            overlayPanel.setLayout(new GridBagLayout());
            overlayConstraints.anchor = 10;
            overlayConstraints.fill = 1;
            overlayConstraints.gridwidth = 1;
            overlayConstraints.gridheight = 1;
            overlayConstraints.gridx = 0;
            overlayConstraints.gridy = 0;
            overlayConstraints.weightx = 0.0;
            overlayConstraints.weighty = 0.0;
            overlayConstraints.insets = new Insets(5, 5, 6, 6);
            JPanel opacityPanel = new JPanel();
            this.opacitySlider = new JSlider(0, 100, 50);
            opacityPanel.add(new Label("Opacity:"));
            this.opacitySlider.setToolTipText("Select a percentage for the opacity");
            opacityPanel.add(this.opacitySlider);
            overlayPanel.add((Component)opacityPanel, overlayConstraints);
            ++overlayConstraints.gridy;
            this.opacitySlider.addChangeListener(this.opacityChange);
            this.opacitySlider.setEnabled(false);
            JPanel ioPanel = new JPanel();
            GridBagConstraints ioConstraints = new GridBagConstraints();
            ioPanel.setLayout(new GridBagLayout());
            ioConstraints.anchor = 10;
            ioConstraints.fill = 1;
            ioConstraints.gridwidth = 1;
            ioConstraints.gridheight = 1;
            ioConstraints.gridx = 0;
            ioConstraints.gridy = 0;
            ioConstraints.weightx = 0.0;
            ioConstraints.weighty = 0.0;
            ioConstraints.insets = new Insets(5, 5, 6, 6);
            this.createFile = new JButton("Create ARFF file");
            this.createFile.setToolTipText("Create a file");
            this.createFile.addActionListener(this.fileCreation);
            ioPanel.add((Component)this.createFile, ioConstraints);
            ++ioConstraints.gridy;
            this.createResult = new JButton("Show result");
            ioPanel.add((Component)this.createResult, ioConstraints);
            ++ioConstraints.gridy;
            this.createResult.addActionListener(this.resultCreation);
            this.createResult.setEnabled(false);
            this.createProbabilityMap = new JButton("Probability Map");
            ioPanel.add((Component)this.createProbabilityMap, ioConstraints);
            ++ioConstraints.gridy;
            this.createProbabilityMap.addActionListener(this.probMapCreator);
            this.createProbabilityMap.setEnabled(false);
            this.visualizeData = new JButton("Visualize data");
            ioPanel.add((Component)this.visualizeData, ioConstraints);
            ++ioConstraints.gridy;
            this.visualizeData.addActionListener(this.dataVisualizer);
            this.saveClusterer = new JButton("Save clusterer");
            ioPanel.add((Component)this.saveClusterer, ioConstraints);
            ++ioConstraints.gridy;
            this.saveClusterer.addActionListener(this.saveTheClusterer);
            this.saveClusterer.setEnabled(false);
            this.loadClusterer = new JButton("Load clusterer");
            ioPanel.add((Component)this.loadClusterer, ioConstraints);
            ++ioConstraints.gridy;
            this.loadClusterer.addActionListener(this.clusterLoader);
            GridBagLayout clusteringLayout = new GridBagLayout();
            GridBagConstraints clusteringConstraints = new GridBagConstraints();
            clusteringConstraints.insets = new Insets(5, 5, 6, 6);
            this.clusteringPanel.setLayout(clusteringLayout);
            clusteringConstraints.anchor = 18;
            clusteringConstraints.fill = 2;
            clusteringConstraints.gridwidth = 1;
            clusteringConstraints.gridheight = 1;
            clusteringConstraints.gridx = 0;
            clusteringConstraints.gridy = 0;
            this.clusteringPanel.add((Component)this.channelSelectionPanel, clusteringConstraints);
            ++clusteringConstraints.gridy;
            this.clusteringPanel.add((Component)this.samplePanel, clusteringConstraints);
            ++clusteringConstraints.gridy;
            this.clusteringPanel.add((Component)this.clustererPanel, clusteringConstraints);
            ++clusteringConstraints.gridy;
            this.resultsPanel.setBorder(BorderFactory.createTitledBorder("Results"));
            this.resultsPanel.setToolTipText("Result options");
            GridBagLayout resultsLayout = new GridBagLayout();
            GridBagConstraints resultConstraints = new GridBagConstraints();
            resultConstraints.insets = new Insets(5, 5, 6, 6);
            this.resultsPanel.setLayout(resultsLayout);
            resultConstraints.anchor = 18;
            resultConstraints.fill = 2;
            resultConstraints.gridwidth = 1;
            resultConstraints.gridheight = 1;
            resultConstraints.gridx = 0;
            resultConstraints.gridy = 0;
            this.resultsPanel.add((Component)overlayPanel, resultConstraints);
            ++resultConstraints.gridy;
            this.resultsPanel.add((Component)ioPanel, resultConstraints);
            ++resultConstraints.gridy;
            GridBagLayout paramsLayout = new GridBagLayout();
            GridBagConstraints paramsConstraints = new GridBagConstraints();
            paramsConstraints.insets = new Insets(5, 5, 6, 6);
            this.paramsPanel.setLayout(paramsLayout);
            paramsConstraints.anchor = 18;
            paramsConstraints.fill = 2;
            paramsConstraints.gridwidth = 1;
            paramsConstraints.gridheight = 1;
            paramsConstraints.gridx = 0;
            paramsConstraints.gridy = 0;
            this.paramsPanel.add((Component)this.clusteringPanel, paramsConstraints);
            ++paramsConstraints.gridy;
            this.paramsPanel.add((Component)this.resultsPanel, paramsConstraints);
            ++paramsConstraints.gridy;
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints allConstraints = new GridBagConstraints();
            this.all.setLayout(layout);
            allConstraints.anchor = 18;
            allConstraints.fill = 1;
            allConstraints.gridwidth = 1;
            allConstraints.gridheight = 1;
            allConstraints.gridx = 0;
            allConstraints.gridy = 0;
            allConstraints.weightx = 0.0;
            allConstraints.weighty = 0.0;
            this.all.add((Component)this.paramsPanel, allConstraints);
            ++allConstraints.gridx;
            allConstraints.weightx = 1.0;
            allConstraints.weighty = 1.0;
            this.all.add((Component)canvas, allConstraints);
            ++allConstraints.gridy;
            allConstraints.weightx = 0.0;
            allConstraints.weighty = 0.0;
            if (null != this.sliceSelector) {
                this.sliceSelector.setValue(Color_Clustering.this.image.getCurrentSlice());
                Color_Clustering.this.image.setSlice(Color_Clustering.this.image.getCurrentSlice());
                this.all.add((Component)this.sliceSelector, allConstraints);
                if (null != this.zSelector) {
                    this.all.add((Component)this.zSelector, allConstraints);
                }
                if (null != this.tSelector) {
                    this.all.add((Component)this.tSelector, allConstraints);
                }
                if (null != this.cSelector) {
                    this.all.add((Component)this.cSelector, allConstraints);
                }
            }
            --allConstraints.gridy;
            GridBagLayout wingb = new GridBagLayout();
            GridBagConstraints winc = new GridBagConstraints();
            winc.anchor = 10;
            winc.fill = 1;
            winc.weightx = 0.0;
            winc.weighty = 0.0;
            this.setLayout(wingb);
            this.add(this.all, winc);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    super.windowClosing(e);
                    if (null != Color_Clustering.this.originalImage) {
                        if (null == Color_Clustering.this.originalImage.getWindow()) {
                            Color_Clustering.this.originalImage.show();
                        }
                        Color_Clustering.this.originalImage.getWindow().setVisible(true);
                    }
                    if (null != Color_Clustering.this.currentTask) {
                        Color_Clustering.this.currentTask.interrupt();
                        Color_Clustering.this.currentTask.stop();
                    }
                    Color_Clustering.this.exec.shutdownNow();
                }
            });
            if (null != this.sliceSelector) {
                this.sliceSelector.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(final AdjustmentEvent e) {
                        Color_Clustering.this.exec.submit(new Runnable(){

                            @Override
                            public void run() {
                                if (e.getSource() == CustomWindow.this.sliceSelector) {
                                    CustomWindow.this.updateResultOverlay();
                                    Color_Clustering.this.image.updateAndDraw();
                                }
                            }
                        });
                    }
                });
                this.addMouseWheelListener(new MouseWheelListener(){

                    @Override
                    public void mouseWheelMoved(MouseWheelEvent e) {
                        Color_Clustering.this.exec.submit(new Runnable(){

                            @Override
                            public void run() {
                                CustomWindow.this.updateResultOverlay();
                                Color_Clustering.this.image.updateAndDraw();
                            }
                        });
                    }
                });
                KeyListener keyListener = new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }

                    @Override
                    public void keyReleased(final KeyEvent e) {
                        Color_Clustering.this.exec.submit(new Runnable(){

                            @Override
                            public void run() {
                                if (e.getKeyCode() == 37 || e.getKeyCode() == 39 || e.getKeyCode() == 153 || e.getKeyCode() == 160 || e.getKeyCode() == 44 || e.getKeyCode() == 46) {
                                    CustomWindow.this.updateResultOverlay();
                                    Color_Clustering.this.image.updateAndDraw();
                                }
                            }
                        });
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                    }
                };
                this.addKeyListener(keyListener);
                canvas.addKeyListener(keyListener);
            }
        }

        void enableComponents(boolean flag) {
            this.channelSelectionPanel.setEnabled(flag);
            for (int i = 0; i < this.channelCheckbox.length; ++i) {
                this.channelCheckbox[i].setEnabled(flag);
            }
            this.pixelSlider.setEnabled(flag);
            this.samplePanel.setEnabled(flag);
            this.clustererPanel.setEnabled(flag);
            this.clustererEditor.setEnabled(flag);
            for (Component c : this.clustererEditor.getCustomPanel().getComponents()) {
                c.setEnabled(flag);
            }
            this.runClusterButton.setEnabled(flag);
            this.opacitySlider.setEnabled(flag);
            this.createFile.setEnabled(flag);
            this.createResult.setEnabled(flag);
            this.createProbabilityMap.setEnabled(flag);
            this.visualizeData.setEnabled(flag);
            this.saveClusterer.setEnabled(flag);
            this.loadClusterer.setEnabled(flag);
        }

        void updateComponentEnabling() {
            this.channelSelectionPanel.setEnabled(true);
            for (int i = 0; i < this.channelCheckbox.length; ++i) {
                this.channelCheckbox[i].setEnabled(true);
            }
            this.pixelSlider.setEnabled(true);
            this.samplePanel.setEnabled(true);
            this.clustererPanel.setEnabled(true);
            this.clustererEditor.setEnabled(true);
            this.runClusterButton.setEnabled(true);
            this.opacitySlider.setEnabled(true);
            this.createFile.setEnabled(true);
            this.createResult.setEnabled(Color_Clustering.this.finishedClustering);
            this.createProbabilityMap.setEnabled(Color_Clustering.this.finishedClustering);
            this.visualizeData.setEnabled(true);
            this.saveClusterer.setEnabled(Color_Clustering.this.finishedClustering);
            this.loadClusterer.setEnabled(true);
        }

        boolean createFeatures() {
            boolean someChannelSelected = false;
            Color_Clustering.access$1402(Color_Clustering.this, new boolean[Color_Clustering.this.numChannels]);
            Color_Clustering.this.numChannels = ColorClustering.Channel.numChannels();
            for (int i = 0; i < Color_Clustering.this.numChannels; ++i) {
                JCheckBox selected = (JCheckBox)this.channelSelectionPanel.getComponent(i);
                ((Color_Clustering)Color_Clustering.this).selectedChannels[i] = selected.isSelected();
                if (!selected.isSelected() || someChannelSelected) continue;
                someChannelSelected = true;
            }
            if (someChannelSelected) {
                IJ.log((String)("Number of selected samples: " + Color_Clustering.this.numSamples));
                ArrayList<ColorClustering.Channel> channels = new ArrayList<ColorClustering.Channel>();
                for (int i = 0; i < Color_Clustering.this.numChannels; ++i) {
                    if (!Color_Clustering.this.selectedChannels[i]) continue;
                    ColorClustering.Channel channel = ColorClustering.Channel.fromLabel(ColorClustering.Channel.getAllLabels()[i]);
                    channels.add(channel);
                }
                Color_Clustering.this.colorClustering.setNumSamples(Color_Clustering.this.numSamples);
                Color_Clustering.this.colorClustering.setChannels(channels);
                IJ.log((String)"Creating features...");
                Color_Clustering.this.colorClustering.createFeatures();
                Color_Clustering.this.featureStackArray = Color_Clustering.this.colorClustering.getFeatureStackArray();
                Color_Clustering.this.featuresCreated = true;
                return true;
            }
            IJ.error((String)"Warning!", (String)"Choose at least a channel");
            this.runClusterButton.setText("Run");
            return false;
        }

        void visualizeData() {
            if (!Color_Clustering.this.featuresCreated && !this.createFeatures()) {
                return;
            }
            Instances train = Color_Clustering.this.colorClustering.getFeaturesInstances();
            ClusterEvaluation eval = new ClusterEvaluation();
            eval.setClusterer((Clusterer)Color_Clustering.this.clusterer);
            try {
                eval.evaluateClusterer(train);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ClustererAssignmentsPlotInstances plotInstances = new ClustererAssignmentsPlotInstances();
            plotInstances.setClusterer((Clusterer)Color_Clustering.this.clusterer);
            plotInstances.setInstances(train);
            plotInstances.setClusterEvaluation(eval);
            plotInstances.setUp();
            String name = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
            String cname = Color_Clustering.this.clusterer.getClass().getName();
            name = cname.startsWith("weka.clusterers.") ? name + cname.substring("weka.clusterers.".length()) : name + cname;
            name = name + " (" + train.relationName() + ")";
            VisualizePanel vp = new VisualizePanel();
            vp.setName(name);
            try {
                vp.addPlot(plotInstances.getPlotData(cname));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            JFrame jf = new JFrame("Weka Clusterer Visualize: " + vp.getName());
            jf.setDefaultCloseOperation(2);
            jf.setSize(500, 400);
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)vp, "Center");
            jf.setVisible(true);
        }

        void runClusterOrStop(String command) {
            if (command.equals("Run")) {
                this.enableComponents(false);
                this.runClusterButton.setEnabled(true);
                this.runClusterButton.setText("STOP");
                final Thread oldTask = Color_Clustering.this.currentTask;
                Thread newTask = new Thread(){

                    @Override
                    public void run() {
                        if (null != oldTask) {
                            try {
                                oldTask.join();
                            }
                            catch (InterruptedException ie) {
                                IJ.log((String)"interrupted");
                            }
                        }
                        Color_Clustering.this.clusterer = Color_Clustering.this.colorClustering.getTheClusterer();
                        CustomWindow.this.updateClusterer();
                        if (!Color_Clustering.this.featuresCreated && !CustomWindow.this.createFeatures()) {
                            Color_Clustering.this.finishedClustering = false;
                            CustomWindow.this.updateComponentEnabling();
                            return;
                        }
                        CustomWindow.this.buildClusterer();
                        IJ.log((String)"Creating clustered image...");
                        Color_Clustering.this.clusteredImage = Color_Clustering.this.colorClustering.createClusteredImage(Color_Clustering.this.featureStackArray);
                        CustomWindow.this.updateResultOverlay();
                        CustomWindow.this.runClusterButton.setText("Run");
                        CustomWindow.this.enableComponents(true);
                        Color_Clustering.this.finishedClustering = true;
                        IJ.log((String)"Done");
                    }
                };
                Color_Clustering.this.currentTask = newTask;
                newTask.start();
            } else if (command.equals("STOP")) {
                IJ.log((String)"Clustering stopped by user.");
                this.runClusterButton.setText("Run");
                this.enableComponents(true);
                if (null != Color_Clustering.this.currentTask) {
                    Color_Clustering.this.currentTask.interrupt();
                    Color_Clustering.this.currentTask.stop();
                } else {
                    IJ.log((String)"Error: Interrupting failed because thread was null!");
                }
            }
        }

        public void updateClusterer() {
            Object c = this.clustererEditor.getValue();
            String[] optionsArray = ((OptionHandler)c).getOptions();
            boolean update = false;
            if (Color_Clustering.this.clusterer != null) {
                String[] prevOptions = Color_Clustering.this.clusterer.getOptions();
                if (optionsArray.length != prevOptions.length) {
                    update = true;
                } else {
                    for (int i = 0; i < optionsArray.length; ++i) {
                        if (prevOptions[i].contentEquals(optionsArray[i])) continue;
                        update = true;
                        break;
                    }
                }
            } else {
                update = true;
            }
            if (update) {
                try {
                    Color_Clustering.this.clusterer = (AbstractClusterer)c.getClass().newInstance();
                    Color_Clustering.this.clusterer.setOptions(optionsArray);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.runClusterButton.setText("Run");
                    IJ.log((String)"Error when setting clusterer.");
                }
            }
        }

        public void buildClusterer() {
            IJ.log((String)"Building clusterer...");
            long startTime = System.currentTimeMillis();
            AbstractClusterer theClusterer = Color_Clustering.this.colorClustering.createClusterer(Color_Clustering.this.clusterer);
            long endTime = System.currentTimeMillis();
            Color_Clustering.this.colorClustering.setTheClusterer(theClusterer);
            IJ.log((String)theClusterer.toString());
            IJ.log((String)("Clusterer building took " + (endTime - startTime) + " ms."));
        }
    }
}

