/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.io.FileInfo;
import ij.io.FileSaver;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public final class Analyze_Writer
implements PlugIn {
    public void run(String arg) {
        ImageProcessor ip;
        int i;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        if (imp.getCalibration().isSigned16Bit() && IJ.versionLessThan((String)"1.34e")) {
            return;
        }
        String directory = "";
        String name = "";
        if (arg == null || arg == "") {
            SaveDialog sd = new SaveDialog("Save as Analyze", imp.getTitle(), ".img");
            directory = sd.getDirectory();
            name = sd.getFileName();
        } else {
            File file = new File(arg);
            if (file.isDirectory()) {
                directory = arg;
                name = imp.getTitle();
            } else {
                directory = file.getParent();
                name = file.getName();
            }
        }
        if (name == null || name == "") {
            return;
        }
        ImageStack stack = imp.getStack();
        for (i = 1; i <= stack.getSize(); ++i) {
            ip = stack.getProcessor(i);
            ip.flipVertical();
        }
        this.save(imp, directory, name);
        for (i = 1; i <= stack.getSize(); ++i) {
            ip = stack.getProcessor(i);
            ip.flipVertical();
        }
        IJ.showStatus((String)"");
    }

    public void save(ImagePlus imp, String directory, String name) {
        if (name == null) {
            return;
        }
        if (name.endsWith(".img")) {
            name = name.substring(0, name.length() - 4);
        }
        if (name.endsWith(".hdr")) {
            name = name.substring(0, name.length() - 4);
        }
        if (!directory.endsWith(File.separator) && !directory.equals("")) {
            directory = directory + File.separator;
        }
        IJ.showStatus((String)("Saving as Analyze: " + directory + name));
        try {
            String fileName = directory + name + ".hdr";
            this.writeHeader(imp, fileName);
            fileName = directory + name + ".img";
            if (imp.getStackSize() < 2) {
                new FileSaver(imp).saveAsRaw(fileName);
            } else {
                if (imp.getStackSize() > 1 && imp.getStack().isVirtual()) {
                    imp.setProperty("AnalyzeFormat", (Object)"true");
                }
                new FileSaver(imp).saveAsRawStack(fileName);
            }
        }
        catch (IOException e) {
            IJ.log((String)("Analyze_Writer: " + e.getMessage()));
        }
    }

    private void writeHeader(ImagePlus imp, String hdrfile) throws IOException {
        int i;
        short bitsallocated;
        short datatype;
        FileOutputStream fileout = new FileOutputStream(hdrfile);
        DataOutputStream output = new DataOutputStream(fileout);
        FileInfo fi = imp.getFileInfo();
        switch (fi.fileType) {
            case 0: {
                datatype = 2;
                bitsallocated = 8;
                break;
            }
            case 1: 
            case 2: {
                datatype = 4;
                bitsallocated = 16;
                break;
            }
            case 3: {
                datatype = 8;
                bitsallocated = 32;
                break;
            }
            case 4: {
                datatype = 16;
                bitsallocated = 32;
                break;
            }
            default: {
                datatype = 0;
                bitsallocated = (short)(fi.getBytesPerPixel() * 8);
            }
        }
        this.writeInt(output, 348);
        for (i = 0; i < 10; ++i) {
            output.write(0);
        }
        for (i = 0; i < 18; ++i) {
            output.write(0);
        }
        this.writeInt(output, 16384);
        output.writeShort(0);
        output.writeByte(114);
        output.writeByte(0);
        this.writeShort(output, (short)4);
        this.writeShort(output, (short)fi.width);
        this.writeShort(output, (short)fi.height);
        this.writeShort(output, (short)fi.nImages);
        this.writeShort(output, (short)1);
        for (i = 0; i < 3; ++i) {
            output.writeShort(0);
        }
        output.writeBytes("mm\u0000\u0000");
        for (i = 0; i < 8; ++i) {
            output.write(0);
        }
        output.writeShort(0);
        this.writeShort(output, datatype);
        this.writeShort(output, bitsallocated);
        output.writeShort(0);
        output.writeFloat(0.0f);
        this.writeFloat(output, (float)fi.pixelWidth);
        this.writeFloat(output, (float)fi.pixelHeight);
        this.writeFloat(output, (float)fi.pixelDepth);
        for (i = 0; i < 4; ++i) {
            output.writeFloat(0.0f);
        }
        output.writeFloat(0.0f);
        output.writeFloat(1.0f);
        output.writeFloat(0.0f);
        output.writeFloat(0.0f);
        output.writeFloat(0.0f);
        output.writeFloat(0.0f);
        output.writeInt(0);
        output.writeInt(0);
        ImageStatistics s = imp.getStatistics();
        this.writeInt(output, (int)s.max);
        this.writeInt(output, (int)s.min);
        for (i = 0; i < 80; ++i) {
            output.write(0);
        }
        for (i = 0; i < 24; ++i) {
            output.write(0);
        }
        output.write(0);
        for (i = 0; i < 10; ++i) {
            output.write(0);
        }
        for (i = 0; i < 10; ++i) {
            output.write(0);
        }
        for (i = 0; i < 10; ++i) {
            output.write(0);
        }
        for (i = 0; i < 10; ++i) {
            output.write(0);
        }
        for (i = 0; i < 10; ++i) {
            output.write(0);
        }
        for (i = 0; i < 10; ++i) {
            output.write(0);
        }
        for (i = 0; i < 3; ++i) {
            output.write(0);
        }
        output.writeInt(0);
        output.writeInt(0);
        output.writeInt(0);
        output.writeInt(0);
        output.writeInt(0);
        output.writeInt(0);
        output.writeInt(0);
        output.writeInt(0);
        output.close();
        fileout.close();
    }

    private void writeInt(DataOutputStream input, int value) throws IOException {
        input.writeInt(value);
    }

    private void writeShort(DataOutputStream input, short value) throws IOException {
        input.writeShort(value);
    }

    private void writeFloat(DataOutputStream input, float value) throws IOException {
        this.writeInt(input, Float.floatToIntBits(value));
    }

    void add(ImagePlus imp, int value) {
        ImageStack stack = imp.getStack();
        for (int slice = 1; slice <= stack.getSize(); ++slice) {
            ImageProcessor ip = stack.getProcessor(slice);
            short[] pixels = (short[])ip.getPixels();
            for (int i = 0; i < pixels.length; ++i) {
                pixels[i] = (short)((pixels[i] & 0xFFFF) + value);
            }
        }
    }
}

