/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.gvt.renderer.StaticRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class SVG_Reader
extends ImagePlus
implements PlugIn {
    public void run(String arg) {
        SVGDocument document;
        File file = null;
        if (arg != null && arg.length() > 0) {
            file = new File(arg);
        } else {
            OpenDialog od = new OpenDialog("Choose .svg file", null);
            String directory = od.getDirectory();
            if (null == directory) {
                return;
            }
            file = new File(directory + "/" + od.getFileName());
        }
        UserAgentAdapter userAgent = new UserAgentAdapter();
        StaticRenderer renderer = new StaticRenderer();
        DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
        BridgeContext context = new BridgeContext((UserAgent)userAgent, loader);
        userAgent.setBridgeContext(context);
        try {
            document = (SVGDocument)loader.loadDocument(file.toURI().toString());
        }
        catch (IOException e) {
            IJ.error((String)("Could not open " + file.toURI()));
            return;
        }
        GVTBuilder builder = new GVTBuilder();
        renderer.setTree(builder.build(context, (Document)document));
        SVGSVGElement root = document.getRootElement();
        float svgX = root.getX().getBaseVal().getValue();
        float svgY = root.getY().getBaseVal().getValue();
        float svgWidth = root.getWidth().getBaseVal().getValue();
        float svgHeight = root.getHeight().getBaseVal().getValue();
        GenericDialog gd = new GenericDialog("SVG dimensions");
        gd.addNumericField("width", (double)svgWidth, 0);
        gd.addNumericField("height", (double)svgHeight, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int w = (int)gd.getNextNumber();
        int h = (int)gd.getNextNumber();
        AffineTransform transform = new AffineTransform();
        transform.translate(-svgX, -svgY);
        transform.scale((float)w / svgWidth, (float)h / svgHeight);
        renderer.setTransform(transform);
        renderer.updateOffScreen(w, h);
        Rectangle r = new Rectangle(0, 0, w, h);
        renderer.repaint((Shape)r);
        this.setTitle(file.getName());
        this.setImage(renderer.getOffScreen());
        if (arg.equals("")) {
            this.show();
        }
    }
}

