/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.omevisual;

import ij.ImagePlus;
import io.scif.Metadata;
import io.scif.img.SCIFIOImgPlus;
import io.scif.ome.OMEMetadata;
import io.scif.services.TranslatorService;
import java.util.Map;
import loci.formats.ome.OMEXMLMetadata;
import net.imagej.Dataset;
import net.imagej.ImageJ;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.display.ImageDisplay;
import org.scijava.convert.ConvertService;
import org.scijava.ui.DialogPrompt;

public class OMEUtils {
    public static OMEXMLMetadata getOMEXMLMetadata(Dataset data, ImageJ ij, TranslatorService translatorService) {
        OMEMetadata omeMeta;
        ImgPlus imp = data.getImgPlus();
        if (!(imp instanceof SCIFIOImgPlus)) {
            ij.ui().showDialog("This image has not been opened with SCIFIO.", DialogPrompt.MessageType.ERROR_MESSAGE);
            return null;
        }
        SCIFIOImgPlus sciImp = (SCIFIOImgPlus)imp;
        Metadata metadata = sciImp.getMetadata();
        if (!translatorService.translate(metadata, (Metadata)(omeMeta = new OMEMetadata(translatorService.getContext())), true)) {
            ij.ui().showDialog("Unable to extract OME Metadata", DialogPrompt.MessageType.ERROR_MESSAGE);
            return null;
        }
        OMEXMLMetadata ome = omeMeta.getRoot();
        return ome;
    }

    public static void setPosition(ImageDisplay image, Map<AxisType, Long> positions, ConvertService convert) {
        positions.forEach((axis, position) -> image.setPosition(position.longValue(), axis));
        ImagePlus imp = (ImagePlus)convert.convert((Object)image, ImagePlus.class);
        if (positions.get(Axes.Z).intValue() >= 0) {
            imp.setZ(positions.get(Axes.Z).intValue() + 1);
        }
        if (positions.get(Axes.CHANNEL).intValue() >= 0) {
            imp.setC(positions.get(Axes.CHANNEL).intValue() + 1);
        }
        if (positions.get(Axes.TIME).intValue() >= 0) {
            imp.setT(positions.get(Axes.TIME).intValue() + 1);
        }
    }
}

