/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.catmaid;

import bdv.img.catmaid.CatmaidImageLoader;
import java.io.File;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.ImgLoaderIo;
import mpicbg.spim.data.generic.sequence.XmlIoBasicImgLoader;
import org.jdom2.Element;

@ImgLoaderIo(format="catmaid", type=CatmaidImageLoader.class)
public class XmlIoCatmaidImageLoader
implements XmlIoBasicImgLoader<CatmaidImageLoader> {
    public Element toXml(CatmaidImageLoader imgLoader, File basePath) {
        throw new UnsupportedOperationException("not implemented");
    }

    public CatmaidImageLoader fromXml(Element elem, File basePath, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        long width = Long.parseLong(elem.getChildText("width"));
        long height = Long.parseLong(elem.getChildText("height"));
        long depth = Long.parseLong(elem.getChildText("depth"));
        double resXY = Double.parseDouble(elem.getChildText("resXY"));
        double resZ = Double.parseDouble(elem.getChildText("resZ"));
        String urlFormat = elem.getChildText("urlFormat");
        int tileWidth = Integer.parseInt(elem.getChildText("tileWidth"));
        int tileHeight = Integer.parseInt(elem.getChildText("tileHeight"));
        String blockWidthString = elem.getChildText("blockWidth");
        String blockHeightString = elem.getChildText("blockHeight");
        String blockDepthString = elem.getChildText("blockDepth");
        int blockWidth = blockWidthString == null ? tileWidth : Integer.parseInt(blockWidthString);
        int blockHeight = blockHeightString == null ? tileHeight : Integer.parseInt(blockHeightString);
        int blockDepth = blockDepthString == null ? 1 : Integer.parseInt(blockDepthString);
        System.out.println(String.format("Block size = (%d, %d, %d)", blockWidth, blockHeight, blockDepth));
        String numScalesString = elem.getChildText("numScales");
        int numScales = numScalesString == null ? CatmaidImageLoader.getNumScales(width, height, tileWidth, tileHeight) : Integer.parseInt(numScalesString);
        int[][] blockSize = new int[numScales][];
        for (int i = 0; i < numScales; ++i) {
            blockSize[i] = new int[]{blockWidth, blockHeight, blockDepth};
        }
        return new CatmaidImageLoader(width, height, depth, resZ / resXY, urlFormat, tileWidth, tileHeight, blockSize);
    }
}

