/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.boundingbox;

import org.scijava.ui.behaviour.io.InputTriggerConfig;

public class BoxSelectionOptions {
    public final Values values = new Values();

    public static BoxSelectionOptions options() {
        return new BoxSelectionOptions();
    }

    public BoxSelectionOptions selectSingleTimepoint(int rangeMin, int rangeMax) {
        this.values.timepointSelection = TimepointSelection.SINGLE;
        this.values.rangeMinTimepoint = rangeMin;
        this.values.rangeMaxTimepoint = rangeMax;
        return this;
    }

    public BoxSelectionOptions selectSingleTimepoint() {
        this.values.timepointSelection = TimepointSelection.SINGLE;
        return this;
    }

    public BoxSelectionOptions initialTimepoint(int t) {
        this.values.initialMinTimepoint = t;
        return this;
    }

    public BoxSelectionOptions initialTimepointRange(int initialMin, int initialMax) {
        this.values.initialMinTimepoint = initialMin;
        this.values.initialMaxTimepoint = initialMax;
        return this;
    }

    public BoxSelectionOptions selectTimepointRange(int rangeMin, int rangeMax) {
        this.values.timepointSelection = TimepointSelection.RANGE;
        this.values.rangeMinTimepoint = rangeMin;
        this.values.rangeMaxTimepoint = rangeMax;
        return this;
    }

    public BoxSelectionOptions selectTimepointRange() {
        this.values.timepointSelection = TimepointSelection.RANGE;
        return this;
    }

    public BoxSelectionOptions title(String title) {
        this.values.title = title;
        return this;
    }

    public static class Values {
        private TimepointSelection timepointSelection = TimepointSelection.NONE;
        private int rangeMinTimepoint = 0;
        private int rangeMaxTimepoint = Integer.MAX_VALUE;
        private int initialMinTimepoint = 0;
        private int initialMaxTimepoint = Integer.MAX_VALUE;
        private String title = "Select Bounding Box";
        private final InputTriggerConfig inputTriggerConfig = null;

        public TimepointSelection getTimepointSelection() {
            return this.timepointSelection;
        }

        public int getRangeMinTimepoint() {
            return this.rangeMinTimepoint;
        }

        public int getRangeMaxTimepoint() {
            return this.rangeMaxTimepoint;
        }

        public int getInitialMinTimepoint() {
            return this.initialMinTimepoint;
        }

        public int getInitialMaxTimepoint() {
            return this.initialMaxTimepoint;
        }

        public String getTitle() {
            return this.title;
        }

        public InputTriggerConfig getInputTriggerConfig() {
            return this.inputTriggerConfig;
        }
    }

    public static enum TimepointSelection {
        NONE,
        SINGLE,
        RANGE;

    }
}

