/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree.fieldaccess;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Iterator;
import java.util.Map;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.misc.Strings;
import net.thisptr.jackson.jq.path.ArrayIndexPath;
import net.thisptr.jackson.jq.path.ArrayRangeIndexPath;
import net.thisptr.jackson.jq.path.ObjectFieldPath;
import net.thisptr.jackson.jq.path.Path;

public abstract class FieldAccess
implements Expression {
    protected final Expression target;
    protected final boolean permissive;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public FieldAccess(Expression target, boolean permissive) {
        this.target = target;
        this.permissive = permissive;
    }

    protected static void emitAllPath(boolean permissive, JsonNode pobj, Path ppath, PathOutput output, boolean requirePath) throws JsonQueryException {
        if (requirePath && ppath == null) {
            throw new JsonQueryException("Invalid path expression near attempt to iterate through %s", JsonNodeUtils.toString(pobj));
        }
        if (pobj.isNull()) {
            if (!permissive) {
                throw new JsonQueryException("Cannot iterate over null (null)");
            }
        } else if (pobj.isArray()) {
            for (int i = 0; i < pobj.size(); ++i) {
                output.emit(pobj.get(i), ArrayIndexPath.chainIfNotNull(ppath, i));
            }
        } else if (pobj.isObject()) {
            Iterator iter = pobj.fields();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                output.emit((JsonNode)entry.getValue(), ObjectFieldPath.chainIfNotNull(ppath, (String)entry.getKey()));
            }
        } else if (!permissive) {
            throw new JsonQueryTypeException("Cannot iterate over %s", pobj);
        }
    }

    protected static void emitObjectFieldPath(boolean permissive, String key, JsonNode pobj, Path ppath, PathOutput output, boolean requirePath) throws JsonQueryException {
        if (requirePath && ppath == null) {
            throw new JsonQueryException("Invalid path expression near attempt to access element %s of %s", JsonNodeUtils.toString((JsonNode)TextNode.valueOf((String)key)), JsonNodeUtils.toString(pobj));
        }
        ObjectFieldPath.resolve(pobj, ppath, output, key, permissive);
    }

    protected static void emitArrayIndexPath(boolean permissive, JsonNode index, JsonNode pobj, Path ppath, PathOutput output, boolean requirePath) throws JsonQueryException {
        assert (index.isNumber());
        if (requirePath && ppath == null) {
            throw new JsonQueryException("Invalid path expression near attempt to access element %s of %s", JsonNodeUtils.toString(index), JsonNodeUtils.toString(pobj));
        }
        ArrayIndexPath.resolve(pobj, ppath, output, index, permissive);
    }

    protected static void emitArrayRangeIndexPath(boolean permissive, JsonNode start, JsonNode end, JsonNode pobj, Path ppath, PathOutput output, boolean requirePath) throws JsonQueryException {
        assert (start.isNull() || start.isNumber());
        assert (end.isNull() || end.isNumber());
        if (requirePath && ppath == null) {
            ObjectNode subpath = MAPPER.createObjectNode();
            subpath.set("start", start);
            subpath.set("end", end);
            throw new JsonQueryException("Invalid path expression near attempt to access element %s of %s", Strings.truncate(JsonNodeUtils.toString((JsonNode)subpath), 14), JsonNodeUtils.toString(pobj));
        }
        ArrayRangeIndexPath.resolve(pobj, ppath, output, start, end, permissive);
    }
}

