/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation.nearestneighbor;

import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.InterpolatorImpl;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.util.Util;

public class NearestNeighborInterpolator<T extends Type<T>>
extends InterpolatorImpl<T> {
    final LocalizableByDimCursor<T> cursor;

    protected NearestNeighborInterpolator(Image<T> img, InterpolatorFactory<T> interpolatorFactory, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(img, interpolatorFactory, outOfBoundsStrategyFactory);
        this.cursor = img.createLocalizableByDimCursor(outOfBoundsStrategyFactory);
        this.moveTo(this.position);
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public T getType() {
        return this.cursor.getType();
    }

    @Override
    public void moveTo(float[] pos) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.position[d] = pos[d];
            int p = Util.round(pos[d]);
            this.cursor.move(p - this.cursor.getPosition(d), d);
        }
    }

    @Override
    public void moveTo(double[] pos) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.position[d] = (float)pos[d];
            int p = Util.round(this.position[d]);
            this.cursor.move(p - this.cursor.getPosition(d), d);
        }
    }

    @Override
    public void moveRel(float[] vector) {
        for (int d = 0; d < this.numDimensions; ++d) {
            int n = d;
            this.position[n] = this.position[n] + vector[d];
            int pos = Util.round(this.position[d]);
            this.cursor.move(pos - this.cursor.getPosition(d), d);
        }
    }

    @Override
    public void moveRel(double[] vector) {
        for (int d = 0; d < this.numDimensions; ++d) {
            int n = d;
            this.position[n] = (float)((double)this.position[n] + vector[d]);
            int pos = Util.round(this.position[d]);
            this.cursor.move(pos - this.cursor.getPosition(d), d);
        }
    }

    @Override
    public void setPosition(float[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.position[d] = position[d];
            int pos = Util.round(position[d]);
            this.cursor.setPosition(pos, d);
        }
    }

    @Override
    public void setPosition(double[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.position[d] = (float)position[d];
            int pos = Util.round(this.position[d]);
            this.cursor.setPosition(pos, d);
        }
    }
}

