/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.integer;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.basictypecontainer.ByteAccess;
import mpicbg.imglib.container.basictypecontainer.array.ByteArray;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.type.numeric.integer.IntegerTypeImpl;
import mpicbg.imglib.util.Util;

public abstract class GenericByteType<T extends GenericByteType<T>>
extends IntegerTypeImpl<T> {
    final DirectAccessContainer<T, ? extends ByteAccess> storage;
    ByteAccess b;

    public GenericByteType(DirectAccessContainer<T, ? extends ByteAccess> byteStorage) {
        this.storage = byteStorage;
    }

    protected GenericByteType(byte value) {
        this.storage = null;
        this.b = new ByteArray(1);
        this.setValue(value);
    }

    protected GenericByteType() {
        this(0);
    }

    @Override
    public void updateContainer(Cursor<?> c) {
        this.b = this.storage.update(c);
    }

    protected byte getValue() {
        return this.b.getValue(this.i);
    }

    protected void setValue(byte f) {
        this.b.setValue(this.i, f);
    }

    @Override
    public void mul(float c) {
        byte a = this.getValue();
        this.setValue((byte)Util.round((float)a * c));
    }

    @Override
    public void mul(double c) {
        byte a = this.getValue();
        this.setValue((byte)Util.round((double)a * c));
    }

    @Override
    public void add(T c) {
        byte a = this.getValue();
        this.setValue((byte)(a + ((GenericByteType)c).getValue()));
    }

    @Override
    public void div(T c) {
        byte a = this.getValue();
        this.setValue((byte)(a / ((GenericByteType)c).getValue()));
    }

    @Override
    public void mul(T c) {
        byte a = this.getValue();
        this.setValue((byte)(a * ((GenericByteType)c).getValue()));
    }

    @Override
    public void sub(T c) {
        byte a = this.getValue();
        this.setValue((byte)(a - ((GenericByteType)c).getValue()));
    }

    @Override
    public int compareTo(T c) {
        byte b;
        byte a = this.getValue();
        if (a > (b = ((GenericByteType)c).getValue())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    @Override
    public void set(T c) {
        this.setValue(((GenericByteType)c).getValue());
    }

    @Override
    public void setOne() {
        this.setValue((byte)1);
    }

    @Override
    public void setZero() {
        this.setValue((byte)0);
    }

    @Override
    public void inc() {
        byte a = this.getValue();
        a = (byte)(a + 1);
        this.setValue(a);
    }

    @Override
    public void dec() {
        byte a = this.getValue();
        a = (byte)(a - 1);
        this.setValue(a);
    }

    @Override
    public String toString() {
        return "" + this.getValue();
    }
}

