/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm;

import mpicbg.imglib.algorithm.roi.StructuringElement;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.math.Compute;
import script.imglib.math.fn.IFunction;

public class MedianFilter<T extends RealType<T>>
extends Image<T> {
    public MedianFilter(Image<T> img, float radius) throws Exception {
        this(img, radius, new OutOfBoundsStrategyMirrorFactory());
    }

    public MedianFilter(Image<T> img, float radius, OutOfBoundsStrategyFactory<T> oobs) throws Exception {
        super(MedianFilter.process(img, radius, oobs).getContainer(), img.createType());
    }

    public MedianFilter(IFunction fn, float radius) throws Exception {
        this(Compute.inDoubles(fn), radius, new OutOfBoundsStrategyMirrorFactory());
    }

    public MedianFilter(IFunction fn, float radius, OutOfBoundsStrategyFactory<T> oobs) throws Exception {
        this(Compute.inDoubles(fn), radius, oobs);
    }

    private static final <S extends RealType<S>> Image<S> process(Image<S> img, float radius, OutOfBoundsStrategyFactory<S> oobs) throws Exception {
        mpicbg.imglib.algorithm.roi.MedianFilter<S> mf = new mpicbg.imglib.algorithm.roi.MedianFilter<S>(img, StructuringElement.createBall(img.getNumDimensions(), radius), oobs);
        if (!mf.process()) {
            throw new Exception("MedianFilter: " + mf.getErrorMessage());
        }
        return mf.getResult();
    }
}

