/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJAlphaColor;
import VolumeJ.VJClassifier;
import VolumeJ.VJGradient;
import VolumeJ.VJInterpolator;
import VolumeJ.VJMatrix;
import VolumeJ.VJPlane;
import VolumeJ.VJShader;
import VolumeJ.VJUserInterface;
import VolumeJ.VJValue;
import VolumeJ.VJVoxelLoc;
import ij.IJ;
import volume.Volume;

public class VJCutout {
    private VJMatrix m;
    private VJMatrix mi;
    private Volume v;
    private VJPlane x;
    private VJPlane y;
    private VJPlane z;
    private float[] center;
    private VJClassifier classifier;
    private VJShader shader;
    private VJInterpolator interpolator;
    private int xcutout;
    private int ycutout;
    private int zcutout;

    public VJCutout(Volume v, int xcutout, int ycutout, int zcutout, VJInterpolator interpolator, VJShader shader, VJClassifier classifier) {
        this.m = this.m;
        this.mi = this.mi;
        this.v = v;
        this.classifier = classifier;
        this.shader = shader;
        this.interpolator = interpolator;
        this.xcutout = xcutout;
        this.ycutout = ycutout;
        this.zcutout = zcutout;
        if (!classifier.doesCutouts()) {
            VJUserInterface.error("Please select another classifier that can classify cutouts.");
            return;
        }
        VJUserInterface.write("Cutout center at " + xcutout + ", " + ycutout + ", " + zcutout);
    }

    public void setup(VJMatrix m, VJMatrix mi) {
        this.m = m;
        this.mi = mi;
        float[] centeros = new float[4];
        float[] p2 = new float[4];
        float[] p3 = new float[4];
        centeros[0] = this.xcutout;
        centeros[1] = this.ycutout;
        centeros[2] = this.zcutout;
        centeros[3] = 1.0f;
        p2[0] = this.xcutout;
        p2[1] = this.ycutout + 1;
        p2[2] = this.zcutout + 1;
        p2[3] = 1.0f;
        p3[0] = this.xcutout;
        p3[1] = this.ycutout - 1;
        p3[2] = this.zcutout + 1;
        p3[3] = 1.0f;
        this.center = m.mul(centeros);
        this.x = new VJPlane(this.center, m.mul(p2), m.mul(p3));
        p2[0] = this.xcutout + 1;
        p2[1] = this.ycutout;
        p2[2] = this.zcutout + 1;
        p2[3] = 1.0f;
        p3[0] = this.xcutout - 1;
        p3[1] = this.ycutout;
        p3[2] = this.zcutout + 1;
        p3[3] = 1.0f;
        this.y = new VJPlane(this.center, m.mul(p2), m.mul(p3));
        p2[0] = this.xcutout + 1;
        p2[1] = this.ycutout + 1;
        p2[2] = this.zcutout;
        p2[3] = 1.0f;
        p3[0] = this.xcutout - 1;
        p3[1] = this.ycutout + 1;
        p3[2] = this.zcutout;
        p3[3] = 1.0f;
        this.z = new VJPlane(this.center, m.mul(p2), m.mul(p3));
    }

    public void cutout(VJAlphaColor ac, int i, int j, int k) {
        float[] zis;
        float[] yis;
        float[] xis;
        float[] nearest;
        if ((double)ac.getAlpha() > 0.5 && (nearest = this.findNearestIntersection(xis = new float[]{i, j, this.x.intersectRay(i, j)}, yis = new float[]{i, j, this.y.intersectRay(i, j)}, zis = new float[]{i, j, this.z.intersectRay(i, j)})) != null && (float)k < nearest[2] && nearest[2] <= this.center[2]) {
            if (IJ.debugMode) {
                IJ.log((String)("nearest intersection " + nearest[0] + "," + nearest[1] + "," + nearest[2]));
            }
            float[] vos = this.mi.mul(nearest);
            VJVoxelLoc vl = new VJVoxelLoc(vos);
            VJValue value = new VJValue();
            this.interpolator.value(value, this.v, vl);
            VJAlphaColor nac = this.classifier.alphacolor(value);
            VJGradient g = nearest == xis ? this.x.getGradient() : (nearest == yis ? this.y.getGradient() : this.z.getGradient());
            nac.attenuate(this.shader.shade(g));
            ac.copy(nac);
        }
    }

    private float[] findNearestIntersection(float[] is1, float[] is2, float[] is3) {
        float[] nearest = is1;
        if (nearest == null || is2 != null && is2[2] < nearest[2]) {
            nearest = is2;
        }
        if (nearest == null || is3 != null && is3[2] < nearest[2]) {
            nearest = is3;
        }
        return nearest;
    }
}

