/*
 * Decompiled with CFR 0.152.
 */
package knn;

import bijnum.BIJstats;
import java.util.Enumeration;
import java.util.Vector;

public class Feature {
    public float[] vector;
    public String name;

    public Feature(String name, float[] vector) {
        this.vector = vector;
        this.name = name;
    }

    public Feature(String name, byte[] vector) {
        float[] fv = new float[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            fv[i] = vector[i];
        }
        this.vector = fv;
        this.name = name;
    }

    public void unitvar() {
        this.vector = BIJstats.unitvar(this.vector);
    }

    public float[] toVector() {
        return this.vector;
    }

    public String toString() {
        return this.name;
    }

    public int length() {
        return this.vector.length;
    }

    public static float[][] toMatrix(Vector features) {
        float[][] matrix = new float[features.size()][];
        int i = 0;
        Enumeration e = features.elements();
        while (e.hasMoreElements()) {
            matrix[i++] = (float[])e.nextElement();
        }
        return matrix;
    }

    public static Vector add(Vector features, Feature[] newfeatures) {
        for (int i = 0; i < newfeatures.length; ++i) {
            features.addElement(newfeatures[i]);
        }
        return features;
    }

    public static Vector add(Vector features, Feature newfeature) {
        features.addElement(newfeature);
        return features;
    }

    public static Vector add(Vector features, Vector newfeatures) {
        Enumeration e = newfeatures.elements();
        while (e.hasMoreElements()) {
            features.addElement(e.nextElement());
        }
        return features;
    }

    public static String[] toString(Vector features) {
        String[] sa = new String[features.size()];
        int i = 0;
        Enumeration e = features.elements();
        while (e.hasMoreElements()) {
            sa[i++] = (String)e.nextElement();
        }
        return sa;
    }
}

